/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.wml.errors.WmlAmlHandlerError;
import com.aligo.modules.wml.events.WmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddXmlWmlAttributeHandletEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.util.wml.TextUtils;
import com.aligo.wml.WmlPCData;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class WmlAmlTextAttributeHandlet
extends WmlAmlStylePathHandlet {
    public static final String ENCODE = "encode";
    public static final String ENCODE_FALSE = "false";
    private Hashtable oTextIndices = new Hashtable();
    private Hashtable oOutputContainers = new Hashtable();
    private Hashtable oDetachFlags = new Hashtable();

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlShouldDetachTextMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlResetTextStateHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlStylePathRelevance() {
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddXmlAmlAddAttributeHandletEvent) {
            WmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            try {
                AmlPathInterface currentAmlPath = addAttributeEvent.getAmlPath();
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
                WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, currentAmlPath, styleXmlElement);
                String wmlName = addAttributeEvent.getWmlName();
                if (currentAmlElement instanceof AxmlText && wmlElement instanceof WmlPCData && wmlName.equals("text")) {
                    currentWmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentWmlAmlStylePathRelevance;
    }

    public long wmlAmlRelevance() {
        long currentWmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlDetachFromTreeMemoryHandlerEvent) {
            if (this.doesTextPathExist(this.oCurrentAmlPath) && !this.shouldDetach(this.oCurrentAmlPath)) {
                currentWmlAmlRelevance = 30L;
            }
        } else {
            currentWmlAmlRelevance = this.oCurrentEvent instanceof WmlAmlShouldDetachTextMemoryHandlerEvent ? 30L : (this.oCurrentEvent instanceof WmlAmlResetTextStateHandlerEvent ? 20L : super.wmlAmlRelevance());
        }
        return currentWmlAmlRelevance;
    }

    private boolean doesTextPathExist(AmlPathInterface amlPath) {
        boolean textPathExist = false;
        Integer iLastIndex = (Integer)this.oTextIndices.get(amlPath.getCanonicalPath());
        if (iLastIndex != null) {
            textPathExist = true;
        }
        return textPathExist;
    }

    private boolean shouldDetach(AmlPathInterface amlPath) {
        boolean detach = true;
        Boolean bDetach = (Boolean)this.oDetachFlags.get(amlPath.getCanonicalPath());
        if (bDetach != null) {
            detach = bDetach;
        }
        return detach;
    }

    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof WmlAmlAddXmlAmlAddAttributeHandletEvent) {
            WmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            boolean memoryError = false;
            try {
                WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                String wmlName = addAttributeEvent.getWmlName();
                String wmlValue = addAttributeEvent.getWmlValue();
                if (wmlValue != null) {
                    String value = "";
                    AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    if (currentAmlElement instanceof AxmlText && wmlElement instanceof WmlPCData && wmlName.equals("text")) {
                        int lastIndex;
                        Integer iLastIndex;
                        String pathString = this.oCurrentAmlPath.getCanonicalPath();
                        Vector strContainer = (Vector)this.oOutputContainers.get(pathString);
                        if (strContainer == null) {
                            strContainer = new Vector();
                            String encodeValue = currentAmlElement.getAxmlAttributeValue(ENCODE);
                            boolean encode = true;
                            if (encodeValue != null && encodeValue.equals(ENCODE_FALSE)) {
                                encode = false;
                            }
                            TextUtils.prepareOutput(wmlValue, this.oUAProfile.getScreenWidthChar(), strContainer, encode);
                            this.oOutputContainers.put(pathString, strContainer);
                        }
                        if ((iLastIndex = (Integer)this.oTextIndices.get(pathString)) == null) {
                            lastIndex = 0;
                            iLastIndex = new Integer(lastIndex);
                            this.oTextIndices.put(pathString, iLastIndex);
                        } else {
                            lastIndex = iLastIndex;
                        }
                        WmlAmlGetRemainingMemoryHandlerEvent getRemainingMemoryEvent = new WmlAmlGetRemainingMemoryHandlerEvent(this.oCurrentAmlPath);
                        this.oHandlerManager.postEventNow(getRemainingMemoryEvent);
                        long remainingMemory = getRemainingMemoryEvent.getNumberBytes();
                        int numberElements = strContainer.size();
                        long memory = 0L;
                        boolean done = false;
                        boolean detach = false;
                        int i = lastIndex;
                        while (i < numberElements && !done) {
                            String element = (String)strContainer.elementAt(i);
                            long elementMemory = element.getBytes().length;
                            if ((memory += elementMemory) > remainingMemory) {
                                done = true;
                                if (i == lastIndex) {
                                    detach = true;
                                }
                                lastIndex = i;
                            } else {
                                value = value + element;
                            }
                            ++i;
                        }
                        this.oDetachFlags.put(pathString, new Boolean(detach));
                        if (done) {
                            this.oTextIndices.put(pathString, new Integer(lastIndex));
                            memoryError = true;
                        } else {
                            this.clearState(this.oCurrentAmlPath);
                        }
                        WmlAmlAddXmlWmlAttributeHandletEvent addXmlWmlAttributeEvent = new WmlAmlAddXmlWmlAttributeHandletEvent(this.oCurrentAmlPath, wmlElement, wmlName, value);
                        this.oHandlerManager.postEventNow(addXmlWmlAttributeEvent);
                    }
                }
                if (memoryError) {
                    throw new HandlerError(new WmlAmlInsufficientMemoryException());
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void handleException(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            HandlerError he = (HandlerError)ex;
            Exception eex = he.getException();
            if (eex instanceof WmlAmlInsufficientMemoryException) {
                throw he;
            }
        } else {
            this.oHandlerLogger.logError(ex);
        }
    }

    public void clearState(AmlPathInterface amlPath) {
        String pathString = amlPath.getCanonicalPath();
        this.oTextIndices.remove(pathString);
        this.oOutputContainers.remove(pathString);
        this.oDetachFlags.remove(pathString);
    }

    public void handleEventNow() throws HandlerError {
        if (!(this.oCurrentEvent instanceof WmlAmlDetachFromTreeMemoryHandlerEvent)) {
            if (this.oCurrentEvent instanceof WmlAmlShouldDetachTextMemoryHandlerEvent) {
                WmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = (WmlAmlShouldDetachTextMemoryHandlerEvent)this.oCurrentEvent;
                AmlPathInterface currentAmlPath = shouldDetachTextMemoryEvent.getAmlPath();
                boolean detach = true;
                if (currentAmlPath != null) {
                    detach = this.shouldDetach(currentAmlPath);
                }
                shouldDetachTextMemoryEvent.setDetach(detach);
            } else if (this.oCurrentEvent instanceof WmlAmlResetTextStateHandlerEvent) {
                try {
                    AmlPathInterface currentAmlPath = ((WmlAmlResetTextStateHandlerEvent)this.oCurrentEvent).getAmlPath();
                    this.clearState(currentAmlPath);
                }
                catch (Exception ex) {
                    throw new WmlAmlHandlerError(ex);
                }
            } else {
                super.handleEventNow();
            }
        }
    }
}

