/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.wml.amlhandlets.events.WmlAmlAddWmlEventHandletEvent;
import com.aligo.modules.wml.events.WmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlAddAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddNextAttributeHandletEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.wml.WmlInput;
import com.aligo.wml.WmlRefresh;
import com.aligo.wml.WmlSelect;
import com.aligo.wml.WmlSetvar;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class WmlAmlResetInputValueHandlet
extends WmlAmlStylePathHandlet {
    private static final String EMPTY = "";
    private static final String INPUT_VALUE_RESET = "input-value-reset";
    private static final String PAGE_CLASS = "com.aligo.axml.AxmlPage";
    private XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    private Hashtable oRefreshContainer = new Hashtable();

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlStylePathRelevance() {
        XmlAmlHandlerAttributeInterface xmlAmlHandlerAttribute;
        WmlAmlAddAttributeHandletEvent addAttributeEvent;
        XmlAttributeInterface xmlAttribute;
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent && (xmlAttribute = (addAttributeEvent = (WmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getXmlAttribute()) instanceof XmlAmlHandlerAttributeInterface && (xmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)xmlAttribute).getAmlAttributeName().equals("value")) {
            try {
                WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                if (wmlElement instanceof WmlInput || wmlElement instanceof WmlSelect) {
                    this.oXmlAmlHandlerAttribute = xmlAmlHandlerAttribute;
                    currentWmlAmlStylePathRelevance = 20L;
                }
            }
            catch (HandlerError he) {
                this.oHandlerLogger.logError(he);
            }
        }
        return currentWmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            boolean memoryError;
            AmlPathInterface currentAmlPath;
            block7: {
                WmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
                currentAmlPath = addAttributeEvent.getAmlPath();
                memoryError = false;
                try {
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    String value = amlElement.getAxmlAttributeValue("value");
                    if (value != null) {
                        String name = amlElement.getAxmlAttributeValue("name");
                        this.resetValue(name, currentAmlPath);
                    }
                }
                catch (Exception ex) {
                    HandlerError he;
                    Exception cex;
                    if (ex instanceof HandlerError && (cex = (he = (HandlerError)ex).getException()) instanceof WmlAmlInsufficientMemoryException) {
                        memoryError = true;
                    }
                    if (memoryError) break block7;
                    this.oHandlerLogger.logError(ex);
                }
            }
            if (memoryError) {
                WmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new WmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                WmlAmlAddNextAttributeHandletEvent addNextAttributeHandletEvent = new WmlAmlAddNextAttributeHandletEvent(currentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(addNextAttributeHandletEvent);
            }
        }
    }

    private void resetValue(String name, AmlPathInterface currentAmlPath) throws Exception {
        WmlRefresh refresh = this.getRefresh(currentAmlPath);
        WmlSetvar setvar = new WmlSetvar();
        setvar.addWmlAttribute("name", name);
        setvar.addWmlAttribute("value", EMPTY);
        refresh.addWmlElement(setvar);
    }

    private String getIdentifier(AmlPathInterface currentAmlPath) {
        AmlPathInterface idPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, PAGE_CLASS);
        if (idPath == null) {
            idPath = currentAmlPath;
        }
        return idPath.toString();
    }

    private WmlRefresh getRefresh(AmlPathInterface currentAmlPath) throws HandlerError {
        String pathId = this.getIdentifier(currentAmlPath);
        WmlRefresh wmlRefresh = (WmlRefresh)this.oRefreshContainer.get(pathId);
        if (wmlRefresh == null) {
            wmlRefresh = new WmlRefresh();
            WmlAmlAddWmlEventHandletEvent addWmlEvent = new WmlAmlAddWmlEventHandletEvent(currentAmlPath, INPUT_VALUE_RESET, "onenterforward", wmlRefresh);
            this.oHandlerManager.postEventNow(addWmlEvent);
            this.oRefreshContainer.put(pathId, wmlRefresh);
        }
        return wmlRefresh;
    }
}

