/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.AxmlImage;
import com.aligo.axml.AxmlLink;
import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.wml.amlhandlets.events.WmlAmlCreateLinkHandletEvent;
import com.aligo.modules.wml.handlets.WmlAmlHandlet;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.wml.WmlA;
import com.aligo.wml.WmlImg;
import com.aligo.wml.WmlPCData;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Vector;

public class WmlAmlLinkUrlHandlet
extends WmlAmlHandlet {
    WmlElement wmlElement;

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlCreateLinkHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlRelevance() {
        long currentWmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlCreateLinkHandletEvent) {
            currentWmlAmlRelevance = 20L;
        }
        return currentWmlAmlRelevance;
    }

    public void handleEventNow() throws HandlerError {
        this.oCurrentEvent = this.oEvent;
        if (this.oCurrentEvent instanceof WmlAmlCreateLinkHandletEvent) {
            WmlAmlCreateLinkHandletEvent createLinkEvent = (WmlAmlCreateLinkHandletEvent)this.oCurrentEvent;
            try {
                AxmlLink axmlLink = createLinkEvent.getAxmlLink();
                if (axmlLink != null) {
                    WmlElement wmlLink = this.createLink(axmlLink);
                    createLinkEvent.setWmlElement(wmlLink);
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
    }

    private WmlElement createLink(AxmlLink axmlLink) {
        WmlA wmlLink = new WmlA();
        try {
            String url = axmlLink.getAxmlAttributeValue("url");
            wmlLink.addWmlAttribute("href", url);
            int numberElements = axmlLink.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                AxmlElement axmlElement = axmlLink.axmlElementAt(i);
                if (axmlElement instanceof AxmlText) {
                    WmlPCData wmlPCData = new WmlPCData();
                    wmlPCData.setText(((AxmlText)axmlElement).getAxmlAttributeValue("text"));
                    wmlLink.addWmlElement(wmlPCData);
                } else if (axmlElement instanceof AxmlImage) {
                    WmlImg wmlImg = new WmlImg();
                    wmlImg.addWmlAttribute("src", ((AxmlImage)axmlElement).getAxmlAttributeValue("src"));
                    wmlImg.addWmlAttribute("alt", ((AxmlImage)axmlElement).getAxmlAttributeValue("alt"));
                    wmlLink.addWmlElement(wmlImg);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wmlLink;
    }
}

