/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.wml.events.WmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlAddAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddNextAttributeHandletEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.wml.WmlSelect;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Vector;

public class WmlAmlChoiceModeHandlet
extends WmlAmlStylePathHandlet {
    private static final String MULTIPLE = "multiple";
    private static final String SINGLE = "single";
    private static final String MODE = "mode";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    WmlElement wmlElement;

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlStylePathRelevance() {
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            WmlAmlAddAttributeHandletEvent addAttributeEvent = (WmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface) {
                this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                if (amlAttributeName.toLowerCase().equals(MODE)) {
                    try {
                        AligoEventInterface event = this.oCurrentEvent;
                        this.wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                        this.oCurrentEvent = event;
                        if (this.wmlElement instanceof WmlSelect) {
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("Choice mode posting high relevance");
                            }
                            currentWmlAmlStylePathRelevance = 20L;
                        }
                    }
                    catch (Exception ex) {
                        this.oHandlerLogger.logError(ex);
                    }
                }
            }
        }
        return currentWmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            boolean memoryError = false;
            try {
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.wmlElement instanceof WmlSelect) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Choice mode aml name " + amlAttributeName);
                    }
                    WmlElement wmlParentElement = this.wmlElement.getWmlParentElement();
                    int position = -1;
                    if (amlAttributeName.toLowerCase().equals(MODE)) {
                        AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                        String amlAttributeValue = axmlElement.getAxmlAttributeValue(amlAttributeName);
                        if (amlAttributeValue.toLowerCase().indexOf(MULTIPLE) != -1) {
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("Choice mode adding multiple attribute " + this.oCurrentAmlPath + " " + this.wmlElement);
                            }
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.wmlElement, MULTIPLE, TRUE);
                        } else if (amlAttributeValue.toLowerCase().indexOf(SINGLE) != -1) {
                            WmlAmlElementUtils.addWmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.wmlElement, MULTIPLE, FALSE);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof WmlAmlInsufficientMemoryException) {
                    AxmlElement amlElement;
                    memoryError = true;
                    AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                    if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                        memoryError = false;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                try {
                    WmlAmlElementUtils.removeWmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.wmlElement.getWmlParentElement(), this.wmlElement);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                WmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new WmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                WmlAmlAddNextAttributeHandletEvent wmlAmlAddNextAttributeHandletEvent = new WmlAmlAddNextAttributeHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(wmlAmlAddNextAttributeHandletEvent);
            }
        }
    }
}

