/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml;

import com.aligo.exceptions.AligoAccessException;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.wml.WmlAmlHandler;
import com.aligo.modules.wml.events.WmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlAddCurrentMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlCacheContentsHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetWmlChildContainerStateHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlRemoveCurrentMemoryHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlResetCurrentMemoryHandlerEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.util.PageCache;
import com.aligo.util.URLUtils;
import com.aligo.util.wml.TextUtils;
import com.aligo.wml.WmlCard;
import com.aligo.wml.WmlElementCollection;
import com.aligo.wml.WmlP;
import com.aligo.wml.WmlPCData;
import com.aligo.wml.WmlWml;
import com.aligo.wml.exceptions.WmlElementIndexOutOfBoundsException;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class WmlAmlPresentationContainerHandler
extends WmlAmlHandler
implements PageAllocatorInterface {
    public static final long HIGH_RELEVANCE = 10L;
    public static final long ACTION_HIGHMEM = 80L;
    public static final long ACTION_LOWMEM = 40L;
    public static final long FORM_HIGHMEM = 20L;
    public static final long FORM_LOWMEM = 5L;
    public static final long RESERVE_MEM = 50L;
    private static final String ELEMENT_PREFIX = "agp";
    private static final String ELEMENT_REFERENCE = "#";
    private static final long DEFAULT_HIGHMEM = 1000L;
    private static final String EXISTS = "true";
    protected WmlElementCollection oWmlDecks = new WmlElementCollection();
    protected boolean bIsTransactionEvent;
    private long lActionMemoryReserve = 40L;
    private long lFormMemoryReserve = 0L;
    private Map oPageURLMap = Collections.synchronizedMap(new HashMap());
    private Map oPageIDMap = Collections.synchronizedMap(new HashMap());
    private Map oElementURLs = Collections.synchronizedMap(new HashMap());
    private Map oElementLinks = Collections.synchronizedMap(new HashMap());
    private int iCurrentElementNumber;
    private String sCurrentElementID;
    private String sPreviousElementID;
    private PageCache oPageCache;
    private String sCacheURL;
    private boolean bNavigatePrevious = false;
    private String sPreviousLabel = "Back";
    private String sNextLabel = "More";
    private long lMemory;
    private int iActiveIndex = 0;
    private int iBaseIndex = 0;
    private int iMenuIndex;
    private Hashtable oPresentationElements;
    private Hashtable oCurrentMemories;
    private int iCurrentRealm;
    private Vector oDeckIndices = new Vector();
    private int iDeckIndex = 0;
    private int iNumActions;

    public WmlAmlPresentationContainerHandler() {
        this.oDeckIndices.addElement(new Integer(this.iActiveIndex));
        this.iNumActions = 0;
        this.oPresentationElements = new Hashtable();
        this.oCurrentMemories = new Hashtable();
    }

    public void init() {
        UAProfile uaProfile = this.getUAProfile();
        this.lMemory = (long)uaProfile.getPDUSize() - 50L;
        if (this.lMemory <= 0L) {
            this.defaultMemory();
        }
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("lMemory = " + this.lMemory);
        }
        try {
            WmlAmlElementUtils.addPresentationElement(this.oHandlerManager, (WmlElement)this.oWmlDecks);
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
    }

    private void defaultMemory() {
        this.lMemory = 1000L;
    }

    public String getWmlContents() {
        String contents = null;
        try {
            contents = this.oPageCache.getIndexedPage(Integer.toString(0));
        }
        catch (AligoAccessException ae) {
            this.oHandlerLogger.logError(ae);
        }
        if (contents == null) {
            contents = this.createEmptyDocument();
            this.oPageCache.putIndexedPage(Integer.toString(this.iBaseIndex), contents);
        }
        return contents;
    }

    private String createEmptyDocument() {
        String contents = null;
        try {
            WmlWml wmlElement = new WmlWml();
            WmlCard wmlCard = new WmlCard();
            wmlCard.addWmlAttribute("id", "Empty");
            wmlElement.addWmlElement(wmlCard);
            WmlP wmlP = new WmlP();
            wmlP.addWmlAttribute("align", "center");
            wmlCard.addWmlElement(wmlP);
            WmlPCData wmlPCData = new WmlPCData();
            wmlPCData.addWmlAttribute("text", "No content");
            wmlP.addWmlElement(wmlPCData);
            contents = wmlElement.getContents();
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
        return contents;
    }

    public void allocatePage() {
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("Allocate page...++++++");
        }
        int index = this.iBaseIndex + this.iActiveIndex;
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        pageURL = URLUtils.composeAnchorURL(pageURL.toString(), ELEMENT_PREFIX + this.iCurrentElementNumber, !WmlAmlElementUtils.isNokia(this.oUAProfile));
        this.oPageURLMap.put(new Integer(index), pageURL.toString());
        int numberIndices = this.oDeckIndices.size();
        if (this.iDeckIndex == numberIndices - 1) {
            ++this.iActiveIndex;
            this.oDeckIndices.addElement(new Integer(this.iActiveIndex));
            ++this.iDeckIndex;
        } else {
            ++this.iDeckIndex;
        }
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("ActiveIndex...**** " + (this.iActiveIndex + this.iBaseIndex) + " deck index ---- " + this.iDeckIndex);
        }
        this.iMenuIndex = 0;
        this.iNumActions = 0;
        this.lActionMemoryReserve = 40L;
        this.lFormMemoryReserve = 0L;
    }

    private int getActiveIndex() {
        return this.getActiveIndex(this.iDeckIndex);
    }

    private int getActiveIndex(int deckIndex) {
        Integer IActiveIndex = (Integer)this.oDeckIndices.elementAt(deckIndex);
        return IActiveIndex;
    }

    private int getMIndex() {
        return this.getMIndex(0);
    }

    private int getMIndex(int step) {
        int deckIndex = this.iDeckIndex;
        int numberIndices = this.oDeckIndices.size();
        if ((deckIndex += step) >= numberIndices) {
            ++this.iActiveIndex;
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("Active index new asked for..." + this.iActiveIndex);
            }
            this.oDeckIndices.addElement(new Integer(this.iActiveIndex));
        }
        int activeIndex = this.getActiveIndex(deckIndex);
        int index = this.iBaseIndex + activeIndex;
        return index;
    }

    public void changeElement(String oldId, String newId) {
        String linkId;
        String url;
        String linkedId = this.getElementLink(oldId);
        if (linkedId != null) {
            this.oElementLinks.remove(oldId);
            this.oElementLinks.put(newId, linkedId);
        }
        if ((url = (String)this.oElementURLs.get(oldId)) != null) {
            url = URLUtils.composeAnchorURL(url, newId, !WmlAmlElementUtils.isNokia(this.oUAProfile)).toString();
            this.oElementURLs.remove(oldId);
            this.oElementURLs.put(newId, url);
        }
        if ((linkId = this.getElementIDLinkingTo(oldId)) != null) {
            this.oElementLinks.put(linkId, newId);
        }
        if (this.sCurrentElementID != null && this.sCurrentElementID.equals(oldId)) {
            this.sCurrentElementID = newId;
        }
        if (this.sPreviousElementID != null && this.sPreviousElementID.equals(oldId)) {
            this.sPreviousElementID = newId;
        }
    }

    public void allocateElement() {
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug(" ****** In allocate element");
        }
        this.sPreviousElementID = this.sCurrentElementID;
        StringBuffer elementID = new StringBuffer(ELEMENT_PREFIX);
        elementID.append(this.iCurrentElementNumber);
        this.sCurrentElementID = elementID.toString();
        StringBuffer url = new StringBuffer(this.sCacheURL);
        url.append(this.getMIndex());
        url = URLUtils.composeAnchorURL(url.toString(), ELEMENT_PREFIX + this.iCurrentElementNumber, !WmlAmlElementUtils.isNokia(this.oUAProfile));
        String currElementURL = url.toString();
        this.oElementURLs.put(this.sCurrentElementID, currElementURL);
        if (this.sPreviousElementID != null) {
            String prevElementURLPrefix;
            String currElementURLPrefix = currElementURL.substring(0, currElementURL.indexOf(this.sCurrentElementID));
            String prevElementURL = this.getElementURL(this.sPreviousElementID);
            if (prevElementURL != null && (prevElementURLPrefix = prevElementURL.substring(0, prevElementURL.indexOf(this.sPreviousElementID))).equals(currElementURLPrefix)) {
                this.oElementLinks.put(this.sPreviousElementID, this.sCurrentElementID);
            }
        }
        ++this.iCurrentElementNumber;
    }

    public String getElementLink(String elementID) {
        return (String)this.oElementLinks.get(elementID);
    }

    private String getElementIDLinkingTo(String elementID) {
        String result = null;
        Iterator keys = this.oElementLinks.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String tmpElementID = (String)this.oElementLinks.get(key);
            if (tmpElementID == null || !tmpElementID.equals(elementID)) continue;
            result = key;
        }
        return result;
    }

    public void deallocateElement(String elementID) {
        String elementLinkFrom = this.getElementIDLinkingTo(elementID);
        String elementLinkTo = (String)this.oElementLinks.get(elementID);
        if (elementLinkFrom != null && elementLinkTo != null) {
            this.oElementLinks.put(elementLinkFrom, elementLinkTo);
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
                this.sPreviousElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom != null && elementLinkTo == null) {
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementLinkFrom) && this.sCurrentElementID.equals(elementID)) {
                this.sPreviousElementID = this.getElementIDLinkingTo(elementLinkFrom);
                this.sCurrentElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom == null && elementLinkTo != null && this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
            this.sPreviousElementID = null;
            this.sCurrentElementID = elementLinkTo;
        }
        this.oElementLinks.remove(elementID);
        this.oElementURLs.remove(elementID);
    }

    private String createPageURL(int index, int elementNumber) {
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        return pageURL.toString();
    }

    private String createPageURL(int index, String elementID) {
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        pageURL = URLUtils.composeAnchorURL(pageURL.toString(), elementID, !WmlAmlElementUtils.isNokia(this.oUAProfile));
        return pageURL.toString();
    }

    public boolean navigatePrevious() {
        return this.bNavigatePrevious;
    }

    public String getPreviousLabel() {
        return this.sPreviousLabel;
    }

    public void setPreviousLabel(String label) {
        if (label != null && !label.equals("")) {
            this.sPreviousLabel = label;
            this.bNavigatePrevious = true;
        }
    }

    public String getNextLabel() {
        return this.sNextLabel;
    }

    public void setNextLabel(String label) {
        this.sNextLabel = label;
    }

    public void assignPageID(String pageID) {
        this.oPageIDMap.put(pageID, new Integer(this.getMIndex()));
    }

    public String getPageURL(String pageID) {
        return (String)this.oPageURLMap.get((Integer)this.oPageIDMap.get(pageID));
    }

    public String getCurrentPageURL() {
        int mIndex = this.getMIndex();
        return this.createPageURL(mIndex, this.iCurrentElementNumber);
    }

    public String getPreviousPageURL() {
        String prevURL = null;
        if (this.getActiveIndex() > 0) {
            int mIndex = this.getMIndex(-1);
            prevURL = this.createPageURL(mIndex, this.iCurrentElementNumber - 1);
        }
        return prevURL;
    }

    public String getNextPageURL() {
        String nextURL = null;
        int mIndex = this.getMIndex(1);
        nextURL = this.createPageURL(mIndex, this.iCurrentElementNumber + 1);
        return nextURL;
    }

    public String getElementURL(String elementID) {
        String result = null;
        if (elementID != null && !elementID.equals("")) {
            result = (String)this.oElementURLs.get(elementID);
        }
        return result;
    }

    public String getCurrentElementURL() {
        return this.getElementURL(this.sCurrentElementID);
    }

    public String getPreviousElementURL() {
        return this.getElementURL(this.sPreviousElementID);
    }

    public String getCurrentElementID() {
        return this.sCurrentElementID;
    }

    public String getPreviousElementID() {
        return this.sPreviousElementID;
    }

    public boolean isElementLinkValid(String linkFromElementID, String linkToElementID) {
        String tmpElementID = this.getElementIDLinkingTo(linkToElementID);
        return linkFromElementID.equals(tmpElementID);
    }

    public boolean isValidPageElement(String elementID) {
        return this.oElementURLs.containsKey(elementID);
    }

    public String getCacheURL() {
        return this.sCacheURL;
    }

    public void setCacheURL(String cacheURL) {
        this.sCacheURL = TextUtils.transformAttr("href", cacheURL);
    }

    public PageCache getPageCache() {
        return this.oPageCache;
    }

    public void setPageCache(PageCache pageCache) {
        this.oPageCache = pageCache;
    }

    private int getCurrentPageID() {
        int id = this.iBaseIndex + this.getActiveIndex();
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("get current id = " + id);
        }
        return id;
    }

    private int getPreviousPageID() {
        int prevId = -1;
        if (this.iActiveIndex > 0) {
            prevId = this.iActiveIndex + this.iBaseIndex - 1;
        }
        return prevId;
    }

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlGetWmlChildContainerStateHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlIsSufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlIsDeckSaneMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlGetRemainingMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlCacheContentsHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlGetCurrentPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlGetPreviousPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlGetPageAllocatorMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlResetCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlAddCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlRemoveCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlGetPresentationElementsHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlRelevance() {
        long currentWmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlGetWmlChildContainerStateHandlerEvent) {
            WmlAmlGetWmlChildContainerStateHandlerEvent getWmlChildContainerStateHandlerEvent = (WmlAmlGetWmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            AmlPathInterface amlPath = getWmlChildContainerStateHandlerEvent.getAmlPath();
            if (amlPath == null) {
                currentWmlAmlRelevance = 10L;
            }
        } else if (this.oCurrentEvent instanceof WmlAmlAddChildContainerHandlerEvent) {
            WmlAmlAddChildContainerHandlerEvent addWmlChildContainerStateHandlerEvent = (WmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
            AmlPathInterface amlPath = addWmlChildContainerStateHandlerEvent.getAmlPath();
            if (amlPath.getNumberAmlPathComponents() == 0) {
                currentWmlAmlRelevance = 20L;
            }
        } else if (this.oCurrentEvent instanceof WmlAmlIsSufficientMemoryHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlIsDeckSaneMemoryHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlGetRemainingMemoryHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlCacheContentsHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlGetCurrentPageIDHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlGetPreviousPageIDHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlGetPageAllocatorMemoryHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlResetCurrentMemoryHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlAddCurrentMemoryHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlRemoveCurrentMemoryHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof WmlAmlGetPresentationElementsHandlerEvent) {
            currentWmlAmlRelevance = 10L;
        }
        return currentWmlAmlRelevance;
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof WmlAmlGetWmlChildContainerStateHandlerEvent) {
            WmlAmlGetWmlChildContainerStateHandlerEvent wmlAmlWmlChildContainerStateHandlerEvent = (WmlAmlGetWmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            wmlAmlWmlChildContainerStateHandlerEvent.setWmlElement(this.oWmlDecks);
        } else if (this.oCurrentEvent instanceof WmlAmlAddChildContainerHandlerEvent) {
            WmlAmlAddChildContainerHandlerEvent addChildContainerEvent = (WmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
            WmlElement wmlElement = addChildContainerEvent.getWmlElement();
            WmlAmlElementUtils.addWmlElement(this.oHandlerManager, addChildContainerEvent.getAmlPath(), this.oWmlDecks, wmlElement, this.getActiveIndex());
        } else if (this.oCurrentEvent instanceof WmlAmlIsSufficientMemoryHandlerEvent) {
            WmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = (WmlAmlIsSufficientMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = isSufficientMemoryEvent.getAmlPath();
            boolean memorySufficient = this.isMemorySufficient(currentAmlPath);
            isSufficientMemoryEvent.setSufficient(memorySufficient);
        } else if (this.oCurrentEvent instanceof WmlAmlIsDeckSaneMemoryHandlerEvent) {
            WmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = (WmlAmlIsDeckSaneMemoryHandlerEvent)this.oCurrentEvent;
            boolean deckSane = this.isDeckSane();
            isDeckSaneEvent.setSane(deckSane);
        } else if (this.oCurrentEvent instanceof WmlAmlGetRemainingMemoryHandlerEvent) {
            WmlAmlGetRemainingMemoryHandlerEvent remainingMemoryEvent = (WmlAmlGetRemainingMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = remainingMemoryEvent.getAmlPath();
            long remainingMemory = 0L;
            try {
                long bytes = this.getCurrentNumberBytes(currentAmlPath);
                if (this.lMemory > bytes) {
                    remainingMemory = this.lMemory - bytes;
                }
            }
            catch (WmlElementIndexOutOfBoundsException ie) {
                // empty catch block
            }
            remainingMemoryEvent.setNumberBytes(remainingMemory);
        } else if (this.oCurrentEvent instanceof WmlAmlCacheContentsHandlerEvent) {
            this.allocatePage();
            int i = 0;
            while (i < this.iActiveIndex) {
                int index = this.iBaseIndex + i;
                try {
                    String strIndex = Integer.toString(index);
                    String contents = this.oWmlDecks.wmlElementAt(i).getContents();
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Adding indexed page " + strIndex);
                        this.oHandlerLogger.logDebug("Contents " + contents);
                    }
                    this.oPageCache.putIndexedPage(strIndex, contents);
                }
                catch (WmlElementIndexOutOfBoundsException ie) {
                    // empty catch block
                }
                ++i;
            }
        } else if (this.oCurrentEvent instanceof WmlAmlGetCurrentPageIDHandlerEvent) {
            WmlAmlGetCurrentPageIDHandlerEvent currentPageIDEvent = (WmlAmlGetCurrentPageIDHandlerEvent)this.oCurrentEvent;
            currentPageIDEvent.setID(new Integer(this.getCurrentPageID()).toString());
        } else if (this.oCurrentEvent instanceof WmlAmlGetPreviousPageIDHandlerEvent) {
            WmlAmlGetPreviousPageIDHandlerEvent previousPageIDEvent = (WmlAmlGetPreviousPageIDHandlerEvent)this.oCurrentEvent;
            previousPageIDEvent.setID(new Integer(this.getPreviousPageID()).toString());
        } else if (this.oCurrentEvent instanceof WmlAmlGetPageAllocatorMemoryHandlerEvent) {
            WmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = (WmlAmlGetPageAllocatorMemoryHandlerEvent)this.oCurrentEvent;
            getPageAllocatorEvent.setPageAllocator(this);
        } else if (this.oCurrentEvent instanceof WmlAmlResetCurrentMemoryHandlerEvent) {
            AmlPathInterface currentAmlPath = ((WmlAmlResetCurrentMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.resetCurrentMemory(currentAmlPath);
        } else if (this.oCurrentEvent instanceof WmlAmlAddCurrentMemoryHandlerEvent) {
            WmlAmlAddCurrentMemoryHandlerEvent addCurrentMemoryEvent = (WmlAmlAddCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = addCurrentMemoryEvent.getAmlPath();
            long addMemory = addCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory += addMemory);
        } else if (this.oCurrentEvent instanceof WmlAmlRemoveCurrentMemoryHandlerEvent) {
            WmlAmlRemoveCurrentMemoryHandlerEvent removeCurrentMemoryEvent = (WmlAmlRemoveCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = removeCurrentMemoryEvent.getAmlPath();
            long removeMemory = removeCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory -= removeMemory);
        } else if (this.oCurrentEvent instanceof WmlAmlGetPresentationElementsHandlerEvent) {
            WmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = (WmlAmlGetPresentationElementsHandlerEvent)this.oCurrentEvent;
            getPresentationElementsEvent.setWmlElements(this.oPresentationElements);
        }
    }

    private boolean isMemorySufficient(AmlPathInterface currentAmlPath) {
        boolean memorySufficient = true;
        try {
            long bytes = this.getCurrentNumberBytes(currentAmlPath);
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("bytes = " + bytes + " memory = " + this.lMemory);
            }
            if (bytes > this.lMemory) {
                memorySufficient = false;
            }
        }
        catch (WmlElementIndexOutOfBoundsException ie) {
            memorySufficient = false;
        }
        return memorySufficient;
    }

    private long getCurrentNumberBytes(AmlPathInterface currentAmlPath) throws WmlElementIndexOutOfBoundsException {
        long bytes = this.getCurrentMemory(currentAmlPath);
        return bytes;
    }

    private boolean isElementSane(WmlElement wmlElement) {
        boolean elementSane = true;
        if (wmlElement == null) {
            elementSane = false;
        } else {
            elementSane = wmlElement.areWmlChildrenSane();
            if (elementSane && (elementSane = wmlElement.areWmlAttributesSane())) {
                int numberChildren = wmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren && elementSane) {
                    try {
                        WmlElement childWmlElement = wmlElement.wmlElementAt(i);
                        elementSane = this.isElementSane(childWmlElement);
                    }
                    catch (WmlElementIndexOutOfBoundsException ie) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        return elementSane;
    }

    private boolean isDeckSane() {
        boolean deckSane = true;
        try {
            WmlElement wmlElement = this.oWmlDecks.wmlElementAt(this.getActiveIndex());
            deckSane = this.isElementSane(wmlElement);
        }
        catch (WmlElementIndexOutOfBoundsException ie) {
            deckSane = false;
        }
        return deckSane;
    }

    private long getDefaultMemory() {
        return 0L;
    }

    private void resetCurrentMemory(AmlPathInterface currentAmlPath) {
        this.setCurrentMemory(currentAmlPath, this.getDefaultMemory());
    }

    private long getCurrentMemory(AmlPathInterface currentAmlPath) {
        int realm = currentAmlPath.getRealm();
        Long objMemory = (Long)this.oCurrentMemories.get(new Integer(realm));
        long memory = this.getDefaultMemory();
        if (objMemory != null) {
            memory = objMemory;
        }
        return memory;
    }

    private void setCurrentMemory(AmlPathInterface currentAmlPath, long memory) {
        int realm = currentAmlPath.getRealm();
        this.oCurrentMemories.put(new Integer(realm), new Long(memory));
    }
}

