/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.axml.interfaces.AxmlExtensionCollectionInterface;
import com.aligo.axml.interfaces.AxmlExtensionInterface;
import com.aligo.extensions.style.StyleExtension;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.maps.MapPath;
import com.aligo.modules.maps.MapPathComponent;
import com.aligo.modules.maps.MapSourceComponent;
import com.aligo.modules.maps.interfaces.MapContainerInterface;
import com.aligo.modules.maps.interfaces.MapInterface;
import com.aligo.modules.maps.interfaces.MapPathInterface;
import com.aligo.modules.maps.interfaces.MapSourceComponentInterface;
import com.aligo.modules.paths.exceptions.AmlPathIndexOutOfBoundsException;
import com.aligo.modules.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.StyleComponent;
import com.aligo.modules.styles.XmlStyleID;
import com.aligo.modules.styles.interfaces.StyleComponentInterface;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.wml.WmlAmlPathHandler;
import com.aligo.modules.wml.events.WmlAmlGetStyleComponentHandledHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetStyleComponentHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlSetTopStyleElementStateHandlerEvent;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.parsing.DOMParser;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.profile.interfaces.UAQueryInterface;
import java.util.Enumeration;
import java.util.Vector;

public class WmlAmlGetStyleComponentHandler
extends WmlAmlPathHandler {
    private static final String UNKNOWN_STYLE_ID = "UNKNOWN";
    private MapContainerInterface oMapContainer;

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlGetStyleComponentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlPathRelevance() {
        long currentWmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlGetStyleComponentHandlerEvent) {
            currentWmlAmlPathRelevance = 20L;
        }
        return currentWmlAmlPathRelevance;
    }

    public void setMapContainer(MapContainerInterface mapContainer) {
        this.oMapContainer = mapContainer;
    }

    public MapContainerInterface getMapContainer() {
        return this.oMapContainer;
    }

    private MapPathInterface getMapPath(AxmlElement amlElement, AmlPathInterface amlPath) throws AmlPathIndexOutOfBoundsException {
        AxmlElement currentAmlElement = amlElement;
        int indexComponent = 0;
        int numberComponents = amlPath.getNumberAmlPathComponents();
        MapPath mapPath = new MapPath();
        String name = amlElement.getName();
        MapPathComponent mapPathComponent = new MapPathComponent(name);
        mapPath.addMapPathComponent(mapPathComponent);
        while (indexComponent < numberComponents) {
            AmlPathComponentInterface amlPathComponent = amlPath.getAmlPathComponentAt(indexComponent);
            int pathIndex = amlPathComponent.getPathIndex();
            currentAmlElement = currentAmlElement.axmlElementAt(pathIndex);
            name = currentAmlElement.getName();
            mapPathComponent = new MapPathComponent(name);
            mapPath.addMapPathComponent(mapPathComponent);
            ++indexComponent;
        }
        return mapPath;
    }

    private Vector getStyleExtensions(AxmlExtensionCollectionInterface extensions) {
        Vector<StyleExtension> styleExtensions = null;
        if (extensions != null) {
            styleExtensions = new Vector<StyleExtension>();
            int numberExtensions = extensions.getNumberExtensions();
            int i = 0;
            while (i < numberExtensions) {
                try {
                    AxmlExtensionInterface extension = extensions.extensionAt(i);
                    if (extension instanceof StyleExtension) {
                        styleExtensions.add((StyleExtension)extension);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    // empty catch block
                }
                ++i;
            }
        }
        return styleExtensions;
    }

    private StyleComponentInterface getStyleFromElement(AxmlElement amlElement, MapSourceComponentInterface mapSourceComponent) {
        StyleComponentInterface styleComponent;
        block11: {
            StyleExtension styleExtension;
            block12: {
                styleComponent = null;
                AxmlExtensionCollectionInterface extensions = amlElement.getExtensions();
                Vector styleExtensions = this.getStyleExtensions(extensions);
                if (styleExtensions == null) break block11;
                styleExtension = null;
                boolean match = false;
                int i = 0;
                while (i < styleExtensions.size()) {
                    styleExtension = (StyleExtension)styleExtensions.elementAt(i);
                    UAQueryInterface uaQuery = styleExtension.getUAQuery();
                    UAProfile uaProfile = this.getUAProfile();
                    if (uaQuery != null) {
                        if (uaQuery.match(uaProfile)) {
                            match = true;
                            break;
                        }
                    } else {
                        String device = styleExtension.getDevice();
                        if (device != null) {
                            String amlID = uaProfile.getAmlID();
                            if (amlID.equals(device)) {
                                match = true;
                                break;
                            }
                        } else {
                            String xmlID;
                            String protocol = styleExtension.getProtocol();
                            if (protocol != null && (xmlID = uaProfile.getXmlID()).equals(protocol)) {
                                match = true;
                                break;
                            }
                        }
                    }
                    ++i;
                }
                if (!match) break block11;
                String styleId = styleExtension.getStyleId();
                if (styleId == null) break block12;
                boolean foundMap = false;
                Enumeration maps = this.oMapContainer.getMaps();
                while (maps.hasMoreElements() && !foundMap) {
                    XmlStyleID itXmlStyleID;
                    String itId;
                    StyleComponentInterface itStyleComponent;
                    StyleIDInterface itStyleID;
                    MapInterface map = (MapInterface)maps.nextElement();
                    MapSourceComponentInterface itMapSourceComponent = map.getMapSourceComponent();
                    if (!itMapSourceComponent.isEqual(mapSourceComponent) || !((itStyleID = (itStyleComponent = map.getStyleComponentInterface()).getStyleID()) instanceof XmlStyleID) || !(itId = (itXmlStyleID = (XmlStyleID)itStyleID).getName()).equals(styleId)) continue;
                    styleComponent = itStyleComponent;
                    foundMap = true;
                }
                break block11;
            }
            String inlineStyle = styleExtension.getInlineStyle();
            if (inlineStyle == null) break block11;
            String completeStyle = "<Style><StyleID>UNKNOWN</StyleID><Representation>" + inlineStyle + "</Representation></Style>";
            try {
                DOMParser parser = new DOMParser();
                StyleComponent itStyleComponent = new StyleComponent();
                itStyleComponent.fromXml(parser.parse(completeStyle.toCharArray()).getDocumentElement());
                styleComponent = itStyleComponent;
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return styleComponent;
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof WmlAmlGetStyleComponentHandlerEvent) {
            try {
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                String name = currentAmlElement.getName();
                MapSourceComponent mapSourceComponent = new MapSourceComponent(name);
                AxmlElement rootAmlElement = AmlPathUtils.getRootAmlElement(this.oHandlerManager);
                MapPathInterface mapPath = this.getMapPath(rootAmlElement, this.oCurrentAmlPath);
                StyleComponentInterface styleComponent = this.getStyleFromElement(currentAmlElement, mapSourceComponent);
                if (styleComponent == null) {
                    styleComponent = this.oMapContainer.getStyleComponent(mapPath, mapSourceComponent, this.oUAProfile);
                }
                XmlElementInterface styleXmlElement = styleComponent.getXmlElement();
                WmlAmlSetTopStyleElementStateHandlerEvent setTopStyleElementStateEvent = new WmlAmlSetTopStyleElementStateHandlerEvent(this.oCurrentAmlPath, styleXmlElement);
                this.oHandlerManager.postEventNow(setTopStyleElementStateEvent);
                WmlAmlGetStyleComponentHandledHandlerEvent getStyleComponentHandledHandlerEvent = new WmlAmlGetStyleComponentHandledHandlerEvent(this.oCurrentAmlPath, styleXmlElement);
                this.oHandlerManager.postEvent(getStyleComponentHandledHandlerEvent);
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
    }
}

