/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.util.wml;

import com.aligo.modules.Path;
import com.aligo.modules.PathComponent;
import com.aligo.modules.exceptions.PathIndexOutOfBoundsException;
import com.aligo.modules.exceptions.PathInvalidException;
import com.aligo.modules.exceptions.PathNotFoundException;
import com.aligo.modules.interfaces.PathComponentInterface;
import com.aligo.modules.interfaces.PathInterface;
import com.aligo.wml.exceptions.WmlElementNotFoundException;
import com.aligo.wml.interfaces.WmlElement;

public class WmlTreeUtils {
    public static WmlElement getWmlElement(WmlElement wmlElement, PathInterface path) throws PathInvalidException {
        WmlElement currentElement = wmlElement;
        try {
            while (path.hasMoreComponents()) {
                PathComponentInterface component = path.getFirstPathComponent();
                int index = component.getPathIndex();
                currentElement = index < 0 ? currentElement.getWmlParentElement() : currentElement.wmlElementAt(index);
                path = path.getNextPath();
            }
        }
        catch (Exception ex) {
            throw new PathInvalidException(ex.toString());
        }
        return currentElement;
    }

    public static PathInterface getWmlPath(WmlElement topElement, WmlElement wmlElement) throws PathNotFoundException {
        Path path = new Path();
        boolean foundPath = false;
        boolean done = false;
        while (!done) {
            WmlElement wmlParentElement = wmlElement.getWmlParentElement();
            if (wmlParentElement != null) {
                int wmlIndex = 0;
                try {
                    wmlIndex = wmlParentElement.wmlElementIndex(wmlElement);
                }
                catch (WmlElementNotFoundException we) {
                    // empty catch block
                }
                PathComponent pathComponent = new PathComponent(wmlIndex);
                try {
                    path.addPathComponentAt(pathComponent, 0);
                }
                catch (PathIndexOutOfBoundsException pe) {
                    // empty catch block
                }
                if (wmlParentElement.equals(topElement)) {
                    foundPath = true;
                    done = true;
                }
                wmlElement = wmlParentElement;
                continue;
            }
            done = true;
        }
        if (foundPath) {
            return path;
        }
        throw new PathNotFoundException();
    }
}

