/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.util.jhtml;

import com.aligo.jhtml.exceptions.JHtmlElementNotFoundException;
import com.aligo.jhtml.interfaces.JHtmlElement;
import com.aligo.modules.Path;
import com.aligo.modules.PathComponent;
import com.aligo.modules.exceptions.PathIndexOutOfBoundsException;
import com.aligo.modules.exceptions.PathInvalidException;
import com.aligo.modules.exceptions.PathNotFoundException;
import com.aligo.modules.interfaces.PathComponentInterface;
import com.aligo.modules.interfaces.PathInterface;

public class JHtmlTreeUtils {
    public static JHtmlElement getJHtmlElement(JHtmlElement jhtmlElement, PathInterface path) throws PathInvalidException {
        JHtmlElement currentElement = jhtmlElement;
        try {
            while (path.hasMoreComponents()) {
                PathComponentInterface component = path.getFirstPathComponent();
                int index = component.getPathIndex();
                currentElement = index < 0 ? currentElement.getJHtmlParentElement() : currentElement.jhtmlElementAt(index);
                path = path.getNextPath();
            }
        }
        catch (Exception ex) {
            throw new PathInvalidException(ex.toString());
        }
        return currentElement;
    }

    public static PathInterface getJHtmlPath(JHtmlElement topElement, JHtmlElement jhtmlElement) throws PathNotFoundException {
        Path path = new Path();
        boolean foundPath = false;
        boolean done = false;
        while (!done) {
            JHtmlElement jhtmlParentElement = jhtmlElement.getJHtmlParentElement();
            if (jhtmlParentElement != null) {
                int jhtmlIndex = 0;
                try {
                    jhtmlIndex = jhtmlParentElement.jhtmlElementIndex(jhtmlElement);
                }
                catch (JHtmlElementNotFoundException we) {
                    // empty catch block
                }
                PathComponent pathComponent = new PathComponent(jhtmlIndex);
                try {
                    path.addPathComponentAt(pathComponent, 0);
                }
                catch (PathIndexOutOfBoundsException pe) {
                    // empty catch block
                }
                if (jhtmlParentElement.equals(topElement)) {
                    foundPath = true;
                    done = true;
                }
                jhtmlElement = jhtmlParentElement;
                continue;
            }
            done = true;
        }
        if (foundPath) {
            return path;
        }
        throw new PathNotFoundException();
    }
}

