/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.styles;

import com.aligo.modules.styles.XmlContainer;
import com.aligo.modules.styles.XmlElement;
import com.aligo.modules.styles.XmlStyleID;
import com.aligo.modules.styles.XmlText;
import com.aligo.modules.styles.exceptions.XmlElementIndexOutOfBoundsException;
import com.aligo.modules.styles.interfaces.StyleComponentInterface;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.parsing.XMLTextUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleComponent
implements StyleComponentInterface {
    XmlElementInterface oXmlElement;
    StyleIDInterface oStyleID;
    private final String STYLE = "Style";
    private final String STYLE_ID = "StyleID";
    private final String REPRESENTATION = "Representation";
    private final String CONTAINER = "Container";
    private final String LT = "<";

    public void setXmlElement(XmlElementInterface xmlElement) {
        this.oXmlElement = xmlElement;
    }

    public XmlElementInterface getXmlElement() {
        return this.oXmlElement;
    }

    public void setStyleID(StyleIDInterface styleID) {
        this.oStyleID = styleID;
    }

    public StyleIDInterface getStyleID() {
        return this.oStyleID;
    }

    public void fromXml(Node styleComponent) {
        if (styleComponent.getNodeType() == 1) {
            NodeList xmlElements;
            Element styleComponentElement = (Element)styleComponent;
            NodeList styleIds = styleComponentElement.getElementsByTagName("StyleID");
            if (styleIds.getLength() > 0 && styleIds.item(0).getNodeType() == 1) {
                Element styleIdElement = (Element)styleIds.item(0);
                XmlStyleID styleID = new XmlStyleID();
                styleID.fromXml(styleIdElement);
                if (styleID != null) {
                    this.setStyleID(styleID);
                }
            }
            if ((xmlElements = styleComponentElement.getElementsByTagName("Representation")).getLength() > 0) {
                XmlContainer xmlContainer = new XmlContainer();
                xmlContainer.setXmlElementName("Container");
                if (xmlElements.item(0).getNodeType() == 1) {
                    Element xmlElementElement = (Element)xmlElements.item(0);
                    NodeList list = xmlElementElement.getChildNodes();
                    int i = 0;
                    while (i < list.getLength()) {
                        Node node = list.item(i);
                        XmlElement xmlElement = null;
                        if (node.getNodeType() != 3) {
                            String nodeName = node.getNodeName();
                            if (nodeName != null) {
                                xmlElement = nodeName.equals("Container") ? new XmlContainer() : new XmlElement();
                                xmlElement.setXmlElementName(nodeName);
                            }
                            if (node.getFirstChild() != null && node.getFirstChild().getNodeType() == 3 && !node.getFirstChild().getNodeValue().trim().equals("")) {
                                XmlText xmlText = new XmlText();
                                xmlText.fromXml(node.getFirstChild());
                                xmlElement.setXmlText(xmlText);
                            }
                            xmlElement.fromXml(node);
                            if (xmlElement != null) {
                                xmlContainer.addXmlElement(xmlElement);
                            }
                        }
                        ++i;
                    }
                }
                this.setXmlElement(xmlContainer);
            }
        } else {
            System.out.println("A parser cannot handle this type");
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLTextUtils.startElement("Style"));
        StyleIDInterface styleIDInterface = this.getStyleID();
        xml.append(styleIDInterface.toXml());
        xml.append(XMLTextUtils.startElement("Representation"));
        XmlContainer xmlContainer = (XmlContainer)this.getXmlElement();
        int noOfXmlElements = xmlContainer.getNumberXmlElements();
        int i = 0;
        while (i < noOfXmlElements) {
            try {
                XmlElementInterface xmlElement = xmlContainer.getXmlElement(i);
                xml.append(xmlElement.toXml());
            }
            catch (XmlElementIndexOutOfBoundsException xe) {
                System.out.println(xe.toString());
            }
            ++i;
        }
        xml.append(XMLTextUtils.endElement("Representation"));
        xml.append(XMLTextUtils.endElement("Style"));
        return xml.toString();
    }
}

