/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.maps;

import com.aligo.modules.maps.MapMatcher;
import com.aligo.modules.maps.MapPathContainer;
import com.aligo.modules.maps.MapSourceComponent;
import com.aligo.modules.maps.interfaces.MapInterface;
import com.aligo.modules.maps.interfaces.MapMatcherInterface;
import com.aligo.modules.maps.interfaces.MapPathInterface;
import com.aligo.modules.maps.interfaces.MapSourceComponentInterface;
import com.aligo.modules.styles.StyleComponent;
import com.aligo.modules.styles.interfaces.StyleComponentInterface;
import com.aligo.parsing.XMLTextUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleMap
implements MapInterface {
    private MapPathInterface oMapPath;
    private MapSourceComponentInterface oMapSourceComponent;
    private StyleComponentInterface oComponentRepresentationContainer;
    private MapMatcherInterface oMapMatcher;
    private static final String MAP_PATH_CONTAINER = "MapPathContainer";
    private static final String MAP_SOURCE_COMPONENT = "SourceComponent";
    private static final String MAP_MATCHER = "Matcher";
    private static final String STYLE_COMPONENT = "Style";
    private static final String STYLE_MAP = "StyleMap";

    public void setMapPath(MapPathInterface mapPath) {
        this.oMapPath = mapPath;
    }

    public MapPathInterface getMapPath() {
        return this.oMapPath;
    }

    public void setMapSourceComponent(MapSourceComponentInterface mapSourceComponent) {
        this.oMapSourceComponent = mapSourceComponent;
    }

    public MapSourceComponentInterface getMapSourceComponent() {
        return this.oMapSourceComponent;
    }

    public void setStyleComponentInterface(StyleComponentInterface componentRepresentationContainer) {
        this.oComponentRepresentationContainer = componentRepresentationContainer;
    }

    public StyleComponentInterface getStyleComponentInterface() {
        return this.oComponentRepresentationContainer;
    }

    public void setMapMatcher(MapMatcherInterface mapMatcher) {
        this.oMapMatcher = mapMatcher;
    }

    public MapMatcherInterface getMapMatcher() {
        return this.oMapMatcher;
    }

    public void fromXml(Node styleMap) {
        if (styleMap.getNodeType() == 1) {
            NodeList styleComponents;
            NodeList mapMatchers;
            NodeList mapSourceComponents;
            Element styleMapElement = (Element)styleMap;
            NodeList mapPaths = styleMapElement.getElementsByTagName(MAP_PATH_CONTAINER);
            if (mapPaths.getLength() > 0 && mapPaths.item(0).getNodeType() == 1) {
                Element mapPathElement = (Element)mapPaths.item(0);
                MapPathContainer mapPathContainer = new MapPathContainer();
                mapPathContainer.fromXml(mapPathElement);
                if (mapPathContainer != null) {
                    this.setMapPath(mapPathContainer);
                }
            }
            if ((mapSourceComponents = styleMapElement.getElementsByTagName(MAP_SOURCE_COMPONENT)).getLength() > 0 && mapSourceComponents.item(0).getNodeType() == 1) {
                Element mapSourceComponentElement = (Element)mapSourceComponents.item(0);
                MapSourceComponent mapSourceComponent = new MapSourceComponent();
                mapSourceComponent.fromXml(mapSourceComponentElement);
                if (mapSourceComponent != null) {
                    this.setMapSourceComponent(mapSourceComponent);
                }
            }
            if ((mapMatchers = styleMapElement.getElementsByTagName(MAP_MATCHER)).getLength() > 0 && mapMatchers.item(0).getNodeType() == 1) {
                Element mapMatcherElement = (Element)mapMatchers.item(0);
                MapMatcher mapMatcher = new MapMatcher();
                mapMatcher.fromXml(mapMatcherElement);
                if (mapMatcher != null) {
                    this.setMapMatcher(mapMatcher);
                }
            }
            if ((styleComponents = styleMapElement.getElementsByTagName(STYLE_COMPONENT)).getLength() > 0 && styleComponents.item(0).getNodeType() == 1) {
                Element styleComponentElement = (Element)styleComponents.item(0);
                StyleComponent styleComponent = new StyleComponent();
                styleComponent.fromXml(styleComponentElement);
                if (styleComponent != null) {
                    this.setStyleComponentInterface(styleComponent);
                }
            }
        } else {
            System.out.println("A parser cannot handle this type");
        }
    }

    public String toXml() {
        StyleComponentInterface styleComponentInterface;
        MapMatcherInterface mapMatcherInterface;
        MapSourceComponentInterface mapSourceComponentInterface;
        StringBuffer xml = new StringBuffer();
        xml.append(XMLTextUtils.startElement(STYLE_MAP));
        MapPathInterface mapPathInterface = this.getMapPath();
        if (mapPathInterface != null) {
            xml.append(mapPathInterface.toXml());
        }
        if ((mapSourceComponentInterface = this.getMapSourceComponent()) != null) {
            xml.append(mapSourceComponentInterface.toXml());
        }
        if ((mapMatcherInterface = this.getMapMatcher()) != null) {
            xml.append(mapMatcherInterface.toXml());
        }
        if ((styleComponentInterface = this.getStyleComponentInterface()) != null) {
            xml.append(styleComponentInterface.toXml());
        }
        xml.append(XMLTextUtils.endElement(STYLE_MAP));
        return xml.toString();
    }
}

