/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.maps;

import com.aligo.engine.logging.LoggerContainer;
import com.aligo.modules.maps.MapPathComponent;
import com.aligo.modules.maps.MapPathMetric;
import com.aligo.modules.maps.exceptions.MapPathIndexOutOfBoundsException;
import com.aligo.modules.maps.interfaces.MapPathComponentInterface;
import com.aligo.modules.maps.interfaces.MapPathInterface;
import com.aligo.modules.maps.interfaces.MapPathMetricInterface;
import com.aligo.parsing.XMLTextUtils;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapPath
implements MapPathInterface {
    private static final int EXACT_METRIC = 10;
    private static final int NUMBER_METRIC = 5;
    private static final int UNIVERSAL_METRIC = 1;
    private static final int DEFAULT_ORDER = 1;
    private static final String MAP_PATH_COMPONENT_SEPARATOR = "/";
    private int iOrder;
    private static final String MAP_PATH = "MapPath";
    private static final String PATH = "Path";
    private static final String ORDER = "Order";
    private static final String EXACT_PATH_METRIC = "ExactPathMetric";
    private static final String NUMBER_PATH_METRIC = "NumberPathMetric";
    private static final String UNIVERSAL_PATH_METRIC = "UniversalPathMetric";
    Vector oMapPathContainer;
    MapPathMetricInterface oExactMapPathComponentMetric;
    MapPathMetricInterface oNumberMapPathComponentMetric;
    MapPathMetricInterface oUniversalMapPathComponentMetric;

    public MapPath() {
        this.oMapPathContainer = new Vector();
        this.setOrder(1);
    }

    public MapPath(Vector pathContainer) {
        this.setMapPathContainer(pathContainer);
    }

    public void setMapPathContainer(Vector pathContainer) {
        this.oMapPathContainer = pathContainer;
    }

    public void addMapPathComponent(MapPathComponentInterface component) {
        this.oMapPathContainer.addElement(component);
    }

    public void addMapPathComponentAt(MapPathComponentInterface component, int index) throws MapPathIndexOutOfBoundsException {
        try {
            this.oMapPathContainer.insertElementAt(component, index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new MapPathIndexOutOfBoundsException(ae.toString());
        }
    }

    public Enumeration getMapPathComponents() {
        return this.oMapPathContainer.elements();
    }

    public int getNumberMapPathComponents() {
        return this.oMapPathContainer.size();
    }

    public MapPathComponentInterface getMapPathComponentAt(int i) throws MapPathIndexOutOfBoundsException {
        try {
            return (MapPathComponentInterface)this.oMapPathContainer.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new MapPathIndexOutOfBoundsException(ae.toString());
        }
    }

    public MapPathComponentInterface getFirstMapPathComponent() throws MapPathIndexOutOfBoundsException {
        return this.getMapPathComponentAt(0);
    }

    public MapPathInterface getNextMapPath() {
        MapPath remainingMapPath = new MapPath();
        int numberElements = this.getNumberMapPathComponents();
        int i = 1;
        while (i < numberElements) {
            MapPathComponentInterface component = (MapPathComponentInterface)this.oMapPathContainer.elementAt(i);
            remainingMapPath.addMapPathComponent(component);
            ++i;
        }
        return remainingMapPath;
    }

    public boolean hasMoreMapPathComponents() {
        boolean moreComponents = false;
        int numberElements = this.oMapPathContainer.size();
        if (numberElements > 0) {
            moreComponents = true;
        }
        return moreComponents;
    }

    public void setExactPathComponentMetric(MapPathMetricInterface exactMapPathComponentMetric) {
        this.oExactMapPathComponentMetric = exactMapPathComponentMetric;
    }

    public MapPathMetricInterface getExactPathComponentMetric() {
        return this.oExactMapPathComponentMetric;
    }

    public void setNumberPathComponentMetric(MapPathMetricInterface numberMapPathComponentMetric) {
        this.oNumberMapPathComponentMetric = numberMapPathComponentMetric;
    }

    public MapPathMetricInterface getNumberPathComponentMetric() {
        return this.oNumberMapPathComponentMetric;
    }

    public void setUniversalPathComponentMetric(MapPathMetricInterface universalMapPathComponentMetric) {
        this.oUniversalMapPathComponentMetric = universalMapPathComponentMetric;
    }

    public MapPathMetricInterface getUniversalPathComponentMetric() {
        return this.oUniversalMapPathComponentMetric;
    }

    public void getEqualMetric(MapPathInterface mapPathInterface, MapPathMetricInterface mapPathMetric) {
        if (mapPathInterface instanceof MapPath) {
            MapPath mapPath = (MapPath)mapPathInterface;
            int numberElements = this.getNumberMapPathComponents();
            int numberGivenElements = mapPath.getNumberMapPathComponents();
            MapPathComponentInterface currentMapComponent = null;
            int lastComponentIndex = -1;
            int currentComponentIndex = 0;
            boolean isUniversalPath = false;
            boolean done = false;
            int i = 0;
            while (i < numberGivenElements && !done) {
                try {
                    MapPathComponentInterface mapPathComponent = mapPath.getMapPathComponentAt(i);
                    boolean exactOrEqualMatch = false;
                    currentComponentIndex = lastComponentIndex + 1;
                    if (currentComponentIndex < numberElements) {
                        currentMapComponent = this.getMapPathComponentAt(currentComponentIndex);
                        if (LoggerContainer.getDefaultLogger().debugEnabled()) {
                            LoggerContainer.getDefaultLogger().logDebug("&& currentMapComponent = " + ((MapPathComponent)currentMapComponent).getPathName() + " mapPathComponent " + ((MapPathComponent)mapPathComponent).getPathName());
                        }
                        if (currentMapComponent.isEqual(mapPathComponent)) {
                            exactOrEqualMatch = true;
                            mapPathMetric.addMetric(this.oExactMapPathComponentMetric);
                        } else if (currentMapComponent.isUniversalPathComponent()) {
                            exactOrEqualMatch = true;
                            mapPathMetric.addMetric(this.oNumberMapPathComponentMetric);
                        } else if (currentMapComponent.isUniversalPath()) {
                            exactOrEqualMatch = true;
                            mapPathMetric.addMetric(this.oUniversalMapPathComponentMetric);
                        }
                    }
                    if (!exactOrEqualMatch) {
                        MapPathComponentInterface lastMapComponent = null;
                        if (lastComponentIndex != -1 && lastComponentIndex < numberElements) {
                            lastMapComponent = this.getMapPathComponentAt(lastComponentIndex);
                        }
                        if (lastMapComponent != null) {
                            if (lastMapComponent.isUniversalPath()) {
                                mapPathMetric.addMetric(this.oUniversalMapPathComponentMetric);
                            } else {
                                mapPathMetric.resetMetric();
                                done = true;
                            }
                        } else {
                            mapPathMetric.resetMetric();
                            done = true;
                        }
                    }
                    if (exactOrEqualMatch) {
                        lastComponentIndex = currentComponentIndex;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
            }
            done = false;
            int index = lastComponentIndex + 1;
            while (index < numberElements && !done) {
                try {
                    currentMapComponent = this.getMapPathComponentAt(index);
                    if (!currentMapComponent.isUniversalPath() || !currentMapComponent.isUniversalPathComponent()) {
                        if (LoggerContainer.getDefaultLogger().debugEnabled()) {
                            LoggerContainer.getDefaultLogger().logDebug("MapPath non-trivial elements found resetting metric.. index = " + index + " currentMapComponent = " + ((MapPathComponent)currentMapComponent).getPathName());
                        }
                        mapPathMetric.resetMetric();
                        done = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++index;
            }
        }
    }

    private void setOrder(int order) {
        this.iOrder = order;
        this.oExactMapPathComponentMetric = new MapPathMetric(10 * this.iOrder);
        this.oNumberMapPathComponentMetric = new MapPathMetric(5 * this.iOrder);
        this.oUniversalMapPathComponentMetric = new MapPathMetric(1 * this.iOrder);
    }

    public void fromXml(Node mapPath) {
        if (mapPath.getNodeType() == 1) {
            NodeList orders;
            NodeList list;
            Element mapPathElement = (Element)mapPath;
            NodeList mapPathComponents = mapPathElement.getElementsByTagName(PATH);
            if (mapPathComponents.getLength() > 0) {
                int i = 0;
                while (i < mapPathComponents.getLength()) {
                    Element mapPathComponentsElement;
                    if (mapPathComponents.item(0).getNodeType() == 1 && (list = (mapPathComponentsElement = (Element)mapPathComponents.item(i)).getChildNodes()).item(0).getNodeValue() != null) {
                        String mapPathComponentsStr = list.item(0).getNodeValue();
                        StringTokenizer mapSt = new StringTokenizer(mapPathComponentsStr, MAP_PATH_COMPONENT_SEPARATOR);
                        while (mapSt.hasMoreTokens()) {
                            String mapPathComponentStr = mapSt.nextToken();
                            MapPathComponent mapPathComponent = new MapPathComponent(mapPathComponentStr);
                            this.addMapPathComponent(mapPathComponent);
                        }
                    }
                    ++i;
                }
            }
            if ((orders = mapPathElement.getElementsByTagName(ORDER)).getLength() > 0) {
                Element order;
                if (orders.item(0).getNodeType() == 1 && (list = (order = (Element)orders.item(0)).getChildNodes()).item(0).getNodeValue() != null) {
                    String orderStr = list.item(0).getNodeValue();
                    this.setOrder(Integer.parseInt(orderStr));
                }
            } else if (orders.getLength() == 0) {
                MapPathMetric mapPathMetric;
                Element mapPathMetricElement;
                NodeList mapPathMetrics = mapPathElement.getElementsByTagName(EXACT_PATH_METRIC);
                if (mapPathMetrics.getLength() > 0 && mapPathMetrics.item(0).getNodeType() == 1) {
                    mapPathMetricElement = (Element)mapPathMetrics.item(0);
                    mapPathMetric = new MapPathMetric();
                    mapPathMetric.fromXml(mapPathMetricElement);
                    if (mapPathMetric != null) {
                        this.setExactPathComponentMetric(mapPathMetric);
                    }
                }
                if ((mapPathMetrics = mapPathElement.getElementsByTagName(NUMBER_PATH_METRIC)).getLength() > 0 && mapPathMetrics.item(0).getNodeType() == 1) {
                    mapPathMetricElement = (Element)mapPathMetrics.item(0);
                    mapPathMetric = new MapPathMetric();
                    mapPathMetric.fromXml(mapPathMetricElement);
                    if (mapPathMetric != null) {
                        this.setNumberPathComponentMetric(mapPathMetric);
                    }
                }
                if ((mapPathMetrics = mapPathElement.getElementsByTagName(UNIVERSAL_PATH_METRIC)).getLength() > 0 && mapPathMetrics.item(0).getNodeType() == 1) {
                    mapPathMetricElement = (Element)mapPathMetrics.item(0);
                    mapPathMetric = new MapPathMetric();
                    mapPathMetric.fromXml(mapPathMetricElement);
                    if (mapPathMetric != null) {
                        this.setUniversalPathComponentMetric(mapPathMetric);
                    }
                }
            }
        } else {
            System.out.println("A parser cannot handle this type");
        }
    }

    public String toXml() {
        System.out.println("Entering Map Path");
        StringBuffer xml = new StringBuffer();
        xml.append(XMLTextUtils.startElement(MAP_PATH));
        int noOfMapPathComponents = this.getNumberMapPathComponents();
        int i = 0;
        while (i < noOfMapPathComponents) {
            try {
                MapPathComponentInterface mapPathComponentInterface = this.getMapPathComponentAt(i);
                if (mapPathComponentInterface != null) {
                    xml.append(mapPathComponentInterface.toXml());
                }
            }
            catch (MapPathIndexOutOfBoundsException mi) {
                System.out.println(mi.toString());
            }
            ++i;
        }
        if (this.iOrder != 1) {
            xml.append(XMLTextUtils.startElement(ORDER));
            xml.append(this.iOrder);
            xml.append(XMLTextUtils.endElement(ORDER));
        } else if (this.iOrder == 1) {
            if (this.getExactPathComponentMetric() != null && Integer.parseInt(this.oExactMapPathComponentMetric.toXml()) != 10) {
                xml.append(XMLTextUtils.startElement(EXACT_PATH_METRIC));
                xml.append(this.getExactPathComponentMetric().toXml());
                xml.append(XMLTextUtils.endElement(EXACT_PATH_METRIC));
            }
            if (this.getNumberPathComponentMetric() != null && Integer.parseInt(this.oNumberMapPathComponentMetric.toXml()) != 5) {
                xml.append(XMLTextUtils.startElement(NUMBER_PATH_METRIC));
                xml.append(this.getNumberPathComponentMetric().toXml());
                xml.append(XMLTextUtils.endElement(NUMBER_PATH_METRIC));
            }
            if (this.getUniversalPathComponentMetric() != null && Integer.parseInt(this.oUniversalMapPathComponentMetric.toXml()) != 1) {
                xml.append(XMLTextUtils.startElement(UNIVERSAL_PATH_METRIC));
                xml.append(this.getUniversalPathComponentMetric().toXml());
                xml.append(XMLTextUtils.endElement(UNIVERSAL_PATH_METRIC));
            }
        }
        xml.append(XMLTextUtils.endElement(MAP_PATH));
        System.out.println("Leaving Map Path");
        return xml.toString();
    }
}

