/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.maps;

import com.aligo.engine.logging.LoggerContainer;
import com.aligo.modules.maps.MapPathMetric;
import com.aligo.modules.maps.StyleMap;
import com.aligo.modules.maps.exceptions.MapIndexOutOfBoundsException;
import com.aligo.modules.maps.interfaces.MapContainerInterface;
import com.aligo.modules.maps.interfaces.MapInterface;
import com.aligo.modules.maps.interfaces.MapMatcherInterface;
import com.aligo.modules.maps.interfaces.MapPathInterface;
import com.aligo.modules.maps.interfaces.MapSourceComponentInterface;
import com.aligo.modules.styles.interfaces.StyleComponentInterface;
import com.aligo.parsing.DOMParser;
import com.aligo.parsing.XMLTextUtils;
import com.aligo.profile.interfaces.UAProfile;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapContainer
implements MapContainerInterface {
    private Vector oMaps = new Vector();
    private static final String MAP_COLLECTION = "MapCollection";
    private static final String STYLE_MAP = "StyleMap";

    public void addMap(MapInterface map) {
        this.oMaps.addElement(map);
    }

    public void removeMap(MapInterface map) {
        this.oMaps.remove(map);
    }

    public MapInterface getMap(int index) throws MapIndexOutOfBoundsException {
        try {
            return (MapInterface)this.oMaps.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new MapIndexOutOfBoundsException(ae.toString());
        }
    }

    public Enumeration getMaps() {
        return this.oMaps.elements();
    }

    public int getNumberMaps() {
        return this.oMaps.size();
    }

    public StyleComponentInterface getStyleComponent(MapPathInterface mapPath, MapSourceComponentInterface mapSourceComponent, UAProfile uaProfile) {
        int numberMaps = this.getNumberMaps();
        StyleComponentInterface styleComponent = null;
        MapPathMetric currentMetric = new MapPathMetric();
        int currentMatchMetric = 0;
        int i = 0;
        while (i < numberMaps) {
            try {
                MapInterface iMap = this.getMap(i);
                MapSourceComponentInterface iMapSourceComponent = iMap.getMapSourceComponent();
                if (iMapSourceComponent.isEqual(mapSourceComponent)) {
                    MapMatcherInterface iMapPathMatcher;
                    int tempMatchMetric;
                    if (LoggerContainer.getDefaultLogger().debugEnabled()) {
                        LoggerContainer.getDefaultLogger().logDebug("Testing map.." + iMap.getStyleComponentInterface().getStyleID());
                    }
                    if ((tempMatchMetric = (iMapPathMatcher = iMap.getMapMatcher()).getEqualMetric(uaProfile)) >= currentMatchMetric) {
                        MapPathInterface iMapPath = iMap.getMapPath();
                        MapPathMetric tempMetric = new MapPathMetric();
                        iMapPath.getEqualMetric(mapPath, tempMetric);
                        boolean assignMetric = false;
                        if (tempMetric.isMetricGreater(currentMetric)) {
                            assignMetric = true;
                        } else if (tempMatchMetric > currentMatchMetric && !tempMetric.isResetMetric()) {
                            assignMetric = true;
                        }
                        if (assignMetric) {
                            currentMatchMetric = tempMatchMetric;
                            currentMetric = tempMetric;
                            styleComponent = iMap.getStyleComponentInterface();
                            if (LoggerContainer.getDefaultLogger().debugEnabled()) {
                                LoggerContainer.getDefaultLogger().logDebug("Selecting map..");
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                LoggerContainer.getDefaultLogger().logError(ex);
            }
            ++i;
        }
        return styleComponent;
    }

    public void addMaps(MapContainerInterface mapContainer) {
        int numMaps = mapContainer.getNumberMaps();
        int i = 0;
        while (i < numMaps) {
            try {
                MapInterface map = mapContainer.getMap(i);
                this.addMap(map);
            }
            catch (MapIndexOutOfBoundsException ex) {
                // empty catch block
            }
            ++i;
        }
    }

    public void fromXml(String xml) throws Exception {
        DOMParser parser = new DOMParser();
        Document dom = parser.parse(xml);
        this.fromXml(dom);
    }

    public void fromXml(File xmlFile) throws Exception {
        DOMParser parser = new DOMParser();
        Document dom = parser.parse(xmlFile);
        this.fromXml(dom);
    }

    public void fromXml(char[] stream) throws Exception {
        DOMParser parser = new DOMParser();
        Document dom = parser.parse(stream);
        this.fromXml(dom);
    }

    public void fromXml(InputStreamReader isr) throws Exception {
        try {
            char[] buffer = new char[4096];
            int i = 0;
            StringBuffer xmlData = new StringBuffer();
            while ((i = isr.read(buffer)) > 0) {
                xmlData.append(buffer, 0, i);
            }
            DOMParser parser = new DOMParser();
            char[] chars = new char[xmlData.length()];
            xmlData.getChars(0, xmlData.length(), chars, 0);
            Document dom = parser.parse(chars);
            this.fromXml(dom);
        }
        catch (IOException e) {
            throw new Exception("Cannot read input file");
        }
    }

    public void fromXml(Document dom) {
        NodeList listOfStyleMaps = dom.getElementsByTagName(STYLE_MAP);
        int numberOfStyleMaps = listOfStyleMaps.getLength();
        if (numberOfStyleMaps > 0) {
            int i = 0;
            while (i < numberOfStyleMaps) {
                Node styleMapElement = listOfStyleMaps.item(i);
                StyleMap styleMap = new StyleMap();
                styleMap.fromXml(styleMapElement);
                if (styleMap != null) {
                    this.addMap(styleMap);
                }
                ++i;
            }
        }
    }

    public String toXml() {
        StringBuffer xmlDocument = new StringBuffer();
        xmlDocument.append(XMLTextUtils.startElement(MAP_COLLECTION));
        int noOfStyleMaps = this.getNumberMaps();
        int i = 0;
        while (i < noOfStyleMaps) {
            try {
                MapInterface mapInterface = this.getMap(i);
                if (mapInterface != null) {
                    xmlDocument.append(mapInterface.toXml());
                }
            }
            catch (MapIndexOutOfBoundsException ae) {
                System.out.println(ae.toString());
            }
            ++i;
        }
        xmlDocument.append(XMLTextUtils.endElement(MAP_COLLECTION));
        return xmlDocument.toString();
    }
}

