/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.jhtml.state;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.jhtml.JHtmlElementCollection;
import com.aligo.jhtml.exceptions.JHtmlElementCannotBeAddedException;
import com.aligo.jhtml.exceptions.JHtmlElementNotFoundException;
import com.aligo.jhtml.interfaces.JHtmlElement;
import com.aligo.modules.jhtml.state.exceptions.JHtmlAmlStateKeeperAttributeNotFoundException;
import com.aligo.modules.jhtml.state.exceptions.JHtmlAmlStateKeeperElementNotFoundException;
import com.aligo.modules.jhtml.state.interfaces.JHtmlAmlStateKeeperInterface;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JHtmlAmlStateKeeper
implements JHtmlAmlStateKeeperInterface {
    private AxmlElement oAmlElement;
    private JHtmlElement oJHtmlChildContainerElement;
    private JHtmlElement oJHtmlElements = new JHtmlElementCollection();
    private JHtmlElement oJHtmlTopElement;
    private JHtmlElement oJHtmlEndElements = new JHtmlElementCollection();
    private int iJHtmlChildPosition = -1;
    private Hashtable oJHtmlAttrTable = new Hashtable();
    private JHtmlElement oJHtmlTextElements = new JHtmlElementCollection();
    private XmlElementInterface oTopStyleElement;
    private StyleIDInterface oStyleID;

    public void setAmlElement(AxmlElement amlElement) {
        this.oAmlElement = amlElement;
    }

    public AxmlElement getAmlElement() {
        return this.oAmlElement;
    }

    public void setJHtmlChildContainerElement(JHtmlElement jhtmlChildContainerElement) {
        this.oJHtmlChildContainerElement = jhtmlChildContainerElement;
    }

    public JHtmlElement getJHtmlChildContainerElement() {
        return this.oJHtmlChildContainerElement;
    }

    public void setJHtmlChildPosition(int jhtmlChildPosition) {
        this.iJHtmlChildPosition = jhtmlChildPosition;
    }

    public int getJHtmlChildPosition() {
        return this.iJHtmlChildPosition;
    }

    public void setTopJHtmlElement(JHtmlElement jhtmlTopElement) {
        this.oJHtmlTopElement = jhtmlTopElement;
    }

    public JHtmlElement getTopJHtmlElement() {
        return this.oJHtmlTopElement;
    }

    public void addEndJHtmlElement(JHtmlElement jhtmlEndElement) {
        try {
            this.oJHtmlEndElements.addJHtmlElement(jhtmlEndElement);
        }
        catch (JHtmlElementCannotBeAddedException jHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public JHtmlElement getEndJHtmlElements() {
        return this.oJHtmlEndElements;
    }

    public void removeAllEndJHtmlElements() {
        this.oJHtmlEndElements.removeAll();
    }

    public void removeEndJHtmlElement(JHtmlElement jhtmlElement) throws JHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oJHtmlEndElements.removeJHtmlElement(jhtmlElement);
        }
        catch (JHtmlElementNotFoundException we) {
            throw new JHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void addJHtmlElement(JHtmlElement jhtmlElement) {
        try {
            this.oJHtmlElements.addJHtmlElement(jhtmlElement);
        }
        catch (JHtmlElementCannotBeAddedException jHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public JHtmlElement getJHtmlElements() {
        return this.oJHtmlElements;
    }

    public void removeAllJHtmlElements() {
        this.oJHtmlElements.removeAll();
    }

    public void removeJHtmlElement(JHtmlElement jhtmlElement) throws JHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oJHtmlElements.removeJHtmlElement(jhtmlElement);
        }
        catch (JHtmlElementNotFoundException we) {
            throw new JHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    private Vector createJHtmlAttributeVector(JHtmlElement jhtmlElement) {
        Vector attributeVector = new Vector();
        this.oJHtmlAttrTable.put(jhtmlElement, attributeVector);
        return attributeVector;
    }

    public void addJHtmlAttribute(JHtmlElement jhtmlElement, String attrName) {
        Vector attributeVector = (Vector)this.oJHtmlAttrTable.get(jhtmlElement);
        if (attributeVector == null) {
            attributeVector = this.createJHtmlAttributeVector(jhtmlElement);
        }
        attributeVector.addElement(attrName);
    }

    public JHtmlElement getJHtmlAttributeElements() {
        JHtmlElementCollection attributeElements = new JHtmlElementCollection();
        Enumeration keys = this.oJHtmlAttrTable.keys();
        while (keys.hasMoreElements()) {
            try {
                JHtmlElement jhtmlElement = (JHtmlElement)keys.nextElement();
                attributeElements.addJHtmlElement(jhtmlElement);
            }
            catch (JHtmlElementCannotBeAddedException jHtmlElementCannotBeAddedException) {
                // empty catch block
            }
        }
        return attributeElements;
    }

    public Enumeration getJHtmlAttributes(JHtmlElement jhtmlElement) throws JHtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oJHtmlAttrTable.get(jhtmlElement);
        if (attributeVector == null) {
            throw new JHtmlAmlStateKeeperElementNotFoundException();
        }
        return attributeVector.elements();
    }

    public void removeAllJHtmlAttributes() {
        this.oJHtmlAttrTable.clear();
    }

    public void removeJHtmlAttributes(JHtmlElement jhtmlElement) throws JHtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oJHtmlAttrTable.get(jhtmlElement);
        if (attributeVector == null) {
            throw new JHtmlAmlStateKeeperElementNotFoundException();
        }
        this.oJHtmlAttrTable.remove(jhtmlElement);
    }

    public void removeJHtmlAttribute(JHtmlElement jhtmlElement, String jhtmlAttrName) throws JHtmlAmlStateKeeperElementNotFoundException, JHtmlAmlStateKeeperAttributeNotFoundException {
        Vector attributeVector = (Vector)this.oJHtmlAttrTable.get(jhtmlElement);
        if (attributeVector == null) {
            throw new JHtmlAmlStateKeeperElementNotFoundException();
        }
        boolean present = attributeVector.remove(jhtmlAttrName);
        if (!present) {
            throw new JHtmlAmlStateKeeperAttributeNotFoundException();
        }
    }

    public void addJHtmlText(JHtmlElement jhtmlElement) {
        try {
            this.oJHtmlTextElements.addJHtmlElement(jhtmlElement);
        }
        catch (JHtmlElementCannotBeAddedException jHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public JHtmlElement getJHtmlTextElements() {
        return this.oJHtmlTextElements;
    }

    public void removeAllJHtmlTextElements() {
        this.oJHtmlTextElements.removeAll();
    }

    public void removeJHtmlText(JHtmlElement jhtmlElement) throws JHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oJHtmlTextElements.removeJHtmlElement(jhtmlElement);
        }
        catch (JHtmlElementNotFoundException we) {
            throw new JHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void setTopStyleElement(XmlElementInterface topStyleElement) {
        this.oTopStyleElement = topStyleElement;
    }

    public XmlElementInterface getTopStyleElement() {
        return this.oTopStyleElement;
    }

    public void setStyleID(StyleIDInterface styleID) {
        this.oStyleID = styleID;
    }

    public StyleIDInterface getStyleID() {
        return this.oStyleID;
    }
}

