/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.jhtml.amlhandlets;

import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.jhtml.JHtmlPCData;
import com.aligo.jhtml.interfaces.JHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.jhtml.errors.JHtmlAmlHandlerError;
import com.aligo.modules.jhtml.events.JHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.jhtml.events.JHtmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.jhtml.exceptions.JHtmlAmlInsufficientMemoryException;
import com.aligo.modules.jhtml.handlets.JHtmlAmlStylePathHandlet;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlAddXmlJHtmlAttributeHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlXmlJHtmlElementHandletEvent;
import com.aligo.modules.jhtml.util.JHtmlAmlElementUtils;
import com.aligo.modules.jhtml.util.JHtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.jhtml.TextUtils;
import java.util.Hashtable;
import java.util.Vector;

public class JHtmlAmlTextAttributeHandlet
extends JHtmlAmlStylePathHandlet {
    public static final String ENCODE = "encode";
    public static final String ENCODE_FALSE = "false";
    private Hashtable oTextIndices = new Hashtable();
    private Hashtable oOutputContainers = new Hashtable();
    private Hashtable oDetachFlags = new Hashtable();

    public Vector getEvents() {
        Vector<JHtmlEventDescriptor> events = new Vector<JHtmlEventDescriptor>();
        JHtmlEventDescriptor eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlShouldDetachTextMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlResetTextStateHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long jhtmlAmlStylePathRelevance() {
        long currentJHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof JHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            JHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (JHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            try {
                AmlPathInterface currentAmlPath = addAttributeEvent.getAmlPath();
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
                JHtmlElement jhtmlElement = JHtmlAmlElementUtils.getJHtmlElement(this.oHandlerManager, currentAmlPath, styleXmlElement);
                String jhtmlName = addAttributeEvent.getJHtmlName();
                if (currentAmlElement instanceof AxmlText && jhtmlElement instanceof JHtmlPCData && jhtmlName.equals("text")) {
                    currentJHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentJHtmlAmlStylePathRelevance;
    }

    public long jhtmlAmlRelevance() {
        long currentJHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof JHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            if (this.doesTextPathExist(this.oCurrentAmlPath) && !this.shouldDetach(this.oCurrentAmlPath)) {
                currentJHtmlAmlRelevance = 30L;
            }
        } else {
            currentJHtmlAmlRelevance = this.oCurrentEvent instanceof JHtmlAmlShouldDetachTextMemoryHandlerEvent ? 30L : (this.oCurrentEvent instanceof JHtmlAmlResetTextStateHandlerEvent ? 20L : super.jhtmlAmlRelevance());
        }
        return currentJHtmlAmlRelevance;
    }

    private boolean doesTextPathExist(AmlPathInterface amlPath) {
        boolean textPathExist = false;
        Integer iLastIndex = (Integer)this.oTextIndices.get(amlPath.getCanonicalPath());
        if (iLastIndex != null) {
            textPathExist = true;
        }
        return textPathExist;
    }

    private boolean shouldDetach(AmlPathInterface amlPath) {
        boolean detach = true;
        Boolean bDetach = (Boolean)this.oDetachFlags.get(amlPath.getCanonicalPath());
        if (bDetach != null) {
            detach = bDetach;
        }
        return detach;
    }

    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof JHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            JHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (JHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            boolean memoryError = false;
            try {
                JHtmlAmlXmlJHtmlElementHandletEvent getJHtmlElementEvent = new JHtmlAmlXmlJHtmlElementHandletEvent("Get", this.oCurrentAmlPath, this.oStyleXmlElement);
                this.oHandlerManager.postEventNow(getJHtmlElementEvent);
                JHtmlElement jhtmlElement = getJHtmlElementEvent.getJHtmlElement();
                String jhtmlName = addAttributeEvent.getJHtmlName();
                String jhtmlValue = addAttributeEvent.getJHtmlValue();
                if (jhtmlValue != null) {
                    String value = "";
                    AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    if (currentAmlElement instanceof AxmlText && jhtmlElement instanceof JHtmlPCData && jhtmlName.equals("text")) {
                        int lastIndex;
                        Integer iLastIndex;
                        String pathString = this.oCurrentAmlPath.getCanonicalPath();
                        Vector strContainer = (Vector)this.oOutputContainers.get(pathString);
                        if (strContainer == null) {
                            strContainer = new Vector();
                            String encodeValue = currentAmlElement.getAxmlAttributeValue(ENCODE);
                            boolean encode = true;
                            if (encodeValue != null && encodeValue.equals(ENCODE_FALSE)) {
                                encode = false;
                            }
                            TextUtils.prepareOutput(jhtmlValue, this.oUAProfile.getScreenWidthChar(), strContainer, encode);
                            this.oOutputContainers.put(pathString, strContainer);
                        }
                        if ((iLastIndex = (Integer)this.oTextIndices.get(pathString)) == null) {
                            lastIndex = 0;
                            iLastIndex = new Integer(lastIndex);
                            this.oTextIndices.put(pathString, iLastIndex);
                        } else {
                            lastIndex = iLastIndex;
                        }
                        JHtmlAmlGetRemainingMemoryHandlerEvent getRemainingMemoryEvent = new JHtmlAmlGetRemainingMemoryHandlerEvent(this.oCurrentAmlPath);
                        this.oHandlerManager.postEventNow(getRemainingMemoryEvent);
                        long remainingMemory = getRemainingMemoryEvent.getNumberBytes();
                        int numberElements = strContainer.size();
                        long memory = 0L;
                        boolean done = false;
                        boolean detach = false;
                        int i = lastIndex;
                        while (i < numberElements && !done) {
                            String element = (String)strContainer.elementAt(i);
                            long elementMemory = element.getBytes().length;
                            if ((memory += elementMemory) > remainingMemory) {
                                done = true;
                                if (i == lastIndex) {
                                    detach = true;
                                }
                                lastIndex = i;
                            } else {
                                value = value + element;
                            }
                            ++i;
                        }
                        this.oDetachFlags.put(pathString, new Boolean(detach));
                        if (done) {
                            this.oTextIndices.put(pathString, new Integer(lastIndex));
                            memoryError = true;
                        } else {
                            this.clearState(this.oCurrentAmlPath);
                        }
                        JHtmlAmlAddXmlJHtmlAttributeHandletEvent addXmlJHtmlAttributeEvent = new JHtmlAmlAddXmlJHtmlAttributeHandletEvent(this.oCurrentAmlPath, jhtmlElement, jhtmlName, value);
                        this.oHandlerManager.postEventNow(addXmlJHtmlAttributeEvent);
                    }
                }
                if (memoryError) {
                    throw new HandlerError(new JHtmlAmlInsufficientMemoryException());
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void handleException(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            HandlerError he = (HandlerError)ex;
            Exception eex = he.getException();
            if (eex instanceof JHtmlAmlInsufficientMemoryException) {
                throw he;
            }
        } else {
            this.oHandlerLogger.logError(ex);
        }
    }

    public void clearState(AmlPathInterface amlPath) {
        String pathString = amlPath.getCanonicalPath();
        this.oTextIndices.remove(pathString);
        this.oOutputContainers.remove(pathString);
        this.oDetachFlags.remove(pathString);
    }

    public void handleEventNow() throws HandlerError {
        if (!(this.oCurrentEvent instanceof JHtmlAmlDetachFromTreeMemoryHandlerEvent)) {
            if (this.oCurrentEvent instanceof JHtmlAmlShouldDetachTextMemoryHandlerEvent) {
                JHtmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = (JHtmlAmlShouldDetachTextMemoryHandlerEvent)this.oCurrentEvent;
                AmlPathInterface currentAmlPath = shouldDetachTextMemoryEvent.getAmlPath();
                boolean detach = true;
                if (currentAmlPath != null) {
                    detach = this.shouldDetach(currentAmlPath);
                }
                shouldDetachTextMemoryEvent.setDetach(detach);
            } else if (this.oCurrentEvent instanceof JHtmlAmlResetTextStateHandlerEvent) {
                try {
                    AmlPathInterface currentAmlPath = ((JHtmlAmlResetTextStateHandlerEvent)this.oCurrentEvent).getAmlPath();
                    this.clearState(currentAmlPath);
                }
                catch (Exception ex) {
                    throw new JHtmlAmlHandlerError(ex);
                }
            } else {
                super.handleEventNow();
            }
        }
    }
}

