/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.jhtml.amlhandlets;

import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.jhtml.JHtmlA;
import com.aligo.jhtml.exceptions.JHtmlAttributeCannotBeAddedException;
import com.aligo.jhtml.exceptions.JHtmlElementCannotBeAddedException;
import com.aligo.jhtml.interfaces.JHtmlElement;
import com.aligo.modules.EventDescriptor;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.jhtml.errors.JHtmlAmlHandlerError;
import com.aligo.modules.jhtml.handlets.JHtmlAmlStylePathHandlet;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlAddElementHandledHandletEvent;
import com.aligo.modules.jhtml.handlets.events.JHtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.jhtml.interfaces.JHtmlEventHookPosition;
import com.aligo.modules.jhtml.util.JHtmlAmlElementUtils;
import com.aligo.modules.jhtml.util.JHtmlEventDescriptor;
import com.aligo.modules.jhtml.util.JHtmlEventHookDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.jhtml.TextUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JHtmlAmlLinkingHandlet
extends JHtmlAmlStylePathHandlet {
    private static final String TYPE = "type";
    private static final String OPTIONS = "options";
    private static final String LABEL = "label";
    private static final String PREVIOUS_PAGE = "Previous Page";
    private static final String SENDREFERER = "sendreferer";
    private static final String TRUE = "true";
    private static final String HREF = "href";
    private static final String NEXT_PAGE = "Next Page";
    private static final String ID = "id";
    private Hashtable oPageIDs = new Hashtable();
    private Hashtable oIDPages = new Hashtable();
    private Hashtable oIDLinks = new Hashtable();
    private JHtmlElement oJHtmlElement;

    public Vector getEvents() {
        Vector<EventDescriptor> events = new Vector<EventDescriptor>();
        JHtmlEventHookDescriptor eventHookDescriptor = new JHtmlEventHookDescriptor("JHtmlAmlAddElementHandledHandletEvent", JHtmlEventHookPosition.POSITION_AFTER);
        events.addElement(eventHookDescriptor);
        JHtmlEventDescriptor eventDescriptor = new JHtmlEventDescriptor("JHtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long jhtmlAmlStylePathRelevance() {
        long currentJHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof JHtmlAmlAddElementHandledHandletEvent) {
            JHtmlAmlAddElementHandledHandletEvent addElementHandledEvent = (JHtmlAmlAddElementHandledHandletEvent)this.oCurrentEvent;
            this.oStyleXmlElement = addElementHandledEvent.getXmlElement();
            this.oCurrentAmlPath = addElementHandledEvent.getAmlPath();
            try {
                this.oJHtmlElement = JHtmlAmlElementUtils.getJHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (amlElement instanceof AxmlPage && this.oJHtmlElement instanceof JHtmlA) {
                    currentJHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (HandlerError he) {}
        } else if (this.oCurrentEvent instanceof JHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            JHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (JHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            try {
                JHtmlElement jhtmlElement = JHtmlAmlElementUtils.getJHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
                String jhtmlName = addAttributeEvent.getJHtmlName();
                if (jhtmlElement instanceof JHtmlA && jhtmlName.equals("name")) {
                    currentJHtmlAmlStylePathRelevance = 20L;
                } else if (jhtmlElement instanceof JHtmlA && jhtmlName.equals(HREF)) {
                    currentJHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return currentJHtmlAmlStylePathRelevance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof JHtmlAmlAddElementHandledHandletEvent) {
            try {
                this.addName(this.oJHtmlElement);
                return;
            }
            catch (Exception ex) {
                if (ex instanceof HandlerError) return;
                throw new JHtmlAmlHandlerError(ex);
            }
        } else {
            if (!(this.oCurrentEvent instanceof JHtmlAmlAddXmlAmlAddAttributeHandletEvent)) return;
            JHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (JHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            JHtmlElement jhtmlElement = JHtmlAmlElementUtils.getJHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
            String jhtmlName = addAttributeEvent.getJHtmlName();
            if (jhtmlElement instanceof JHtmlA && jhtmlName.equals("name")) {
                String jhtmlValue = addAttributeEvent.getJHtmlValue();
                if (jhtmlValue == null) return;
                this.setCardId(jhtmlElement, jhtmlValue);
                String strPath = this.oCurrentAmlPath.toString();
                return;
            } else {
                String jhtmlValue;
                if (!(jhtmlElement instanceof JHtmlA) || !jhtmlName.equals(HREF) || (jhtmlValue = addAttributeEvent.getJHtmlValue()) == null) return;
                String url = jhtmlValue;
                int refIndex = jhtmlValue.indexOf("#");
                if (refIndex != -1) {
                    Vector links;
                    String id = jhtmlValue.substring(refIndex + 1);
                    Vector paths = (Vector)this.oIDPages.get(id);
                    if (paths != null && paths.size() > 0) {
                        url = this.getUrl(this.oCurrentAmlPath, paths, id);
                    }
                    if ((links = (Vector)this.oIDLinks.get(id)) == null) {
                        links = new Vector();
                        this.oIDLinks.put(id, links);
                    }
                    Vector<Object> linkDesc = new Vector<Object>();
                    linkDesc.addElement(this.oCurrentAmlPath);
                    linkDesc.addElement(jhtmlElement);
                    links.addElement(linkDesc);
                } else {
                    url = TextUtils.transformAttr(HREF, url);
                }
                JHtmlAmlElementUtils.addJHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, jhtmlElement, HREF, url);
            }
        }
    }

    public String addName(JHtmlElement jhtmlElement) throws JHtmlAttributeCannotBeAddedException, JHtmlElementCannotBeAddedException, HandlerError {
        String name = null;
        if (jhtmlElement instanceof JHtmlA) {
            PageAllocatorInterface pageAllocator = JHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.allocateElement();
            name = pageAllocator.getCurrentElementID();
            this.setCardId(jhtmlElement, name);
        }
        return name;
    }

    private void setCardId(JHtmlElement jhtmlElement, String id) {
        try {
            JHtmlAmlElementUtils.addJHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, jhtmlElement, "name", id);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        String strPath = this.oCurrentAmlPath.toString();
        String oldId = (String)this.oPageIDs.get(strPath);
        if (oldId != null) {
            this.oIDPages.remove(oldId);
            PageAllocatorInterface pageAllocator = JHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.changeElement(oldId, id);
        }
        this.oPageIDs.put(strPath, id);
        Vector<AmlPathInterface> pages = (Vector<AmlPathInterface>)this.oIDPages.get(id);
        if (pages == null) {
            pages = new Vector<AmlPathInterface>();
            this.oIDPages.put(id, pages);
        }
        pages.addElement(this.oCurrentAmlPath);
        Vector links = (Vector)this.oIDLinks.get(id);
        if (links != null) {
            int number = links.size();
            int i = 0;
            while (i < number) {
                Vector linkDesc = (Vector)links.elementAt(i);
                AmlPathInterface amlPath = (AmlPathInterface)linkDesc.elementAt(0);
                JHtmlElement linkElement = (JHtmlElement)linkDesc.elementAt(1);
                try {
                    String url = this.getUrl(amlPath, pages, id);
                    JHtmlAmlElementUtils.addJHtmlAttribute(this.oHandlerManager, amlPath, linkElement, HREF, url);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private String getUrl(AmlPathInterface srcPath, Vector paths, String id) {
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        Enumeration keys = paths.elements();
        boolean isSame = false;
        boolean first = true;
        AmlPathInterface firstPath = null;
        int firstRealm = -1;
        while (keys.hasMoreElements() && !isSame) {
            AmlPathInterface destPath = (AmlPathInterface)keys.nextElement();
            int destRealm = destPath.getRealm();
            if (srcRealm == destRealm) {
                isSame = true;
                continue;
            }
            if (first) {
                firstRealm = destRealm;
                firstPath = destPath;
                first = false;
                continue;
            }
            if (destRealm >= firstRealm) continue;
            firstRealm = destRealm;
            firstPath = destPath;
        }
        if (!isSame && firstPath != null) {
            url = this.getUrl(srcPath, firstPath, id);
        }
        return url;
    }

    private String getUrl(AmlPathInterface srcPath, AmlPathInterface destPath, String id) {
        int destRealm;
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        if (srcRealm != (destRealm = destPath.getRealm())) {
            PageAllocatorInterface pageAllocator = JHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            url = pageAllocator.getElementURL(id);
        }
        return url;
    }
}

