/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml.util;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.events.IHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetIHtmlChildContainerStateHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetRootElementHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetTopIHtmlElementStateHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlGetTopStyleElementStateHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.ihtml.events.IHtmlAmlSetRootElementHandlerEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddXmlIHtmlAttributeHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddXmlIHtmlElementHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlCreateXmlIHtmlElementHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlRemoveXmlIHtmlAttributeHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlRemoveXmlIHtmlElementHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlResetXmlIHtmlTextHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlSetXmlIHtmlTextHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlXmlIHtmlElementHandletEvent;
import com.aligo.modules.ihtml.util.exceptions.IHtmlAmlGetRootElementFailedException;
import com.aligo.modules.ihtml.util.exceptions.IHtmlAmlSetRootElementFailedException;
import com.aligo.modules.interfaces.HandlerManagerInterface;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.exceptions.XmlElementIndexOutOfBoundsException;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Hashtable;

public class IHtmlAmlElementUtils {
    public static PageAllocatorInterface getPageAllocator(HandlerManagerInterface handlerManager) {
        PageAllocatorInterface pageAllocator = null;
        try {
            IHtmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = new IHtmlAmlGetPageAllocatorMemoryHandlerEvent();
            handlerManager.postEventNow(getPageAllocatorEvent);
            pageAllocator = getPageAllocatorEvent.getPageAllocator();
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
        return pageAllocator;
    }

    public static AxmlElement getRootAmlElement(HandlerManagerInterface handlerManager) throws IHtmlAmlGetRootElementFailedException {
        try {
            IHtmlAmlGetRootElementHandlerEvent getRootElementHandlerEvent = new IHtmlAmlGetRootElementHandlerEvent();
            handlerManager.postEventNow(getRootElementHandlerEvent);
            return getRootElementHandlerEvent.getAmlElement();
        }
        catch (HandlerError handlerError) {
            throw new IHtmlAmlGetRootElementFailedException(handlerError.toString());
        }
    }

    public static void setRootAmlElement(HandlerManagerInterface handlerManager, AxmlElement rootAmlElement) throws IHtmlAmlSetRootElementFailedException {
        try {
            IHtmlAmlSetRootElementHandlerEvent setRootElementHandlerEvent = new IHtmlAmlSetRootElementHandlerEvent(rootAmlElement);
            handlerManager.postEventNow(setRootElementHandlerEvent);
        }
        catch (HandlerError handlerError) {
            throw new IHtmlAmlSetRootElementFailedException(handlerError.toString());
        }
    }

    public static boolean isSufficientMemory(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        IHtmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = new IHtmlAmlIsSufficientMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isSufficientMemoryEvent);
        return isSufficientMemoryEvent.isSufficient();
    }

    public static IHtmlElement getTopIHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        IHtmlAmlGetTopIHtmlElementStateHandlerEvent getTopIHtmlElementStateEvent = new IHtmlAmlGetTopIHtmlElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopIHtmlElementStateEvent);
        return getTopIHtmlElementStateEvent.getIHtmlElement();
    }

    public static void detachFromTree(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        IHtmlAmlDetachFromTreeMemoryHandlerEvent detachFromTreeEvent = new IHtmlAmlDetachFromTreeMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(detachFromTreeEvent);
    }

    public static boolean isDeckSane(HandlerManagerInterface handlerManager) throws HandlerError {
        IHtmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = new IHtmlAmlIsDeckSaneMemoryHandlerEvent();
        handlerManager.postEventNow(isDeckSaneEvent);
        return isDeckSaneEvent.isSane();
    }

    public static IHtmlElement getChildContainerIHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        IHtmlAmlGetIHtmlChildContainerStateHandlerEvent getIHtmlChildContainerStateEvent = new IHtmlAmlGetIHtmlChildContainerStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getIHtmlChildContainerStateEvent);
        return getIHtmlChildContainerStateEvent.getIHtmlElement();
    }

    public static XmlElementInterface getTopStyleElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        IHtmlAmlGetTopStyleElementStateHandlerEvent getTopStyleElementStateEvent = new IHtmlAmlGetTopStyleElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopStyleElementStateEvent);
        return getTopStyleElementStateEvent.getXmlElement();
    }

    public static XmlElementInterface getFirstMatchingChild(HandlerManagerInterface handlerManager, XmlElementInterface topElement, String name) {
        XmlElementInterface matchedElement = null;
        String itName = topElement.getXmlElementName();
        if (name.equals(itName)) {
            matchedElement = topElement;
        } else {
            int numberElements = topElement.getNumberXmlElements();
            boolean done = false;
            int i = 0;
            while (i < numberElements && !done) {
                try {
                    XmlElementInterface xmlElement = topElement.getXmlElement(i);
                    XmlElementInterface childMatchElement = IHtmlAmlElementUtils.getFirstMatchingChild(handlerManager, xmlElement, name);
                    if (childMatchElement != null) {
                        matchedElement = childMatchElement;
                        done = true;
                    }
                }
                catch (XmlElementIndexOutOfBoundsException xe) {
                    // empty catch block
                }
                ++i;
            }
        }
        return matchedElement;
    }

    public static IHtmlElement getIHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XmlElementInterface xmlElement) throws HandlerError {
        IHtmlAmlXmlIHtmlElementHandletEvent xmlIHtmlElementEvent = new IHtmlAmlXmlIHtmlElementHandletEvent("Get", currentAmlPath, xmlElement);
        handlerManager.postEventNow(xmlIHtmlElementEvent);
        return xmlIHtmlElementEvent.getIHtmlElement();
    }

    public static IHtmlElement createIHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, String name) throws HandlerError {
        IHtmlAmlCreateXmlIHtmlElementHandletEvent createXmlIHtmlEvent = new IHtmlAmlCreateXmlIHtmlElementHandletEvent(currentAmlPath, name);
        handlerManager.postEventNow(createXmlIHtmlEvent);
        return createXmlIHtmlEvent.getIHtmlElement();
    }

    public static void addIHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, IHtmlElement ihtmlElement, IHtmlElement childIHtmlElement) throws HandlerError {
        IHtmlAmlElementUtils.addIHtmlElement(handlerManager, currentAmlPath, ihtmlElement, childIHtmlElement, -1);
    }

    public static void addIHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, IHtmlElement ihtmlElement, IHtmlElement childIHtmlElement, int childIndex) throws HandlerError {
        IHtmlAmlAddXmlIHtmlElementHandletEvent addXmlIHtmlElementEvent = new IHtmlAmlAddXmlIHtmlElementHandletEvent(currentAmlPath, ihtmlElement, childIHtmlElement, childIndex);
        handlerManager.postEventNow(addXmlIHtmlElementEvent);
    }

    public static void addIHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, IHtmlElement ihtmlElement, String name, String value) throws HandlerError {
        IHtmlAmlAddXmlIHtmlAttributeHandletEvent addXmlIHtmlAttributeEvent = new IHtmlAmlAddXmlIHtmlAttributeHandletEvent(currentAmlPath, ihtmlElement, name, value);
        handlerManager.postEventNow(addXmlIHtmlAttributeEvent);
    }

    public static void setIHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, IHtmlElement ihtmlElement, String text) throws HandlerError {
        IHtmlAmlSetXmlIHtmlTextHandletEvent setXmlIHtmlTextEvent = new IHtmlAmlSetXmlIHtmlTextHandletEvent(currentAmlPath, ihtmlElement, text);
        handlerManager.postEventNow(setXmlIHtmlTextEvent);
    }

    public static void removeIHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, IHtmlElement ihtmlElement, IHtmlElement childIHtmlElement) throws HandlerError {
        IHtmlAmlRemoveXmlIHtmlElementHandletEvent removeXmlIHtmlElementEvent = new IHtmlAmlRemoveXmlIHtmlElementHandletEvent(currentAmlPath, ihtmlElement, childIHtmlElement);
        handlerManager.postEventNow(removeXmlIHtmlElementEvent);
    }

    public static void removeIHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, IHtmlElement ihtmlElement, String name) throws HandlerError {
        IHtmlAmlRemoveXmlIHtmlAttributeHandletEvent removeXmlIHtmlAttributeEvent = new IHtmlAmlRemoveXmlIHtmlAttributeHandletEvent(currentAmlPath, ihtmlElement, name);
        handlerManager.postEventNow(removeXmlIHtmlAttributeEvent);
    }

    public static void resetIHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, IHtmlElement ihtmlElement) throws HandlerError {
        IHtmlAmlResetXmlIHtmlTextHandletEvent resetXmlIHtmlTextEvent = new IHtmlAmlResetXmlIHtmlTextHandletEvent(currentAmlPath, ihtmlElement);
        handlerManager.postEventNow(resetXmlIHtmlTextEvent);
    }

    public static Hashtable getPresentationElements(HandlerManagerInterface handlerManager) throws HandlerError {
        IHtmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = new IHtmlAmlGetPresentationElementsHandlerEvent();
        handlerManager.postEventNow(getPresentationElementsEvent);
        return getPresentationElementsEvent.getIHtmlElements();
    }

    public static boolean isPresentationElement(HandlerManagerInterface handlerManager, IHtmlElement ihtmlElement) throws HandlerError {
        boolean present = false;
        Hashtable ihtmlElements = IHtmlAmlElementUtils.getPresentationElements(handlerManager);
        if (ihtmlElements.get(ihtmlElement) != null) {
            present = true;
        }
        return present;
    }

    public static void addPresentationElement(HandlerManagerInterface handlerManager, IHtmlElement ihtmlElement) throws HandlerError {
        Hashtable ihtmlElements = IHtmlAmlElementUtils.getPresentationElements(handlerManager);
        IHtmlAmlElementUtils.addPresentationElement(ihtmlElements, ihtmlElement);
    }

    public static void removePresentationElement(HandlerManagerInterface handlerManager, IHtmlElement ihtmlElement) throws HandlerError {
        Hashtable ihtmlElements = IHtmlAmlElementUtils.getPresentationElements(handlerManager);
        IHtmlAmlElementUtils.removePresentationElement(ihtmlElements, ihtmlElement);
    }

    public static void addPresentationElement(Hashtable ihtmlElements, IHtmlElement ihtmlElement) {
        ihtmlElements.put(ihtmlElement, ihtmlElement);
    }

    public static void removePresentationElement(Hashtable ihtmlElements, IHtmlElement ihtmlElement) {
        ihtmlElements.remove(ihtmlElement);
    }

    public static boolean isPersistent(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        IHtmlAmlIsPersistentHandlerEvent isPersistentEvent = new IHtmlAmlIsPersistentHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isPersistentEvent);
        return isPersistentEvent.isPersistent();
    }
}

