/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml.amlhandlets;

import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.IHtmlMeta;
import com.aligo.ihtml.exceptions.IHtmlAttributeCannotBeAddedException;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.handlets.IHtmlAmlStylePathHandlet;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.ihtml.util.IHtmlAmlElementUtils;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class IHtmlAmlRefreshHandlet
extends IHtmlAmlStylePathHandlet {
    private static final String REFRESH = "Refresh";
    private static final String CONTENT_SEPARATOR = "; ";
    private static final String URL = "URL";
    private static final String EQUALS = "=";
    private AxmlElement oAmlElement;
    private String sRefresh;
    private XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlStylePathRelevance() {
        IHtmlAmlAddAttributeHandletEvent addAttributeEvent;
        XmlAttributeInterface xmlAttribute;
        long currentIHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlAddAttributeHandletEvent && (xmlAttribute = (addAttributeEvent = (IHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getXmlAttribute()) instanceof XmlAmlHandlerAttributeInterface) {
            String refresh;
            String attrName;
            XmlAmlHandlerAttributeInterface xmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)xmlAttribute;
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
            if (amlElement instanceof AxmlDocument && (attrName = xmlAmlHandlerAttribute.getAmlAttributeName()).equals("refresh") && (refresh = amlElement.getAxmlAttributeValue(attrName)) != null) {
                this.oXmlAmlHandlerAttribute = xmlAmlHandlerAttribute;
                this.oAmlElement = amlElement;
                this.sRefresh = refresh;
                currentIHtmlAmlStylePathRelevance = 20L;
            }
        }
        return currentIHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof IHtmlAmlAddAttributeHandletEvent) {
            try {
                IHtmlElement ihtmlElement = IHtmlAmlElementUtils.getIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                try {
                    IHtmlMeta ihtmlMeta = new IHtmlMeta();
                    ihtmlMeta.addIHtmlAttribute("http-equiv", REFRESH);
                    int timeout = 0;
                    try {
                        String strTimeout = this.oAmlElement.getAxmlAttributeValue("refresh_timeout");
                        if (strTimeout != null) {
                            timeout = new Integer(strTimeout);
                        }
                    }
                    catch (NumberFormatException ne) {
                        this.oHandlerLogger.logError(ne);
                    }
                    String content = timeout + CONTENT_SEPARATOR + URL + EQUALS + this.sRefresh;
                    ihtmlMeta.addIHtmlAttribute("content", content);
                    IHtmlAmlElementUtils.addIHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, ihtmlElement, ihtmlMeta);
                }
                catch (IHtmlAttributeCannotBeAddedException ex) {
                    this.oHandlerLogger.logError(ex);
                }
            }
            catch (HandlerError he) {
                this.oHandlerLogger.logError(he);
            }
            IHtmlAmlAddAttributeHandledHandletEvent addAttributeHandledEvent = new IHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
            this.oHandlerManager.postEvent(addAttributeHandledEvent);
        }
    }
}

