/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.ihtml.amlhandlets;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.ihtml.IHtmlInput;
import com.aligo.ihtml.IHtmlTextArea;
import com.aligo.ihtml.interfaces.IHtmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.ihtml.events.IHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.ihtml.exceptions.IHtmlAmlInsufficientMemoryException;
import com.aligo.modules.ihtml.handlets.IHtmlAmlStylePathHandlet;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.ihtml.handlets.events.IHtmlAmlXmlIHtmlElementHandletEvent;
import com.aligo.modules.ihtml.util.IHtmlAmlElementUtils;
import com.aligo.modules.ihtml.util.IHtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class IHtmlAmlInputFormatHandlet
extends IHtmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    IHtmlElement ihtmlElement;
    private static final String JAPANESE_ENCODING = "SHIFT_JIS";
    private static final String ISTYLE = "istyle";
    public static final String FORMAT_JAPANESE_ALPHABETIC = "1";
    public static final String FORMAT_ENGLISH_ALPHABETIC = "3";
    public static final String FORMAT_NUMERIC = "4";
    private AmlPathInterface saCurrentAmlPath;

    public Vector getEvents() {
        Vector<IHtmlEventDescriptor> events = new Vector<IHtmlEventDescriptor>();
        IHtmlEventDescriptor eventDescriptor = new IHtmlEventDescriptor("IHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long ihtmlAmlStylePathRelevance() {
        long currentIHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof IHtmlAmlAddAttributeHandletEvent) {
            IHtmlAmlAddAttributeHandletEvent addAttributeEvent = (IHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                AligoEventInterface event = this.oCurrentEvent;
                IHtmlAmlXmlIHtmlElementHandletEvent getIHtmlElementEvent = new IHtmlAmlXmlIHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getIHtmlElementEvent);
                this.oCurrentEvent = event;
                this.ihtmlElement = getIHtmlElementEvent.getIHtmlElement();
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && (this.ihtmlElement instanceof IHtmlInput || this.ihtmlElement instanceof IHtmlTextArea)) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(ISTYLE)) {
                        currentIHtmlAmlStylePathRelevance = 20L;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentIHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        boolean memoryError = false;
        if (this.oCurrentEvent instanceof IHtmlAmlAddAttributeHandletEvent) {
            try {
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && (this.ihtmlElement instanceof IHtmlInput || this.ihtmlElement instanceof IHtmlTextArea)) {
                    AxmlElement axmlElement;
                    String amlAttributeValue;
                    this.saCurrentAmlPath = ((IHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getAmlPath();
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    if (amlAttributeName.toLowerCase().equals(ISTYLE) && (amlAttributeValue = (axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.saCurrentAmlPath)).getAxmlAttributeValue("format")) != null) {
                        AxmlElement amlDocument = AmlPathUtils.getRootAmlElement(this.oHandlerManager);
                        String encoding = amlDocument.getAxmlAttributeValue("encoding");
                        if (amlAttributeValue.equals("numeric")) {
                            IHtmlAmlElementUtils.addIHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.ihtmlElement, ISTYLE, FORMAT_NUMERIC);
                        } else if (amlAttributeValue.equals("localizedalphanumeric")) {
                            if (encoding != null && encoding.toUpperCase().indexOf(JAPANESE_ENCODING) != -1) {
                                IHtmlAmlElementUtils.addIHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.ihtmlElement, ISTYLE, FORMAT_JAPANESE_ALPHABETIC);
                            } else {
                                IHtmlAmlElementUtils.addIHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.ihtmlElement, ISTYLE, FORMAT_ENGLISH_ALPHABETIC);
                            }
                        } else {
                            IHtmlAmlElementUtils.addIHtmlAttribute(this.oHandlerManager, this.saCurrentAmlPath, this.ihtmlElement, ISTYLE, FORMAT_ENGLISH_ALPHABETIC);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof IHtmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                IHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new IHtmlAmlInsufficientMemoryHandlerEvent(this.saCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                IHtmlAmlAddAttributeHandledHandletEvent ihtmlAmlAddAttributeHandledHandletEvent = new IHtmlAmlAddAttributeHandledHandletEvent(this.saCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(ihtmlAmlAddAttributeHandledHandletEvent);
            }
        }
    }
}

