/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.handlets;

import com.aligo.html.exceptions.HtmlElementIndexOutOfBoundsException;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.events.HtmlAmlRemoveChildContainerHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlRemoveCurrentMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlRemoveHtmlElementStateHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlResetTopHtmlElementStateHandlerEvent;
import com.aligo.modules.html.exceptions.HtmlAmlInsufficientMemoryException;
import com.aligo.modules.html.handlets.HtmlAmlElementPathHandlet;
import com.aligo.modules.html.handlets.events.HtmlAmlRemoveHtmlElementHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlRemoveXmlHtmlElementHandletEvent;
import com.aligo.modules.html.util.HtmlAmlElementUtils;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlAmlRemoveXmlHtmlElementHandlet
extends HtmlAmlElementPathHandlet {
    protected HtmlElement oChildHtmlElement;

    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlRemoveXmlHtmlElementHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlElementPathRelevance() {
        long currentHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlRemoveXmlHtmlElementHandletEvent) {
            HtmlAmlRemoveXmlHtmlElementHandletEvent addChildEvent = (HtmlAmlRemoveXmlHtmlElementHandletEvent)this.oCurrentEvent;
            this.oChildHtmlElement = addChildEvent.getChildHtmlElement();
            currentHtmlAmlRelevance = 20L;
        }
        return currentHtmlAmlRelevance;
    }

    public void handleElementPathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HtmlAmlRemoveXmlHtmlElementHandletEvent) {
            if (this.oHtmlElement == null) {
                HtmlAmlResetTopHtmlElementStateHandlerEvent resetTopHtmlElementEvent = new HtmlAmlResetTopHtmlElementStateHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEventNow(resetTopHtmlElementEvent);
                HtmlAmlRemoveChildContainerHandlerEvent removeChildContainerEvent = new HtmlAmlRemoveChildContainerHandlerEvent(this.oCurrentAmlPath, this.oChildHtmlElement);
                this.oHandlerManager.postEventNow(removeChildContainerEvent);
            } else {
                long removeMemory = 0L;
                if (HtmlAmlElementUtils.isPresentationElement(this.oHandlerManager, this.oHtmlElement)) {
                    String contents = this.oChildHtmlElement.getContents();
                    removeMemory += (long)contents.getBytes().length;
                }
                HtmlAmlRemoveHtmlElementHandletEvent removeHtmlElementEvent = new HtmlAmlRemoveHtmlElementHandletEvent(this.oHtmlElement, this.oChildHtmlElement);
                this.oHandlerManager.postEventNow(removeHtmlElementEvent);
                HtmlAmlRemoveHtmlElementStateHandlerEvent removeHtmlElementStateEvent = new HtmlAmlRemoveHtmlElementStateHandlerEvent(this.oCurrentAmlPath, this.oChildHtmlElement);
                this.oHandlerManager.postEventNow(removeHtmlElementStateEvent);
                if (removeMemory != 0L) {
                    HtmlAmlRemoveCurrentMemoryHandlerEvent removeCurrentMemoryEvent = new HtmlAmlRemoveCurrentMemoryHandlerEvent(this.oCurrentAmlPath, removeMemory);
                    this.oHandlerManager.postEventNow(removeCurrentMemoryEvent);
                }
                if (this.oChildHtmlElement.getNumberElements() == 0) {
                    HtmlAmlElementUtils.removePresentationElement(this.oHandlerManager, this.oChildHtmlElement);
                } else {
                    Hashtable htmlElements = HtmlAmlElementUtils.getPresentationElements(this.oHandlerManager);
                    this.removePresentationElements(htmlElements, this.oChildHtmlElement);
                }
                if (!HtmlAmlElementUtils.isSufficientMemory(this.oHandlerManager, this.oCurrentAmlPath)) {
                    throw new HandlerError(new HtmlAmlInsufficientMemoryException());
                }
            }
        }
    }

    void removePresentationElements(Hashtable htmlElements, HtmlElement htmlElement) {
        if (htmlElement != null) {
            HtmlAmlElementUtils.removePresentationElement(htmlElements, htmlElement);
            int numberElements = htmlElement.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                try {
                    HtmlElement childHtmlElement = htmlElement.htmlElementAt(i);
                    this.removePresentationElements(htmlElements, childHtmlElement);
                }
                catch (HtmlElementIndexOutOfBoundsException je) {
                    // empty catch block
                }
                ++i;
            }
        }
    }
}

