/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.amlhandlets;

import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.html.HtmlPCData;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.errors.HtmlAmlHandlerError;
import com.aligo.modules.html.events.HtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.html.exceptions.HtmlAmlInsufficientMemoryException;
import com.aligo.modules.html.handlets.HtmlAmlStylePathHandlet;
import com.aligo.modules.html.handlets.events.HtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlAddXmlHtmlAttributeHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlXmlHtmlElementHandletEvent;
import com.aligo.modules.html.util.HtmlAmlElementUtils;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.html.TextUtils;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlAmlTextAttributeHandlet
extends HtmlAmlStylePathHandlet {
    public static final String ENCODE = "encode";
    public static final String ENCODE_FALSE = "false";
    private Hashtable oTextIndices = new Hashtable();
    private Hashtable oOutputContainers = new Hashtable();
    private Hashtable oDetachFlags = new Hashtable();

    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HtmlEventDescriptor("HtmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HtmlEventDescriptor("HtmlAmlShouldDetachTextMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HtmlEventDescriptor("HtmlAmlResetTextStateHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlStylePathRelevance() {
        long currentHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            HtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (HtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            try {
                AmlPathInterface currentAmlPath = addAttributeEvent.getAmlPath();
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
                HtmlElement htmlElement = HtmlAmlElementUtils.getHtmlElement(this.oHandlerManager, currentAmlPath, styleXmlElement);
                String htmlName = addAttributeEvent.getHtmlName();
                if (currentAmlElement instanceof AxmlText && htmlElement instanceof HtmlPCData && htmlName.equals("text")) {
                    currentHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentHtmlAmlStylePathRelevance;
    }

    public long htmlAmlRelevance() {
        long currentHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlDetachFromTreeMemoryHandlerEvent) {
            if (this.doesTextPathExist(this.oCurrentAmlPath) && !this.shouldDetach(this.oCurrentAmlPath)) {
                currentHtmlAmlRelevance = 30L;
            }
        } else {
            currentHtmlAmlRelevance = this.oCurrentEvent instanceof HtmlAmlShouldDetachTextMemoryHandlerEvent ? 30L : (this.oCurrentEvent instanceof HtmlAmlResetTextStateHandlerEvent ? 20L : super.htmlAmlRelevance());
        }
        return currentHtmlAmlRelevance;
    }

    private boolean doesTextPathExist(AmlPathInterface amlPath) {
        boolean textPathExist = false;
        Integer iLastIndex = (Integer)this.oTextIndices.get(amlPath.getCanonicalPath());
        if (iLastIndex != null) {
            textPathExist = true;
        }
        return textPathExist;
    }

    private boolean shouldDetach(AmlPathInterface amlPath) {
        boolean detach = true;
        Boolean bDetach = (Boolean)this.oDetachFlags.get(amlPath.getCanonicalPath());
        if (bDetach != null) {
            detach = bDetach;
        }
        return detach;
    }

    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            HtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (HtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            boolean memoryError = false;
            try {
                HtmlAmlXmlHtmlElementHandletEvent getHtmlElementEvent = new HtmlAmlXmlHtmlElementHandletEvent("Get", this.oCurrentAmlPath, this.oStyleXmlElement);
                this.oHandlerManager.postEventNow(getHtmlElementEvent);
                HtmlElement htmlElement = getHtmlElementEvent.getHtmlElement();
                String htmlName = addAttributeEvent.getHtmlName();
                String htmlValue = addAttributeEvent.getHtmlValue();
                if (htmlValue != null) {
                    String value = "";
                    AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    if (currentAmlElement instanceof AxmlText && htmlElement instanceof HtmlPCData && htmlName.equals("text")) {
                        int lastIndex;
                        Integer iLastIndex;
                        String pathString = this.oCurrentAmlPath.getCanonicalPath();
                        Vector strContainer = (Vector)this.oOutputContainers.get(pathString);
                        if (strContainer == null) {
                            strContainer = new Vector();
                            String encodeValue = currentAmlElement.getAxmlAttributeValue(ENCODE);
                            boolean encode = true;
                            if (encodeValue != null && encodeValue.equals(ENCODE_FALSE)) {
                                encode = false;
                            }
                            TextUtils.prepareOutput(htmlValue, this.oUAProfile.getScreenWidthChar(), strContainer, encode);
                            this.oOutputContainers.put(pathString, strContainer);
                        }
                        if ((iLastIndex = (Integer)this.oTextIndices.get(pathString)) == null) {
                            lastIndex = 0;
                            iLastIndex = new Integer(lastIndex);
                            this.oTextIndices.put(pathString, iLastIndex);
                        } else {
                            lastIndex = iLastIndex;
                        }
                        HtmlAmlGetRemainingMemoryHandlerEvent getRemainingMemoryEvent = new HtmlAmlGetRemainingMemoryHandlerEvent(this.oCurrentAmlPath);
                        this.oHandlerManager.postEventNow(getRemainingMemoryEvent);
                        long remainingMemory = getRemainingMemoryEvent.getNumberBytes();
                        int numberElements = strContainer.size();
                        long memory = 0L;
                        boolean done = false;
                        boolean detach = false;
                        int i = lastIndex;
                        while (i < numberElements && !done) {
                            String element = (String)strContainer.elementAt(i);
                            long elementMemory = element.getBytes().length;
                            if ((memory += elementMemory) > remainingMemory) {
                                done = true;
                                if (i == lastIndex) {
                                    detach = true;
                                }
                                lastIndex = i;
                            } else {
                                value = value + element;
                            }
                            ++i;
                        }
                        this.oDetachFlags.put(pathString, new Boolean(detach));
                        if (done) {
                            this.oTextIndices.put(pathString, new Integer(lastIndex));
                            memoryError = true;
                        } else {
                            this.clearState(this.oCurrentAmlPath);
                        }
                        HtmlAmlAddXmlHtmlAttributeHandletEvent addXmlHtmlAttributeEvent = new HtmlAmlAddXmlHtmlAttributeHandletEvent(this.oCurrentAmlPath, htmlElement, htmlName, value);
                        this.oHandlerManager.postEventNow(addXmlHtmlAttributeEvent);
                    }
                }
                if (memoryError) {
                    throw new HandlerError(new HtmlAmlInsufficientMemoryException());
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void handleException(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            HandlerError he = (HandlerError)ex;
            Exception eex = he.getException();
            if (eex instanceof HtmlAmlInsufficientMemoryException) {
                throw he;
            }
        } else {
            this.oHandlerLogger.logError(ex);
        }
    }

    public void clearState(AmlPathInterface amlPath) {
        String pathString = amlPath.getCanonicalPath();
        this.oTextIndices.remove(pathString);
        this.oOutputContainers.remove(pathString);
        this.oDetachFlags.remove(pathString);
    }

    public void handleEventNow() throws HandlerError {
        if (!(this.oCurrentEvent instanceof HtmlAmlDetachFromTreeMemoryHandlerEvent)) {
            if (this.oCurrentEvent instanceof HtmlAmlShouldDetachTextMemoryHandlerEvent) {
                HtmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = (HtmlAmlShouldDetachTextMemoryHandlerEvent)this.oCurrentEvent;
                AmlPathInterface currentAmlPath = shouldDetachTextMemoryEvent.getAmlPath();
                boolean detach = true;
                if (currentAmlPath != null) {
                    detach = this.shouldDetach(currentAmlPath);
                }
                shouldDetachTextMemoryEvent.setDetach(detach);
            } else if (this.oCurrentEvent instanceof HtmlAmlResetTextStateHandlerEvent) {
                try {
                    AmlPathInterface currentAmlPath = ((HtmlAmlResetTextStateHandlerEvent)this.oCurrentEvent).getAmlPath();
                    this.clearState(currentAmlPath);
                }
                catch (Exception ex) {
                    throw new HtmlAmlHandlerError(ex);
                }
            } else {
                super.handleEventNow();
            }
        }
    }
}

