/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.amlhandlets;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.html.HtmlContainer;
import com.aligo.html.HtmlInput;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.events.HtmlAmlGetStyleIDStateHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.html.exceptions.HtmlAmlInsufficientMemoryException;
import com.aligo.modules.html.handlets.HtmlAmlStylePathHandlet;
import com.aligo.modules.html.handlets.events.HtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlXmlHtmlElementHandletEvent;
import com.aligo.modules.html.util.HtmlAmlElementUtils;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.XmlStyleID;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class HtmlAmlSeparatePidFromFormsUrlHandlet
extends HtmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    HtmlElement htmlElement;
    boolean style_id = false;
    private static final String HIDDEN = "hidden";
    private static final String URL = "url";
    private static final String QUESTION_MARK = "?";
    private static final String EQUAL_TO = "=";
    private static final String ACTION = "action";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String VALUE = "value";

    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlStylePathRelevance() {
        long currentHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlAddAttributeHandletEvent) {
            HtmlAmlAddAttributeHandletEvent addAttributeEvent = (HtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                XmlStyleID xmlStyleID;
                String name;
                AligoEventInterface event = this.oCurrentEvent;
                HtmlAmlXmlHtmlElementHandletEvent getHtmlElementEvent = new HtmlAmlXmlHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getHtmlElementEvent);
                this.oCurrentEvent = event;
                this.htmlElement = getHtmlElementEvent.getHtmlElement();
                HtmlAmlGetStyleIDStateHandlerEvent getStyleIDStateEvent = new HtmlAmlGetStyleIDStateHandlerEvent(addAttributeEvent.getAmlPath());
                this.oHandlerManager.postEventNow(getStyleIDStateEvent);
                StyleIDInterface styleID = getStyleIDStateEvent.getStyleID();
                if (styleID instanceof XmlStyleID && (name = (xmlStyleID = (XmlStyleID)styleID).getName()) != null && name.equals("Html_2")) {
                    this.style_id = true;
                }
                if (this.style_id && this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.htmlElement instanceof HtmlContainer) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(HIDDEN)) {
                        currentHtmlAmlStylePathRelevance = 20L;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof HtmlAmlAddAttributeHandletEvent) {
            boolean memoryError = false;
            try {
                if (this.style_id && this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.htmlElement instanceof HtmlContainer) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    Object previousHtmlElement = null;
                    AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    String amlAttributeValue = axmlElement.getAxmlAttributeValue(URL);
                    if (amlAttributeName.toLowerCase().equals(HIDDEN) && amlAttributeValue.indexOf(QUESTION_MARK) != -1) {
                        int position = amlAttributeValue.indexOf(QUESTION_MARK);
                        String formUrl = amlAttributeValue.substring(0, position);
                        String sessionIdInfo = amlAttributeValue.substring(position + 1);
                        if (sessionIdInfo.indexOf(EQUAL_TO) != -1) {
                            int eqPosition = sessionIdInfo.indexOf(EQUAL_TO);
                            HtmlElement topElement = HtmlAmlElementUtils.getTopHtmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                            HtmlElement containerElement = topElement.htmlElementAt(0);
                            HtmlElement formElement = containerElement.htmlElementAt(0);
                            HtmlAmlElementUtils.addHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, formElement, ACTION, formUrl);
                            HtmlInput input = new HtmlInput();
                            input.addHtmlAttribute(TYPE, HIDDEN);
                            input.addHtmlAttribute(NAME, sessionIdInfo.substring(0, eqPosition));
                            input.addHtmlAttribute(VALUE, sessionIdInfo.substring(eqPosition + 1));
                            HtmlAmlElementUtils.addHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, formElement, input);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof HtmlAmlInsufficientMemoryException) {
                    AxmlElement amlElement;
                    memoryError = true;
                    AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                    if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                        memoryError = false;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                try {
                    HtmlAmlElementUtils.removeHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.htmlElement.getHtmlParentElement(), this.htmlElement);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                HtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new HtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                HtmlAmlAddAttributeHandledHandletEvent htmlAmlAddAttributeHandledHandletEvent = new HtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(htmlAmlAddAttributeHandledHandletEvent);
            }
        }
    }
}

