/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html.amlhandlets;

import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.html.HtmlMeta;
import com.aligo.html.exceptions.HtmlAttributeCannotBeAddedException;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.handlets.HtmlAmlStylePathHandlet;
import com.aligo.modules.html.handlets.events.HtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.html.handlets.events.HtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.html.util.HtmlAmlElementUtils;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class HtmlAmlRefreshHandlet
extends HtmlAmlStylePathHandlet {
    private static final String REFRESH = "Refresh";
    private static final String CONTENT_SEPARATOR = "; ";
    private static final String URL = "URL";
    private static final String EQUALS = "=";
    private AxmlElement oAmlElement;
    private String sRefresh;
    private XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;

    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlStylePathRelevance() {
        HtmlAmlAddAttributeHandletEvent addAttributeEvent;
        XmlAttributeInterface xmlAttribute;
        long currentHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof HtmlAmlAddAttributeHandletEvent && (xmlAttribute = (addAttributeEvent = (HtmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getXmlAttribute()) instanceof XmlAmlHandlerAttributeInterface) {
            String refresh;
            String attrName;
            XmlAmlHandlerAttributeInterface xmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)xmlAttribute;
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
            if (amlElement instanceof AxmlDocument && (attrName = xmlAmlHandlerAttribute.getAmlAttributeName()).equals("refresh") && (refresh = amlElement.getAxmlAttributeValue(attrName)) != null) {
                this.oXmlAmlHandlerAttribute = xmlAmlHandlerAttribute;
                this.oAmlElement = amlElement;
                this.sRefresh = refresh;
                currentHtmlAmlStylePathRelevance = 20L;
            }
        }
        return currentHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof HtmlAmlAddAttributeHandletEvent) {
            try {
                HtmlElement htmlElement = HtmlAmlElementUtils.getHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                try {
                    HtmlMeta htmlMeta = new HtmlMeta();
                    htmlMeta.addHtmlAttribute("http-equiv", REFRESH);
                    int timeout = 0;
                    try {
                        String strTimeout = this.oAmlElement.getAxmlAttributeValue("refresh_timeout");
                        if (strTimeout != null) {
                            timeout = new Integer(strTimeout);
                        }
                    }
                    catch (NumberFormatException ne) {
                        this.oHandlerLogger.logError(ne);
                    }
                    String content = timeout + CONTENT_SEPARATOR + URL + EQUALS + this.sRefresh;
                    htmlMeta.addHtmlAttribute("content", content);
                    HtmlAmlElementUtils.addHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, htmlElement, htmlMeta);
                }
                catch (HtmlAttributeCannotBeAddedException ex) {
                    this.oHandlerLogger.logError(ex);
                }
            }
            catch (HandlerError he) {
                this.oHandlerLogger.logError(he);
            }
            HtmlAmlAddAttributeHandledHandletEvent addAttributeHandledEvent = new HtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
            this.oHandlerManager.postEvent(addAttributeHandledEvent);
        }
    }
}

