/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.html;

import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.html.HtmlContainer;
import com.aligo.html.HtmlDiv;
import com.aligo.html.HtmlElementCollection;
import com.aligo.html.exceptions.HtmlAttributeCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementIndexOutOfBoundsException;
import com.aligo.html.interfaces.HtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.html.HtmlAmlPathHandler;
import com.aligo.modules.html.errors.HtmlAmlHandlerError;
import com.aligo.modules.html.events.HtmlAmlAddChildContainerHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlControlMenuOffsetHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlCreateNextElementHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlGetControlMenuParentContainerHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.html.events.HtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.html.exceptions.HtmlAmlInsufficientMemoryException;
import com.aligo.modules.html.util.HtmlAmlElementUtils;
import com.aligo.modules.html.util.HtmlEventDescriptor;
import com.aligo.modules.html.util.exceptions.HtmlAmlGetRootElementFailedException;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlAmlControlMenuHandler
extends HtmlAmlPathHandler {
    private static final String SPACE = "&nbsp;";
    private Hashtable oControlMenuPresentTable = new Hashtable();
    private Hashtable oControlMenuContainerTable = new Hashtable();
    private Hashtable oCMTBNeedCopyTable = new Hashtable();
    private boolean bNoHandleCNEHandlerEvent = false;
    private Hashtable oNumberCMAddedTable = new Hashtable();

    private boolean isControlMenuPresent(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bPresent;
        boolean present = false;
        if (currentAmlPath != null && (bPresent = (Boolean)this.oControlMenuPresentTable.get(pathString = currentAmlPath.toString())) != null) {
            present = bPresent;
        }
        return present;
    }

    private void setControlMenuPresent(AmlPathInterface currentAmlPath, boolean present) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuPresentTable.put(pathString, new Boolean(present));
    }

    private HtmlElement getControlMenuContainer(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        HtmlElement htmlElement = (HtmlElement)this.oControlMenuContainerTable.get(pathString);
        return htmlElement;
    }

    private void setControlMenuContainer(AmlPathInterface currentAmlPath, HtmlElement htmlElement) {
        String pathString = currentAmlPath.toString();
        this.oControlMenuContainerTable.put(pathString, htmlElement);
    }

    private boolean doesCMTBNeedCopy(AmlPathInterface currentAmlPath) {
        String pathString;
        Boolean bNeedCopy;
        boolean needCopy = false;
        if (currentAmlPath != null && (bNeedCopy = (Boolean)this.oCMTBNeedCopyTable.get(pathString = currentAmlPath.toString())) != null) {
            needCopy = bNeedCopy;
        }
        return needCopy;
    }

    private void setCMTBNeedCopy(AmlPathInterface currentAmlPath, boolean needCopy) {
        String pathString = currentAmlPath.toString();
        this.oCMTBNeedCopyTable.put(pathString, new Boolean(needCopy));
    }

    private int getNumberCMAdded(AmlPathInterface currentAmlPath) {
        String pathString = currentAmlPath.toString();
        int numAdded = 0;
        Integer inNumAdded = (Integer)this.oNumberCMAddedTable.get(pathString);
        if (inNumAdded != null) {
            numAdded = inNumAdded;
        }
        return numAdded;
    }

    private void incNumberCMAdded(AmlPathInterface currentAmlPath) {
        int numAdded = this.getNumberCMAdded(currentAmlPath);
        String pathString = currentAmlPath.toString();
        this.oNumberCMAddedTable.put(pathString, new Integer(++numAdded));
    }

    public Vector getEvents() {
        Vector<HtmlEventDescriptor> events = new Vector<HtmlEventDescriptor>();
        HtmlEventDescriptor eventDescriptor = new HtmlEventDescriptor("HtmlAmlAddChildContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HtmlEventDescriptor("HtmlAmlControlMenuOffsetHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HtmlEventDescriptor("HtmlAmlAddControlMenuElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HtmlEventDescriptor("HtmlAmlGetControlMenuParentContainerHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HtmlEventDescriptor("HtmlAmlCreateNextElementHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HtmlEventDescriptor("HtmlAmlIsPersistentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long htmlAmlPathRelevance() {
        long currentHtmlAmlPathRelevance;
        block21: {
            currentHtmlAmlPathRelevance = 0L;
            if (this.oCurrentEvent instanceof HtmlAmlAddChildContainerHandlerEvent) {
                try {
                    AmlPathInterface parentAmlPath;
                    AxmlElement parentAmlElement;
                    AmlPathInterface currentAmlPath = ((HtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu && (parentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) instanceof AxmlPage) {
                        currentHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof HtmlAmlControlMenuOffsetHandlerEvent) {
                currentHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof HtmlAmlAddControlMenuElementHandlerEvent) {
                currentHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof HtmlAmlGetControlMenuParentContainerHandlerEvent) {
                currentHtmlAmlPathRelevance = 20L;
            } else if (this.oCurrentEvent instanceof HtmlAmlCreateNextElementHandlerEvent) {
                try {
                    if (!this.bNoHandleCNEHandlerEvent) {
                        int numberCM;
                        AmlPathInterface parentAmlPath;
                        int numCMAdded;
                        HtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (HtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
                        AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                        if (amlElement instanceof AxmlControlMenu && (numCMAdded = this.getNumberCMAdded(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))) == (numberCM = this.getTotalControlMenus(parentAmlPath)) && this.doesCMTBNeedCopy(parentAmlPath)) {
                            currentHtmlAmlPathRelevance = 30L;
                        }
                        break block21;
                    }
                    this.bNoHandleCNEHandlerEvent = false;
                }
                catch (Exception ex) {}
            } else if (this.oCurrentEvent instanceof HtmlAmlIsPersistentHandlerEvent) {
                try {
                    HtmlAmlIsPersistentHandlerEvent isPersistentElementEvent = (HtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent;
                    AmlPathInterface currentAmlPath = isPersistentElementEvent.getAmlPath();
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                    if (amlElement instanceof AxmlControlMenu) {
                        currentHtmlAmlPathRelevance = 30L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return currentHtmlAmlPathRelevance;
    }

    private int getTotalControlMenus(AmlPathInterface parentAmlPath) throws HtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        int numberMenus = 0;
        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
        int numberChildren = amlElement.getNumberElements();
        int i = 0;
        while (i < numberChildren) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private int getNumberControlMenus(AmlPathInterface currentAmlPath) throws HtmlAmlGetRootElementFailedException, ArrayIndexOutOfBoundsException {
        AmlPathInterface parentAmlPath;
        AxmlElement amlElement;
        int numberChildren;
        int numberMenus = 0;
        int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        if (childIndex > (numberChildren = (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath))).getNumberElements()) - 1) {
            childIndex = numberChildren - 1;
        }
        int i = 0;
        while (i < childIndex) {
            AxmlElement childAmlElement = amlElement.axmlElementAt(i);
            if (childAmlElement instanceof AxmlControlMenu) {
                ++numberMenus;
            }
            ++i;
        }
        return numberMenus;
    }

    private void createControlMenuContainer(AmlPathInterface amlPath, HtmlElement htmlElement) throws HandlerError {
        HtmlElement controlMenuContainer = null;
        boolean oneElement = false;
        if (htmlElement instanceof HtmlElementCollection) {
            int numberElements = htmlElement.getNumberElements();
            if (numberElements > 1) {
                controlMenuContainer = new HtmlElementCollection();
                int i = 0;
                while (i < numberElements) {
                    try {
                        HtmlElement cmParentContainer = htmlElement.htmlElementAt(i);
                        HtmlElement tCMContainer = this.createCMContainerElement(amlPath, cmParentContainer);
                        controlMenuContainer.addHtmlElement(tCMContainer);
                    }
                    catch (HtmlElementIndexOutOfBoundsException je) {
                    }
                    catch (HtmlElementCannotBeAddedException je) {
                        // empty catch block
                    }
                    ++i;
                }
                this.setCMTBNeedCopy(amlPath, true);
            } else {
                try {
                    htmlElement = htmlElement.htmlElementAt(0);
                    oneElement = true;
                }
                catch (HtmlElementIndexOutOfBoundsException je) {}
            }
        } else {
            oneElement = true;
        }
        if (oneElement) {
            controlMenuContainer = this.createCMContainerElement(amlPath, htmlElement);
        }
        this.setControlMenuPresent(amlPath, true);
        this.setControlMenuContainer(amlPath, controlMenuContainer);
    }

    private HtmlElement createCMContainerElement(AmlPathInterface amlPath, HtmlElement htmlElement) throws HandlerError {
        HtmlDiv htmlDiv = new HtmlDiv();
        try {
            HtmlAmlElementUtils.addHtmlElement(this.oHandlerManager, amlPath, htmlElement, htmlDiv, 0);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        return htmlDiv;
    }

    private HtmlElement composeSpace() {
        HtmlContainer htmlContainer = new HtmlContainer();
        try {
            htmlContainer.addHtmlAttribute("text", SPACE);
        }
        catch (HtmlAttributeCannotBeAddedException htmlAttributeCannotBeAddedException) {
            // empty catch block
        }
        return htmlContainer;
    }

    private void checkThrow(HandlerError he) throws HandlerError {
        Exception ex = he.getException();
        if (!(ex instanceof HtmlAmlInsufficientMemoryException)) {
            throw he;
        }
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof HtmlAmlCreateNextElementHandlerEvent) {
            HtmlAmlCreateNextElementHandlerEvent createNextElementEvent = (HtmlAmlCreateNextElementHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = createNextElementEvent.getAmlPath();
            boolean memoryError = false;
            try {
                int numberElements;
                HtmlElement cmContainer;
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                if (this.doesCMTBNeedCopy(parentAmlPath) && (cmContainer = this.getControlMenuContainer(parentAmlPath)) instanceof HtmlElementCollection && (numberElements = cmContainer.getNumberElements()) > 1) {
                    HtmlElement filledECMContainer = cmContainer.htmlElementAt(0);
                    int i = 1;
                    while (i < numberElements) {
                        HtmlElement eCMContainer = cmContainer.htmlElementAt(i);
                        int numberChildren = filledECMContainer.getNumberElements();
                        int j = 0;
                        while (j < numberChildren) {
                            HtmlElement childHtmlElement = filledECMContainer.htmlElementAt(j);
                            HtmlElement clChildHtmlElement = childHtmlElement.cloneHtmlElement();
                            HtmlAmlElementUtils.addHtmlElement(this.oHandlerManager, parentAmlPath, eCMContainer, clChildHtmlElement);
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof HtmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.bNoHandleCNEHandlerEvent = true;
            if (memoryError) {
                HtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new HtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                HtmlAmlCreateNextElementHandlerEvent postAgainCNEEvent = new HtmlAmlCreateNextElementHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(postAgainCNEEvent);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HtmlAmlAddChildContainerHandlerEvent) {
            try {
                int numberElements;
                HtmlAmlAddChildContainerHandlerEvent htmlAmlAddChildContainerHandlerEvent = (HtmlAmlAddChildContainerHandlerEvent)this.oCurrentEvent;
                HtmlElement childHtmlElement = htmlAmlAddChildContainerHandlerEvent.getHtmlElement();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (!(amlElement instanceof AxmlControlMenu)) return;
                boolean firstControlMenu = false;
                if (!this.isControlMenuPresent(parentAmlPath)) {
                    HtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new HtmlAmlGetControlMenuParentContainerHandlerEvent(this.oCurrentAmlPath);
                    this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                    HtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getHtmlElement();
                    this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                    firstControlMenu = true;
                }
                HtmlElement htmlElement = this.getControlMenuContainer(parentAmlPath);
                int childIndex = htmlAmlAddChildContainerHandlerEvent.getChildIndex();
                if (htmlElement instanceof HtmlElementCollection && (numberElements = htmlElement.getNumberElements()) >= 1) {
                    htmlElement = htmlElement.htmlElementAt(0);
                }
                this.incNumberCMAdded(parentAmlPath);
                this.addCMElement(parentAmlPath, firstControlMenu, htmlElement, childHtmlElement, childIndex);
                return;
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (!(ex instanceof HtmlAmlInsufficientMemoryException)) return;
                throw he;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (this.oCurrentEvent instanceof HtmlAmlControlMenuOffsetHandlerEvent) {
            HtmlAmlControlMenuOffsetHandlerEvent controlMenuOffsetEvent = (HtmlAmlControlMenuOffsetHandlerEvent)this.oCurrentEvent;
            int childIndex = controlMenuOffsetEvent.getChildIndex();
            int offsetChildIndex = -1;
            try {
                AmlPathInterface parentAmlPath;
                if (this.oCurrentAmlPath != null && this.isControlMenuPresent(parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath))) {
                    int numberControlMenus = this.getNumberControlMenus(this.oCurrentAmlPath);
                    offsetChildIndex = childIndex - numberControlMenus;
                }
            }
            catch (Exception ex) {
                offsetChildIndex = 0;
            }
            controlMenuOffsetEvent.setOffsetChildIndex(offsetChildIndex);
            return;
        }
        if (this.oCurrentEvent instanceof HtmlAmlAddControlMenuElementHandlerEvent) {
            HtmlElement htmlElement;
            HtmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent = (HtmlAmlAddControlMenuElementHandlerEvent)this.oCurrentEvent;
            HtmlElement childHtmlElement = addControlMenuElementEvent.getHtmlElement();
            AmlPathInterface parentAmlPath = this.oCurrentAmlPath;
            boolean firstControlMenu = false;
            if (!this.isControlMenuPresent(parentAmlPath)) {
                HtmlAmlGetControlMenuParentContainerHandlerEvent getControlMenuParentContainerEvent = new HtmlAmlGetControlMenuParentContainerHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEventNow(getControlMenuParentContainerEvent);
                HtmlElement cmParentContainerElement = getControlMenuParentContainerEvent.getHtmlElement();
                this.createControlMenuContainer(parentAmlPath, cmParentContainerElement);
                firstControlMenu = true;
            }
            if ((htmlElement = this.getControlMenuContainer(parentAmlPath)) instanceof HtmlElementCollection) {
                int numberElements = htmlElement.getNumberElements();
                int i = 0;
                while (i < numberElements) {
                    try {
                        HtmlElement containerElement = htmlElement.htmlElementAt(i);
                        this.addCMNMCElement(parentAmlPath, firstControlMenu, containerElement, childHtmlElement);
                    }
                    catch (HtmlElementIndexOutOfBoundsException je) {
                        // empty catch block
                    }
                    ++i;
                }
                return;
            }
            this.addCMNMCElement(parentAmlPath, firstControlMenu, htmlElement, childHtmlElement);
            return;
        }
        if (this.oCurrentEvent instanceof HtmlAmlGetControlMenuParentContainerHandlerEvent) {
            HtmlAmlGetControlMenuParentContainerHandlerEvent controlMenuParentContainerEvent = (HtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent;
            HtmlElement htmlElement = null;
            try {
                AmlPathInterface currentAmlPath = ((HtmlAmlGetControlMenuParentContainerHandlerEvent)this.oCurrentEvent).getAmlPath();
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
                htmlElement = HtmlAmlElementUtils.getChildContainerHtmlElement(this.oHandlerManager, parentAmlPath);
            }
            catch (HandlerError he) {
                throw he;
            }
            catch (Exception ex) {
                throw new HtmlAmlHandlerError(ex);
            }
            controlMenuParentContainerEvent.setHtmlElement(htmlElement);
            return;
        }
        if (!(this.oCurrentEvent instanceof HtmlAmlIsPersistentHandlerEvent)) return;
        ((HtmlAmlIsPersistentHandlerEvent)this.oCurrentEvent).setPersistent(true);
    }

    private void addCMElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, HtmlElement htmlElement, HtmlElement childHtmlElement, int childIndex) throws HandlerError {
        if (!firstControlMenu) {
            HtmlElement spaceElement = this.composeSpace();
            HtmlAmlElementUtils.addHtmlElement(this.oHandlerManager, parentAmlPath, htmlElement, spaceElement, childIndex);
            if (childIndex != -1) {
                ++childIndex;
            }
        }
        HtmlAmlElementUtils.addHtmlElement(this.oHandlerManager, parentAmlPath, htmlElement, childHtmlElement, childIndex);
    }

    private void addCMNMCElement(AmlPathInterface parentAmlPath, boolean firstControlMenu, HtmlElement htmlElement, HtmlElement childHtmlElement) throws HandlerError {
        try {
            if (!firstControlMenu) {
                HtmlElement spaceElement = this.composeSpace();
                HtmlAmlElementUtils.addHtmlElement(this.oHandlerManager, parentAmlPath, htmlElement, spaceElement);
            }
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
        try {
            HtmlAmlElementUtils.addHtmlElement(this.oHandlerManager, parentAmlPath, htmlElement, childHtmlElement);
        }
        catch (HandlerError he) {
            this.checkThrow(he);
        }
    }
}

