/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml;

import com.aligo.hdml.HdmlElementCollection;
import com.aligo.hdml.HdmlHdml;
import com.aligo.hdml.exceptions.HdmlElementIndexOutOfBoundsException;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.HdmlAmlHandler;
import com.aligo.modules.hdml.events.HdmlAmlAddCurrentMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlAddMenuHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlCacheContentsHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetActiveIndexMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetElementLinkEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetHdmlChildContainerStateHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetLinksHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetValidElementEvent;
import com.aligo.modules.hdml.events.HdmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlRemoveCurrentMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlReserveActionMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlResetCurrentMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlSetActionMemoryReserveHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlSetFormMemoryReserveHandlerEvent;
import com.aligo.modules.hdml.util.HdmlAmlElementUtils;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.util.PageCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class HdmlAmlPresentationContainerHandler
extends HdmlAmlHandler
implements PageAllocatorInterface {
    public static final long HIGH_RELEVANCE = 10L;
    public static final long ACTION_HIGHMEM = 80L;
    public static final long ACTION_LOWMEM = 40L;
    public static final long FORM_HIGHMEM = 20L;
    public static final long FORM_LOWMEM = 5L;
    private static final String ELEMENT_PREFIX = "agp";
    private static final String ELEMENT_REFERENCE = "#";
    private static final long DEFAULT_HIGHMEM = 1000L;
    private static final String EXISTS = "true";
    protected HdmlElementCollection oHdmlDecks = new HdmlElementCollection();
    protected boolean bIsTransactionEvent;
    private long lActionMemoryReserve = 40L;
    private long lFormMemoryReserve = 0L;
    private Map oPageURLMap = Collections.synchronizedMap(new HashMap());
    private Map oPageIDMap = Collections.synchronizedMap(new HashMap());
    private Map oElementURLs = Collections.synchronizedMap(new HashMap());
    private Map oElementLinks = Collections.synchronizedMap(new HashMap());
    private int iCurrentElementNumber;
    private String sCurrentElementURL;
    private String sPreviousElementURL;
    private String sCurrentElementID;
    private String sPreviousElementID;
    private PageCache oPageCache;
    private String sCacheURL;
    private boolean bNavigatePrevious = false;
    private String sPreviousLabel = "Back";
    private String sNextLabel = "More";
    private long lMemory;
    private int iActiveIndex = 0;
    private int iBaseIndex = 0;
    private int iMenuIndex;
    private Vector oDeckIndices = new Vector();
    private int iDeckIndex = 0;
    private int iNumActions;
    private Hashtable oPresentationElements;
    private Hashtable oCurrentMemories;
    private int iCurrentRealm;

    public HdmlAmlPresentationContainerHandler() {
        this.oDeckIndices.addElement(new Integer(this.iActiveIndex));
        this.iNumActions = 0;
        this.oPresentationElements = new Hashtable();
        this.oCurrentMemories = new Hashtable();
    }

    public void init() {
        UAProfile uaProfile = this.getUAProfile();
        this.lMemory = uaProfile.getPDUSize();
        if (this.lMemory == 0L) {
            this.defaultMemory();
        }
        HdmlAmlElementUtils.addPresentationElement(this.oPresentationElements, (HdmlElement)this.oHdmlDecks);
    }

    private void defaultMemory() {
        this.lMemory = 1000L;
    }

    private long deckMemory() {
        long actualMemory = this.lMemory - ((long)this.iNumActions * this.lActionMemoryReserve + (long)this.iNumActions * this.lFormMemoryReserve);
        return actualMemory;
    }

    public HdmlElement getHdmlDecks() {
        HdmlElement hdmlElement = null;
        try {
            hdmlElement = this.oHdmlDecks.hdmlElementAt(0);
        }
        catch (HdmlElementIndexOutOfBoundsException hdmlElementIndexOutOfBoundsException) {
            // empty catch block
        }
        return hdmlElement;
    }

    public void allocatePage() {
        int index = this.iBaseIndex + this.iActiveIndex;
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        pageURL.append(ELEMENT_REFERENCE);
        pageURL.append(ELEMENT_PREFIX);
        pageURL.append(this.iCurrentElementNumber);
        this.oPageURLMap.put(new Integer(index), pageURL.toString());
        int numberIndices = this.oDeckIndices.size();
        if (this.iDeckIndex == numberIndices - 1) {
            ++this.iActiveIndex;
            this.oDeckIndices.addElement(new Integer(this.iActiveIndex));
            ++this.iDeckIndex;
        } else {
            ++this.iDeckIndex;
        }
        this.iMenuIndex = 0;
        this.iNumActions = 0;
        this.lActionMemoryReserve = 40L;
        this.lFormMemoryReserve = 0L;
    }

    private int getActiveIndex() {
        return this.getActiveIndex(this.iDeckIndex);
    }

    private int getActiveIndex(int deckIndex) {
        Integer IActiveIndex = (Integer)this.oDeckIndices.elementAt(deckIndex);
        return IActiveIndex;
    }

    private int getMIndex() {
        return this.getMIndex(0);
    }

    private int getMIndex(int step) {
        int deckIndex = this.iDeckIndex;
        int numberIndices = this.oDeckIndices.size();
        if ((deckIndex += step) >= numberIndices) {
            ++this.iActiveIndex;
            this.oDeckIndices.addElement(new Integer(this.iActiveIndex));
        }
        int activeIndex = this.getActiveIndex(deckIndex);
        int index = this.iBaseIndex + activeIndex;
        return index;
    }

    public void allocateElement() {
        this.sPreviousElementID = this.sCurrentElementID;
        StringBuffer elementID = new StringBuffer(ELEMENT_PREFIX);
        elementID.append(this.iCurrentElementNumber);
        this.sCurrentElementID = elementID.toString();
        StringBuffer url = new StringBuffer(this.sCacheURL);
        url.append(this.getMIndex());
        url.append(ELEMENT_REFERENCE);
        url.append(ELEMENT_PREFIX);
        url.append(this.iCurrentElementNumber);
        String currElementURL = url.toString();
        this.oElementURLs.put(this.sCurrentElementID, currElementURL);
        if (this.sPreviousElementID != null) {
            String prevElementURLPrefix;
            String currElementURLPrefix = currElementURL.substring(0, currElementURL.indexOf(this.sCurrentElementID));
            String prevElementURL = this.getElementURL(this.sPreviousElementID);
            if (prevElementURL != null && (prevElementURLPrefix = prevElementURL.substring(0, prevElementURL.indexOf(this.sPreviousElementID))).equals(currElementURLPrefix)) {
                this.oElementLinks.put(this.sPreviousElementID, this.sCurrentElementID);
            }
        }
        ++this.iCurrentElementNumber;
    }

    public void changeElement(String oldId, String newId) {
    }

    public String getElementLink(String elementID) {
        return (String)this.oElementLinks.get(elementID);
    }

    private String getElementIDLinkingTo(String elementID) {
        String result = null;
        Iterator keys = this.oElementLinks.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String tmpElementID = (String)this.oElementLinks.get(key);
            if (tmpElementID == null || !tmpElementID.equals(elementID)) continue;
            result = key;
        }
        return result;
    }

    public void deallocateElement(String elementID) {
        String elementLinkFrom = this.getElementIDLinkingTo(elementID);
        String elementLinkTo = (String)this.oElementLinks.get(elementID);
        if (elementLinkFrom != null && elementLinkTo != null) {
            this.oElementLinks.put(elementLinkFrom, elementLinkTo);
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
                this.sPreviousElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom != null && elementLinkTo == null) {
            if (this.sPreviousElementID != null && this.sPreviousElementID.equals(elementLinkFrom) && this.sCurrentElementID.equals(elementID)) {
                this.sPreviousElementID = this.getElementIDLinkingTo(elementLinkFrom);
                this.sCurrentElementID = elementLinkFrom;
            }
        } else if (elementLinkFrom == null && elementLinkTo != null && this.sPreviousElementID != null && this.sPreviousElementID.equals(elementID) && this.sCurrentElementID.equals(elementLinkTo)) {
            this.sPreviousElementID = null;
            this.sCurrentElementID = elementLinkTo;
        }
        this.oElementLinks.remove(elementID);
        this.oElementURLs.remove(elementID);
    }

    private String createPageURL(int index, int elementNumber) {
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        return pageURL.toString();
    }

    private String createPageURL(int index, String elementID) {
        StringBuffer pageURL = new StringBuffer(this.sCacheURL);
        pageURL.append(index);
        pageURL.append(ELEMENT_REFERENCE);
        pageURL.append(elementID);
        return pageURL.toString();
    }

    public boolean navigatePrevious() {
        return this.bNavigatePrevious;
    }

    public String getPreviousLabel() {
        return this.sPreviousLabel;
    }

    public void setPreviousLabel(String label) {
        if (label != null && !label.equals("")) {
            this.sPreviousLabel = label;
            this.bNavigatePrevious = true;
        }
    }

    public String getNextLabel() {
        return this.sNextLabel;
    }

    public void setNextLabel(String label) {
        this.sNextLabel = label;
    }

    public void assignPageID(String pageID) {
        this.oPageIDMap.put(pageID, new Integer(this.getMIndex()));
    }

    public String getPageURL(String pageID) {
        return (String)this.oPageURLMap.get((Integer)this.oPageIDMap.get(pageID));
    }

    public String getCurrentPageURL() {
        int mIndex = this.getMIndex();
        return this.createPageURL(mIndex, this.iCurrentElementNumber);
    }

    public String getPreviousPageURL() {
        String prevURL = null;
        if (this.getActiveIndex() > 0) {
            int mIndex = this.getMIndex(-1);
            prevURL = this.createPageURL(mIndex, this.iCurrentElementNumber - 1);
        }
        return prevURL;
    }

    public String getNextPageURL() {
        String nextURL = null;
        int mIndex = this.getMIndex(1);
        nextURL = this.createPageURL(mIndex, this.iCurrentElementNumber + 1);
        return nextURL;
    }

    public String getElementURL(String elementID) {
        String result = null;
        if (elementID != null && !elementID.equals("")) {
            result = (String)this.oElementURLs.get(elementID);
        }
        return result;
    }

    public String getCurrentElementURL() {
        return this.getElementURL(this.sCurrentElementID);
    }

    public String getPreviousElementURL() {
        return this.getElementURL(this.sPreviousElementID);
    }

    public String getCurrentElementID() {
        return this.sCurrentElementID;
    }

    public String getPreviousElementID() {
        return this.sPreviousElementID;
    }

    public boolean isElementLinkValid(String linkFromElementID, String linkToElementID) {
        String tmpElementID = this.getElementIDLinkingTo(linkToElementID);
        return linkFromElementID.equals(tmpElementID);
    }

    public boolean isValidPageElement(String elementID) {
        return this.oElementURLs.containsKey(elementID);
    }

    public String getCacheURL() {
        return this.sCacheURL;
    }

    public void setCacheURL(String cacheURL) {
        this.sCacheURL = cacheURL;
    }

    public PageCache getPageCache() {
        return this.oPageCache;
    }

    public void setPageCache(PageCache pageCache) {
        this.oPageCache = pageCache;
    }

    private int getCurrentPageID() {
        return this.getMIndex();
    }

    private int getPreviousPageID() {
        int prevId = -1;
        if (this.iActiveIndex > 0) {
            prevId = this.iActiveIndex + this.iBaseIndex - 1;
        }
        return prevId;
    }

    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetHdmlChildContainerStateHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlIsSufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlIsDeckSaneMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetLinksHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetRemainingMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlCacheContentsHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlAddMenuHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetValidElementEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetElementLinkEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlReserveActionMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlSetActionMemoryReserveHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlSetFormMemoryReserveHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetCurrentPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetPreviousPageIDHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetPageAllocatorMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlResetCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlAddCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlRemoveCurrentMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetPresentationElementsHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetActiveIndexMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlRelevance() {
        long currentHdmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlGetHdmlChildContainerStateHandlerEvent) {
            HdmlAmlGetHdmlChildContainerStateHandlerEvent getHdmlChildContainerStateHandlerEvent = (HdmlAmlGetHdmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            AmlPathInterface amlPath = getHdmlChildContainerStateHandlerEvent.getAmlPath();
            if (amlPath == null) {
                currentHdmlAmlRelevance = 10L;
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlIsSufficientMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlIsDeckSaneMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetLinksHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetRemainingMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlCacheContentsHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlAddMenuHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetValidElementEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetElementLinkEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlReserveActionMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlSetActionMemoryReserveHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlSetFormMemoryReserveHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetCurrentPageIDHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetPreviousPageIDHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetPageAllocatorMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlResetCurrentMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlAddCurrentMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlRemoveCurrentMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetPresentationElementsHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetActiveIndexMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 10L;
        }
        return currentHdmlAmlRelevance;
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof HdmlAmlGetHdmlChildContainerStateHandlerEvent) {
            HdmlAmlGetHdmlChildContainerStateHandlerEvent hdmlAmlHdmlChildContainerStateHandlerEvent = (HdmlAmlGetHdmlChildContainerStateHandlerEvent)this.oCurrentEvent;
            hdmlAmlHdmlChildContainerStateHandlerEvent.setHdmlElement(this.oHdmlDecks);
        } else if (this.oCurrentEvent instanceof HdmlAmlIsSufficientMemoryHandlerEvent) {
            HdmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = (HdmlAmlIsSufficientMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = isSufficientMemoryEvent.getAmlPath();
            boolean memorySufficient = this.isMemorySufficient(currentAmlPath);
            isSufficientMemoryEvent.setSufficient(memorySufficient);
        } else if (this.oCurrentEvent instanceof HdmlAmlIsDeckSaneMemoryHandlerEvent) {
            HdmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = (HdmlAmlIsDeckSaneMemoryHandlerEvent)this.oCurrentEvent;
            boolean deckSane = this.isDeckSane();
            isDeckSaneEvent.setSane(deckSane);
        } else if (this.oCurrentEvent instanceof HdmlAmlGetLinksHandlerEvent) {
            HdmlAmlGetLinksHandlerEvent getLinksEvent = (HdmlAmlGetLinksHandlerEvent)this.oCurrentEvent;
            getLinksEvent.setLinks(this.oElementLinks);
        } else if (this.oCurrentEvent instanceof HdmlAmlGetRemainingMemoryHandlerEvent) {
            HdmlAmlGetRemainingMemoryHandlerEvent remainingMemoryEvent = (HdmlAmlGetRemainingMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = remainingMemoryEvent.getAmlPath();
            long remainingMemory = 0L;
            try {
                long bytes = this.getCurrentNumberBytes(currentAmlPath);
                long memory = this.deckMemory();
                if (memory > bytes) {
                    remainingMemory = memory - bytes;
                }
            }
            catch (HdmlElementIndexOutOfBoundsException ie) {
                // empty catch block
            }
            remainingMemoryEvent.setNumberBytes(remainingMemory);
        } else if (this.oCurrentEvent instanceof HdmlAmlCacheContentsHandlerEvent) {
            this.allocatePage();
            int i = 0;
            while (i < this.iActiveIndex) {
                int index = this.iBaseIndex + i;
                try {
                    this.oPageCache.putIndexedPage(Integer.toString(index), this.oHdmlDecks.hdmlElementAt(i).getContents());
                }
                catch (HdmlElementIndexOutOfBoundsException ie) {
                    // empty catch block
                }
                ++i;
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlAddMenuHandlerEvent) {
            HdmlAmlAddMenuHandlerEvent addMenuEvent = (HdmlAmlAddMenuHandlerEvent)this.oCurrentEvent;
            HdmlElement menu = addMenuEvent.getMenu();
            if (menu != null) {
                try {
                    this.iMenuIndex = ++this.iActiveIndex;
                    int index = this.iBaseIndex + this.iMenuIndex;
                    HdmlHdml menuDeck = new HdmlHdml();
                    menuDeck.addHdmlAttribute("ttl", "0");
                    menuDeck.addHdmlAttribute("version", "3.0");
                    menuDeck.addHdmlAttribute("public", EXISTS);
                    menuDeck.addHdmlElement(menu);
                    this.oHdmlDecks.addHdmlElement(menuDeck);
                    String menuUrl = this.createPageURL(index, menu.getHdmlAttributeValue("name"));
                    addMenuEvent.setMenuUrl(menuUrl);
                }
                catch (Exception ex) {
                    this.oHandlerLogger.logError(ex);
                }
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlGetValidElementEvent) {
            HdmlAmlGetValidElementEvent getValidElementEvent = (HdmlAmlGetValidElementEvent)this.oCurrentEvent;
            String elementID = getValidElementEvent.getElementID();
            if (elementID != null) {
                getValidElementEvent.setValidElement(this.isValidPageElement(elementID));
            } else {
                getValidElementEvent.setValidElement(false);
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlGetElementLinkEvent) {
            HdmlAmlGetElementLinkEvent getElementLinkEvent = (HdmlAmlGetElementLinkEvent)this.oCurrentEvent;
            String elementID = getElementLinkEvent.getElementID();
            if (elementID != null) {
                String elementLinkFrom = this.getElementIDLinkingTo(elementID);
                getElementLinkEvent.setElementLinkFrom(elementLinkFrom);
                String elementLinkTo = this.getElementLink(elementID);
                getElementLinkEvent.setElementLinkTo(elementLinkTo);
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlReserveActionMemoryHandlerEvent) {
            ++this.iNumActions;
        } else if (this.oCurrentEvent instanceof HdmlAmlSetActionMemoryReserveHandlerEvent) {
            HdmlAmlSetActionMemoryReserveHandlerEvent setActionMemoryReserveEvent = (HdmlAmlSetActionMemoryReserveHandlerEvent)this.oCurrentEvent;
            long actionMemoryReserve = setActionMemoryReserveEvent.getActionMemoryReserve();
            if (actionMemoryReserve > 0L) {
                this.lActionMemoryReserve = actionMemoryReserve;
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlSetFormMemoryReserveHandlerEvent) {
            HdmlAmlSetFormMemoryReserveHandlerEvent setFormMemoryReserveEvent = (HdmlAmlSetFormMemoryReserveHandlerEvent)this.oCurrentEvent;
            long formMemoryReserve = setFormMemoryReserveEvent.getFormMemoryReserve();
            if (formMemoryReserve > 0L) {
                this.lFormMemoryReserve = formMemoryReserve;
            }
        } else if (this.oCurrentEvent instanceof HdmlAmlGetCurrentPageIDHandlerEvent) {
            HdmlAmlGetCurrentPageIDHandlerEvent currentPageIDEvent = (HdmlAmlGetCurrentPageIDHandlerEvent)this.oCurrentEvent;
            currentPageIDEvent.setID(new Integer(this.getCurrentPageID()).toString());
        } else if (this.oCurrentEvent instanceof HdmlAmlGetPreviousPageIDHandlerEvent) {
            HdmlAmlGetPreviousPageIDHandlerEvent previousPageIDEvent = (HdmlAmlGetPreviousPageIDHandlerEvent)this.oCurrentEvent;
            previousPageIDEvent.setID(new Integer(this.getPreviousPageID()).toString());
        } else if (this.oCurrentEvent instanceof HdmlAmlGetPageAllocatorMemoryHandlerEvent) {
            HdmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = (HdmlAmlGetPageAllocatorMemoryHandlerEvent)this.oCurrentEvent;
            getPageAllocatorEvent.setPageAllocator(this);
        } else if (this.oCurrentEvent instanceof HdmlAmlResetCurrentMemoryHandlerEvent) {
            AmlPathInterface currentAmlPath = ((HdmlAmlResetCurrentMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.resetCurrentMemory(currentAmlPath);
        } else if (this.oCurrentEvent instanceof HdmlAmlAddCurrentMemoryHandlerEvent) {
            HdmlAmlAddCurrentMemoryHandlerEvent addCurrentMemoryEvent = (HdmlAmlAddCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = addCurrentMemoryEvent.getAmlPath();
            long addMemory = addCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory += addMemory);
        } else if (this.oCurrentEvent instanceof HdmlAmlRemoveCurrentMemoryHandlerEvent) {
            HdmlAmlRemoveCurrentMemoryHandlerEvent removeCurrentMemoryEvent = (HdmlAmlRemoveCurrentMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = removeCurrentMemoryEvent.getAmlPath();
            long removeMemory = removeCurrentMemoryEvent.getMemory();
            long currentMemory = this.getCurrentMemory(currentAmlPath);
            this.setCurrentMemory(currentAmlPath, currentMemory -= removeMemory);
        } else if (this.oCurrentEvent instanceof HdmlAmlGetPresentationElementsHandlerEvent) {
            HdmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = (HdmlAmlGetPresentationElementsHandlerEvent)this.oCurrentEvent;
            getPresentationElementsEvent.setHdmlElements(this.oPresentationElements);
        } else if (this.oCurrentEvent instanceof HdmlAmlGetActiveIndexMemoryHandlerEvent) {
            HdmlAmlGetActiveIndexMemoryHandlerEvent event = (HdmlAmlGetActiveIndexMemoryHandlerEvent)this.oCurrentEvent;
            event.setActiveIndex(this.getActiveIndex());
        }
    }

    private boolean isMemorySufficient(AmlPathInterface currentAmlPath) {
        boolean memorySufficient = true;
        try {
            long bytes = this.getCurrentNumberBytes(currentAmlPath);
            long memory = this.deckMemory();
            if (bytes > memory) {
                memorySufficient = false;
            }
        }
        catch (HdmlElementIndexOutOfBoundsException ie) {
            memorySufficient = false;
        }
        return memorySufficient;
    }

    private long getCurrentNumberBytes(AmlPathInterface currentAmlPath) throws HdmlElementIndexOutOfBoundsException {
        long bytes = this.getCurrentMemory(currentAmlPath);
        return bytes;
    }

    private boolean isElementSane(HdmlElement hdmlElement) {
        boolean elementSane = true;
        if (hdmlElement == null) {
            elementSane = false;
        } else {
            elementSane = hdmlElement.areHdmlChildrenSane();
            if (elementSane && (elementSane = hdmlElement.areHdmlAttributesSane())) {
                int numberChildren = hdmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren && elementSane) {
                    try {
                        HdmlElement childHdmlElement = hdmlElement.hdmlElementAt(i);
                        elementSane = this.isElementSane(childHdmlElement);
                    }
                    catch (HdmlElementIndexOutOfBoundsException ie) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        return elementSane;
    }

    private boolean isDeckSane() {
        boolean deckSane = true;
        try {
            HdmlElement hdmlElement = this.oHdmlDecks.hdmlElementAt(this.getActiveIndex());
            deckSane = this.isElementSane(hdmlElement);
        }
        catch (HdmlElementIndexOutOfBoundsException ie) {
            deckSane = false;
        }
        return deckSane;
    }

    private long getDefaultMemory() {
        return 0L;
    }

    private void resetCurrentMemory(AmlPathInterface currentAmlPath) {
        this.setCurrentMemory(currentAmlPath, this.getDefaultMemory());
    }

    private long getCurrentMemory(AmlPathInterface currentAmlPath) {
        int realm = currentAmlPath.getRealm();
        Long objMemory = (Long)this.oCurrentMemories.get(new Integer(realm));
        long memory = this.getDefaultMemory();
        if (objMemory != null) {
            memory = objMemory;
        }
        return memory;
    }

    private void setCurrentMemory(AmlPathInterface currentAmlPath, long memory) {
        int realm = currentAmlPath.getRealm();
        this.oCurrentMemories.put(new Integer(realm), new Long(memory));
    }
}

