/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml;

import com.aligo.axml.AxmlCheckBox;
import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.AxmlInput;
import com.aligo.axml.AxmlLink;
import com.aligo.axml.AxmlListItem;
import com.aligo.axml.AxmlOption;
import com.aligo.axml.AxmlText;
import com.aligo.axml.AxmlTextArea;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.hdml.HdmlA;
import com.aligo.hdml.HdmlAction;
import com.aligo.hdml.HdmlCe;
import com.aligo.hdml.HdmlChoice;
import com.aligo.hdml.HdmlContainer;
import com.aligo.hdml.HdmlDisplay;
import com.aligo.hdml.HdmlImg;
import com.aligo.hdml.HdmlPCData;
import com.aligo.hdml.exceptions.HdmlAttributeCannotBeAddedException;
import com.aligo.hdml.exceptions.HdmlElementIndexOutOfBoundsException;
import com.aligo.hdml.exceptions.HdmlElementNotFoundException;
import com.aligo.hdml.interfaces.HdmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.hdml.HdmlAmlHandler;
import com.aligo.modules.hdml.amlhandlets.events.HdmlAmlGetControlMenuchoiceHandletEvent;
import com.aligo.modules.hdml.amlhandlets.events.HdmlAmlSetFormUrlHandletEvent;
import com.aligo.modules.hdml.events.HdmlAmlAddMenuHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlCheckLinkFormHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlCreateElementHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlEndRenderingHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetDynamicURLHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetFormRedirectionInfoHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetLastWorkingPathHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlIsCachedChoiceFormHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlLinkElementsHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlLinkFormHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlLinkPageHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlSetCurrentPageHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlStartNewRealmMemoryHandlerEvent;
import com.aligo.modules.hdml.exceptions.HdmlAmlInsufficientMemoryException;
import com.aligo.modules.hdml.handlets.events.HdmlAmlAddHdmlElementHandletEvent;
import com.aligo.modules.hdml.util.HdmlAmlElementUtils;
import com.aligo.modules.hdml.util.HdmlAmlMemoryUtils;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.AmlPath;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.util.FormRedirectionInfo;
import com.aligo.util.FormRedirector;
import java.util.Vector;

public class HdmlAmlMemoryHandler
extends HdmlAmlHandler {
    public static final String PERSIST = "persist";
    public static final String PERSIST_FALSE = "false";
    private static final String PAGE = "com.aligo.axml.AxmlPage";
    private static final String FORM = "com.aligo.axml.AxmlForm";
    private static final String CHOICE = "com.aligo.axml.AxmlChoice";
    private static final String FORM_NAME = "Form";
    private static final String FORM_ACTION = "action";
    private static final String HASH = "#";
    private static final String EQUALS = "=";
    private int iRealm = 0;
    private AmlPathInterface oLastWorkingPath;
    private static final String PREV_LABEL_NONE = "NONE";
    private static final String MORE = "More";
    private static final String BACK = "Back";
    private static final String HREF = "href";
    private static final String TEXT = "text";
    private AmlPathInterface oCurrentPagePath = null;
    private AmlPathInterface oLastPagePath = null;
    private HdmlElement lastPageFirstElement = null;
    private HdmlElement lastPageLastElement = null;
    private HdmlElement currPageFirstElement = null;
    private HdmlElement currPageLastElement = null;
    private AmlPathInterface formPath;
    private AmlPathInterface oLastFormPath;
    private AmlPathInterface oActualLastFormPath;
    private boolean bPageSet = false;
    private boolean bIsChoiceFormPresent = false;
    private Vector oLastFormRedirectors = new Vector();
    private String oSecondLastChoiceFormURL = null;
    private boolean bClosingChoiceFormCall = false;
    private boolean bDisablePageBack = false;
    private boolean bDisablePageMore = false;
    private boolean isTerminalChoiceElement;
    private AmlPathInterface oSecondLastFormPath;

    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlInsufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlStartNewRealmMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlSetCurrentPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlLinkPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlCheckLinkFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlIsCachedChoiceFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetLastWorkingPathHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlRelevance() {
        long currentHdmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlInsufficientMemoryHandlerEvent || this.oCurrentEvent instanceof HdmlAmlStartNewRealmMemoryHandlerEvent || this.oCurrentEvent instanceof HdmlAmlDetachFromTreeMemoryHandlerEvent) {
            currentHdmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof HdmlAmlSetCurrentPageHandlerEvent) {
            currentHdmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof HdmlAmlLinkPageHandlerEvent) {
            currentHdmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof HdmlAmlCheckLinkFormHandlerEvent) {
            currentHdmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof HdmlAmlIsCachedChoiceFormHandlerEvent) {
            currentHdmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof HdmlAmlGetLastWorkingPathHandlerEvent) {
            currentHdmlAmlRelevance = 20L;
        }
        return currentHdmlAmlRelevance;
    }

    public void handleEvent() {
        block29: {
            this.oCurrentEvent = this.oEvent;
            if (this.oCurrentEvent instanceof HdmlAmlInsufficientMemoryHandlerEvent) {
                AmlPathInterface workingPath = ((HdmlAmlInsufficientMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
                boolean sane = false;
                try {
                    AmlPathInterface lastWorkingPath = null;
                    do {
                        AmlPathInterface parentPath;
                        try {
                            AxmlElement amlElement;
                            if (workingPath != null && this.isTextElement(workingPath) && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && ((amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath)) instanceof AxmlTextArea || amlElement instanceof AxmlInput || amlElement instanceof AxmlCheckBox || amlElement instanceof AxmlOption || amlElement instanceof AxmlListItem || amlElement instanceof AxmlLink)) {
                                HdmlAmlResetTextStateHandlerEvent resetTextStateEvent = new HdmlAmlResetTextStateHandlerEvent(workingPath);
                                this.oHandlerManager.postEventNow(resetTextStateEvent);
                            }
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        try {
                            AmlPathInterface previousPath;
                            AxmlElement previousElement;
                            HdmlAmlElementUtils.detachFromTree(this.oHandlerManager, workingPath);
                            AxmlElement currentElement = AmlPathUtils.getAmlElement(this.oHandlerManager, workingPath);
                            if ((currentElement instanceof AxmlInput || currentElement instanceof AxmlTextArea || currentElement instanceof AxmlCheckBox) && (previousElement = AmlPathUtils.getAmlElement(this.oHandlerManager, previousPath = this.getPreviousPath(workingPath))) instanceof AxmlText) {
                                HdmlAmlElementUtils.detachFromTree(this.oHandlerManager, previousPath);
                                workingPath = previousPath;
                            }
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        sane = HdmlAmlElementUtils.isDeckSane(this.oHandlerManager);
                        if (sane && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && !HdmlAmlMemoryUtils.isCacheable(this.oHandlerManager, parentPath)) {
                            sane = HdmlAmlMemoryUtils.isCacheable(this.oHandlerManager, workingPath);
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("Cache sanity: working path " + workingPath + " sanity " + sane);
                            }
                        }
                        lastWorkingPath = workingPath;
                        try {
                            workingPath = this.getPreviousPath(workingPath);
                            if (workingPath == null) continue;
                            int currentNumberElements = workingPath.getNumberAmlPathComponents();
                            int lastNumberElements = lastWorkingPath.getNumberAmlPathComponents();
                            if (lastNumberElements == currentNumberElements) continue;
                            boolean detach = true;
                            if (this.isTextElement(lastWorkingPath)) {
                                HdmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = new HdmlAmlShouldDetachTextMemoryHandlerEvent(lastWorkingPath);
                                this.oHandlerManager.postEventNow(shouldDetachTextMemoryEvent);
                                detach = shouldDetachTextMemoryEvent.isDetach();
                            }
                            if (!detach) continue;
                            sane = false;
                        }
                        catch (HandlerError he) {
                            sane = true;
                        }
                    } while (!sane && workingPath != null);
                    this.bDisablePageBack = false;
                    this.bDisablePageMore = false;
                    this.checkLinkForm(lastWorkingPath);
                    AmlPathInterface rootPath = AmlPathUtils.getRootPath(this.oHandlerManager, lastWorkingPath);
                    AmlPathInterface pagePath = null;
                    try {
                        pagePath = AmlPathUtils.getAncestorPath(this.oHandlerManager, lastWorkingPath, PAGE);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    HdmlAmlLinkElementsHandlerEvent linkElementsEvent = new HdmlAmlLinkElementsHandlerEvent(rootPath);
                    linkElementsEvent.setPagePath(pagePath);
                    this.oHandlerManager.postEventNow(linkElementsEvent);
                    this.checkLinkPage(pagePath);
                    boolean end = false;
                    if (workingPath == null) {
                        end = true;
                    } else if (this.oLastWorkingPath != null) {
                        boolean insufficient = false;
                        try {
                            boolean ancestorPersistent = HdmlAmlMemoryUtils.isAncestorPersistent(this.oHandlerManager, lastWorkingPath);
                            if (ancestorPersistent) {
                                insufficient = true;
                            }
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        if (!this.isTextElement(lastWorkingPath)) {
                            String lastCanonicalPath = this.oLastWorkingPath.getCanonicalPath();
                            String currentLastCanonicalPath = lastWorkingPath.getCanonicalPath();
                            if (currentLastCanonicalPath.equals(lastCanonicalPath)) {
                                insufficient = true;
                            }
                        }
                        if (insufficient) {
                            System.out.println("Page too big for device");
                            end = true;
                        }
                    }
                    if (end) {
                        this.end();
                        break block29;
                    }
                    this.startNewRealm(lastWorkingPath);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.end();
                }
            } else if (this.oCurrentEvent instanceof HdmlAmlStartNewRealmMemoryHandlerEvent) {
                this.startNewRealm(((HdmlAmlStartNewRealmMemoryHandlerEvent)this.oCurrentEvent).getAmlPath());
            }
        }
    }

    public void handleEventNow() throws HandlerError {
        this.oCurrentEvent = this.oEvent;
        if (this.oCurrentEvent instanceof HdmlAmlDetachFromTreeMemoryHandlerEvent) {
            HdmlAmlDetachFromTreeMemoryHandlerEvent detachFromTreeMemoryEvent = (HdmlAmlDetachFromTreeMemoryHandlerEvent)this.oCurrentEvent;
            AmlPathInterface removePath = detachFromTreeMemoryEvent.getAmlPath();
            AmlPathInterface restartPath = this.detachFromTree(removePath);
            detachFromTreeMemoryEvent.setRestartAmlPath(restartPath);
        } else if (this.oCurrentEvent instanceof HdmlAmlSetCurrentPageHandlerEvent) {
            HdmlAmlSetCurrentPageHandlerEvent setCurrentPageEvent = (HdmlAmlSetCurrentPageHandlerEvent)this.oCurrentEvent;
            this.oLastPagePath = this.oCurrentPagePath;
            this.oCurrentPagePath = setCurrentPageEvent.getAmlPath();
            this.lastPageFirstElement = this.currPageFirstElement;
            this.lastPageLastElement = this.currPageLastElement;
            this.currPageFirstElement = setCurrentPageEvent.getFirstElement();
            this.currPageLastElement = setCurrentPageEvent.getLastElement();
            this.bPageSet = true;
        } else if (this.oCurrentEvent instanceof HdmlAmlLinkPageHandlerEvent) {
            HdmlAmlGetControlMenuchoiceHandletEvent getMenuChoiceEvent = new HdmlAmlGetControlMenuchoiceHandletEvent(this.oLastPagePath);
            this.oHandlerManager.postEventNow(getMenuChoiceEvent);
            HdmlChoice pageChoice = getMenuChoiceEvent.getHdmlChoiceElement();
            this.linkPage(pageChoice, this.oSecondLastFormPath);
        } else if (this.oCurrentEvent instanceof HdmlAmlCheckLinkFormHandlerEvent) {
            AmlPathInterface formPath = ((HdmlAmlCheckLinkFormHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.checkLinkForm(formPath);
        } else if (this.oCurrentEvent instanceof HdmlAmlIsCachedChoiceFormHandlerEvent) {
            HdmlAmlIsCachedChoiceFormHandlerEvent isCachedChoiceFormEvent = (HdmlAmlIsCachedChoiceFormHandlerEvent)this.oCurrentEvent;
            AmlPathInterface path = isCachedChoiceFormEvent.getAmlPath();
            boolean cached = this.isCachedChoiceForm(path);
            isCachedChoiceFormEvent.setCached(cached);
        } else if (this.oCurrentEvent instanceof HdmlAmlGetLastWorkingPathHandlerEvent) {
            ((HdmlAmlGetLastWorkingPathHandlerEvent)this.oCurrentEvent).setAmlPath(this.oLastWorkingPath);
        }
    }

    private void end() {
        HdmlAmlEndRenderingHandlerEvent endRenderingEvent = new HdmlAmlEndRenderingHandlerEvent();
        this.oHandlerManager.postEvent(endRenderingEvent);
    }

    private void startNewRealm(AmlPathInterface lastWorkingPath) {
        this.oLastWorkingPath = lastWorkingPath;
        ++this.iRealm;
        PageAllocatorInterface pageAllocator = HdmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
        pageAllocator.allocatePage();
        AmlPath path = new AmlPath();
        path.setRealm(this.iRealm);
        HdmlAmlCreateElementHandlerEvent createElementEvent = new HdmlAmlCreateElementHandlerEvent(path);
        this.oHandlerManager.postEvent(createElementEvent);
    }

    private boolean isTextElement(AmlPathInterface amlPath) {
        AxmlElement amlElement;
        boolean textElement = false;
        if (amlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath)) instanceof AxmlText) {
            textElement = true;
        }
        return textElement;
    }

    private AmlPathInterface getPreviousPath(AmlPathInterface currentAmlPath) throws HandlerError {
        AmlPathInterface previousPath = null;
        int currentChildIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        HdmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = new HdmlAmlGetPreviousChildIndexHandlerEvent(currentAmlPath, currentChildIndex);
        this.oHandlerManager.postEventNow(getPreviousChildIndexEvent);
        int previousChildIndex = getPreviousChildIndexEvent.getPreviousIndex();
        AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
        previousPath = previousChildIndex < 0 ? parentAmlPath : AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, previousChildIndex);
        return previousPath;
    }

    private AmlPathInterface detachFromTree(AmlPathInterface currentAmlPath) throws HandlerError {
        HdmlElement topElement = HdmlAmlElementUtils.getTopHdmlElement(this.oHandlerManager, currentAmlPath);
        try {
            AxmlElement currentElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
            if (currentElement instanceof AxmlLink) {
                HdmlElement childContainerElement = HdmlAmlElementUtils.getChildContainerHdmlElement(this.oHandlerManager, currentAmlPath);
                HdmlAmlElementUtils.removeHdmlElement(this.oHandlerManager, currentAmlPath, childContainerElement.getHdmlParentElement(), childContainerElement);
            } else {
                HdmlAmlElementUtils.removeHdmlElement(this.oHandlerManager, currentAmlPath, null, topElement);
            }
        }
        catch (HandlerError he) {
            Exception ex = he.getException();
            if (!(ex instanceof HdmlElementNotFoundException)) {
                throw he;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currentAmlPath;
    }

    private boolean isPersistentElement(AxmlElement amlElement) {
        boolean persistentElement = false;
        if (amlElement instanceof AxmlControlMenu) {
            persistentElement = true;
        } else {
            String value = amlElement.getAxmlAttributeValue(PERSIST);
            if (value != null && !value.equals(PERSIST_FALSE)) {
                persistentElement = true;
            }
        }
        return persistentElement;
    }

    private void linkPage(HdmlElement menuChoice, AmlPathInterface formPath) {
        try {
            PageAllocatorInterface pageAllocator = HdmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            if (this.lastPageLastElement != null && this.currPageFirstElement != null) {
                String lastPageLastElementID = this.lastPageLastElement.getHdmlAttributeValue("name");
                String lastPageLastElementURL = pageAllocator.getElementURL(lastPageLastElementID);
                String currPageFirstElementID = this.currPageFirstElement.getHdmlAttributeValue("name");
                String currPageFirstElementURL = pageAllocator.getElementURL(currPageFirstElementID);
                if (formPath != null) {
                    this.assignActions(this.lastPageLastElement, menuChoice, null, null, formPath);
                } else {
                    this.assignActions(this.lastPageLastElement, menuChoice, currPageFirstElementURL, null, formPath);
                }
                this.assignActions(this.currPageFirstElement, null, null, lastPageLastElementURL, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkLinkPage(AmlPathInterface pagePath) {
        if (this.bPageSet) {
            try {
                HdmlAmlGetControlMenuchoiceHandletEvent getMenuChoiceEvent = new HdmlAmlGetControlMenuchoiceHandletEvent(pagePath);
                this.oHandlerManager.postEventNow(getMenuChoiceEvent);
                HdmlChoice pageChoice = getMenuChoiceEvent.getHdmlChoiceElement();
                this.linkPage(pageChoice, this.oSecondLastFormPath);
                this.bPageSet = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isValidLabel(String label) {
        boolean valid = true;
        if (label == null || label != null && label.equalsIgnoreCase("none")) {
            valid = false;
        }
        return valid;
    }

    private String getNextLabel(AmlPathInterface path) {
        String nextLabel = MORE;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tNextLabel = page.getAxmlAttributeValue("next_label");
            if (this.isValidLabel(tNextLabel)) {
                nextLabel = tNextLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nextLabel;
    }

    private String getPrevLabel(AmlPathInterface path) {
        String prevLabel = BACK;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tPrevLabel = page.getAxmlAttributeValue("prev_label");
            if (this.isValidLabel(tPrevLabel)) {
                prevLabel = tPrevLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prevLabel;
    }

    private boolean isCachedChoiceForm(AmlPathInterface amlPath) {
        AmlPathInterface lastChoiceFormPath;
        boolean cached = false;
        if (amlPath != null && this.oLastWorkingPath != null && (lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE)) != null && amlPath.getCanonicalPath().equals(lastChoiceFormPath.getCanonicalPath())) {
            cached = true;
        }
        return cached;
    }

    private void checkLinkForm(AmlPathInterface currentAmlPath) {
        try {
            this.oSecondLastFormPath = this.oActualLastFormPath;
            AmlPathInterface currentFormPath = null;
            if (currentAmlPath != null) {
                currentFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, FORM);
            }
            if (this.bClosingChoiceFormCall && this.oLastFormPath != null) {
                this.oLastFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, this.oLastFormPath);
            }
            boolean lastFormPathSet = false;
            if (this.oLastFormPath != null) {
                AmlPathInterface lastChoiceFormPath = null;
                if (this.oLastWorkingPath != null) {
                    lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE);
                    if (this.bClosingChoiceFormCall) {
                        lastChoiceFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, lastChoiceFormPath);
                    }
                }
                boolean isLastChoiceFormPresent = false;
                String choiceName = null;
                String choiceForwardValue = null;
                Object choiceBackwardValue = null;
                boolean isSecondLastChoiceFormPresent = false;
                if (lastChoiceFormPath != null) {
                    isLastChoiceFormPresent = true;
                    try {
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, lastChoiceFormPath);
                        choiceName = amlElement.getAxmlAttributeValue("name");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (isLastChoiceFormPresent && this.oSecondLastChoiceFormURL != null) {
                    isSecondLastChoiceFormPresent = true;
                }
                if (isLastChoiceFormPresent) {
                    this.bDisablePageMore = true;
                    if (!this.bClosingChoiceFormCall) {
                        try {
                            HdmlCe hdmlCe = new HdmlCe();
                            HdmlPCData hdmlPCData = new HdmlPCData();
                            choiceForwardValue = this.getNextLabel(this.oCurrentPagePath);
                            hdmlPCData.addHdmlAttribute(TEXT, choiceForwardValue);
                            hdmlCe.addHdmlAttribute("value", choiceForwardValue);
                            hdmlCe.addHdmlElement(hdmlPCData);
                            HdmlElement choiceElement = HdmlAmlElementUtils.getChildContainerHdmlElement(this.oHandlerManager, lastChoiceFormPath);
                            try {
                                HdmlAmlAddHdmlElementHandletEvent addHdmlElementEvent = new HdmlAmlAddHdmlElementHandletEvent(choiceElement, hdmlCe);
                                this.oHandlerManager.postEventNow(addHdmlElementEvent);
                            }
                            catch (HandlerError he) {}
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                String currURL = null;
                PageAllocatorInterface pageAllocator = HdmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
                if (!this.bClosingChoiceFormCall) {
                    currURL = pageAllocator.getCurrentPageURL();
                } else {
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastFormPath);
                    currURL = AmlPathUtils.isTerminalElement(this.oHandlerManager, lastChoiceFormPath) ? amlElement.getAxmlAttributeValue("url") : pageAllocator.getNextPageURL();
                }
                String sCurrURL = null;
                if (isLastChoiceFormPresent) {
                    HdmlAmlGetDynamicURLHandlerEvent getDynamicURLEvent = new HdmlAmlGetDynamicURLHandlerEvent();
                    this.oHandlerManager.postEventNow(getDynamicURLEvent);
                    String dynamicURL = getDynamicURLEvent.getURL();
                    String dCurrURL = null;
                    String id = null;
                    if (!this.bClosingChoiceFormCall) {
                        HdmlAmlGetPreviousPageIDHandlerEvent getPreviousPageIDEvent = new HdmlAmlGetPreviousPageIDHandlerEvent();
                        this.oHandlerManager.postEventNow(getPreviousPageIDEvent);
                        id = getPreviousPageIDEvent.getID();
                    } else {
                        HdmlAmlGetCurrentPageIDHandlerEvent getCurrentPageIDEvent = new HdmlAmlGetCurrentPageIDHandlerEvent();
                        this.oHandlerManager.postEventNow(getCurrentPageIDEvent);
                        id = getCurrentPageIDEvent.getID();
                    }
                    dCurrURL = dynamicURL + id;
                    FormRedirector formRedirector = new FormRedirector();
                    formRedirector.setDynamicURL(dCurrURL);
                    if (!this.bClosingChoiceFormCall) {
                        String modifier = choiceName + EQUALS + choiceForwardValue;
                        formRedirector.addModifier(modifier, currURL);
                    }
                    this.oLastFormRedirectors.addElement(formRedirector);
                    sCurrURL = currURL;
                    currURL = dCurrURL;
                }
                try {
                    HdmlAmlSetFormUrlHandletEvent setFormUrlEvent = new HdmlAmlSetFormUrlHandletEvent(this.oLastFormPath, currURL);
                    this.oHandlerManager.postEventNow(setFormUrlEvent);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                this.isTerminalChoiceElement = true;
                if (!AmlPathUtils.isTerminalElement(this.oHandlerManager, lastChoiceFormPath)) {
                    this.isTerminalChoiceElement = false;
                }
                if (isLastChoiceFormPresent) {
                    this.oSecondLastChoiceFormURL = pageAllocator.getPreviousPageURL();
                    currURL = sCurrURL;
                }
                if (isLastChoiceFormPresent) {
                    AmlPathInterface currentChoiceFormPath = null;
                    if (currentAmlPath != null) {
                        currentChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, CHOICE);
                    }
                    boolean closeRedirection = false;
                    if (currentChoiceFormPath == null) {
                        closeRedirection = true;
                    } else if (!currentChoiceFormPath.getCanonicalPath().equals(lastChoiceFormPath.getCanonicalPath())) {
                        closeRedirection = true;
                    }
                    if (closeRedirection) {
                        if (!this.bClosingChoiceFormCall) {
                            this.bClosingChoiceFormCall = true;
                            this.checkLinkForm(null);
                            lastFormPathSet = true;
                            this.bClosingChoiceFormCall = false;
                        }
                        if (this.bClosingChoiceFormCall) {
                            HdmlAmlGetFormRedirectionInfoHandlerEvent getFormRedirectionInfoEvent = new HdmlAmlGetFormRedirectionInfoHandlerEvent();
                            this.oHandlerManager.postEventNow(getFormRedirectionInfoEvent);
                            FormRedirectionInfo formRedirectionInfo = getFormRedirectionInfoEvent.getInfo();
                            int numberElements = this.oLastFormRedirectors.size();
                            int i = 0;
                            while (i < numberElements) {
                                FormRedirector formRedirector = (FormRedirector)this.oLastFormRedirectors.elementAt(i);
                                formRedirector.setOriginalURL(currURL);
                                formRedirectionInfo.addFormRedirector(formRedirector);
                                ++i;
                            }
                            this.oLastFormRedirectors.clear();
                            this.oSecondLastChoiceFormURL = null;
                        }
                    }
                }
            }
            if (!lastFormPathSet) {
                this.oLastFormPath = currentFormPath;
            }
            if (!this.bClosingChoiceFormCall) {
                this.oActualLastFormPath = currentFormPath;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    private void assignActions(HdmlElement element, HdmlElement menu, String elementLinkToUrl, String elementLinkFromUrl, AmlPathInterface formPath) throws HandlerError {
        block91: {
            nextLabel = this.getNextLabel(this.oLastPagePath);
            numControlMenus = 0;
            if (menu != null) {
                numControlMenus = menu.getNumberElements();
            }
            numAvailableSoftKeys = 1;
            if (element instanceof HdmlDisplay && !this.hasLinks(element)) {
                numAvailableSoftKeys = 2;
            }
            numSoftKeyActions = 0;
            haveMenu = false;
            haveForm = false;
            isLastFormElement = false;
            addChoiceToCurrentDeck = false;
            if (menu != null) {
                numSoftKeyActions = menu.getNumberElements();
                haveMenu = true;
            }
            if (elementLinkToUrl != null) {
                ++numSoftKeyActions;
            }
            if (formPath != null) {
                ++numSoftKeyActions;
                haveForm = true;
            }
            if (numAvailableSoftKeys >= 1 && numSoftKeyActions == 1) {
                action = null;
                if (elementLinkToUrl != null) {
                    try {
                        action = new HdmlAction();
                        action.addHdmlAttribute("dest", elementLinkToUrl);
                        action.addHdmlAttribute("label", nextLabel);
                        action.addHdmlAttribute("task", "go");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (haveForm) {
                    try {
                        linkFormEvent = new HdmlAmlLinkFormHandlerEvent(formPath, false);
                        if (!this.isTerminalChoiceElement) {
                            linkFormEvent.setOverrideSubmitLabel(nextLabel);
                        }
                        this.oHandlerManager.postEventNow(linkFormEvent);
                        action = linkFormEvent.getHdmlAction();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (haveMenu && (menuActions = this.convertChoiceToActions(menu, 1)) != null && menuActions.size() > 0) {
                    action = (HdmlAction)menuActions.elementAt(0);
                }
                try {
                    this.assignAccept(element, action);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    hdmlAmlAddHdmlElementHandletEvent = new HdmlAmlAddHdmlElementHandletEvent(element, action, 0);
                    this.oHandlerManager.postEventNow(hdmlAmlAddHdmlElementHandletEvent);
                }
                catch (HandlerError he) {
                    ex = he.getException();
                    if (ex instanceof HdmlAmlInsufficientMemoryException) ** GOTO lbl247
                    throw he;
                }
            } else if (numAvailableSoftKeys == 1 && numSoftKeyActions > 1) {
                elementChoice = new HdmlChoice();
                choiceName = element.getHdmlAttributeValue("name") + "m";
                try {
                    elementChoice.addHdmlAttribute("name", choiceName);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (haveMenu) {
                    this.addControlMenus(elementChoice, menu, 0);
                }
                if (elementLinkToUrl != null) {
                    try {
                        moreCe = new HdmlCe();
                        moreCe.addHdmlAttribute("dest", elementLinkToUrl);
                        moreCe.addHdmlAttribute("task", "go");
                        cetext = new HdmlPCData();
                        cetext.addHdmlAttribute("text", nextLabel);
                        moreCe.addHdmlElement(cetext);
                        elementChoice.addHdmlElement(moreCe);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (haveForm) {
                    try {
                        linkFormEvent = new HdmlAmlLinkFormHandlerEvent(formPath, true);
                        if (!this.isTerminalChoiceElement) {
                            linkFormEvent.setOverrideSubmitLabel(nextLabel);
                        }
                        this.oHandlerManager.postEventNow(linkFormEvent);
                        formCe = linkFormEvent.getHdmlCe();
                        if (formCe != null) {
                            elementChoice.addHdmlElement(formCe);
                            addChoiceToCurrentDeck = true;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    if (!addChoiceToCurrentDeck) {
                        this.createMenuForElement(null, element, elementChoice, false, formPath);
                    }
                    parent = element.getHdmlParentElement();
                    this.createMenuForElement(parent, element, elementChoice, false, formPath);
                }
                catch (HandlerError he) {
                    ex = he.getException();
                    if (ex instanceof HdmlAmlInsufficientMemoryException) ** GOTO lbl247
                    throw he;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (numAvailableSoftKeys == 2 && numSoftKeyActions == 2) {
                block90: {
                    action1 = null;
                    action2 = null;
                    if (haveForm) {
                        try {
                            linkFormEvent = new HdmlAmlLinkFormHandlerEvent(formPath, false);
                            if (!this.isTerminalChoiceElement) {
                                linkFormEvent.setOverrideSubmitLabel(nextLabel);
                            }
                            this.oHandlerManager.postEventNow(linkFormEvent);
                            action1 = linkFormEvent.getHdmlAction();
                            action1.addHdmlAttribute("type", "accept");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (elementLinkToUrl != null) {
                        try {
                            if (action1 == null) {
                                action1 = new HdmlAction();
                                action1.addHdmlAttribute("dest", elementLinkToUrl);
                                action1.addHdmlAttribute("label", nextLabel);
                                action1.addHdmlAttribute("task", "go");
                                action1.addHdmlAttribute("type", "accept");
                            } else {
                                action2 = new HdmlAction();
                                action2.addHdmlAttribute("dest", elementLinkToUrl);
                                action2.addHdmlAttribute("label", nextLabel);
                                action2.addHdmlAttribute("task", "go");
                                action2.addHdmlAttribute("type", "soft1");
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (haveMenu) {
                        try {
                            if (action1 != null && action2 == null && numControlMenus == 1) {
                                menuActions = this.convertChoiceToActions(menu, 1);
                                action2 = (HdmlAction)menuActions.elementAt(0);
                                action2.addHdmlAttribute("type", "soft1");
                            } else if (action1 == null && action2 == null && numControlMenus == 2) {
                                menuActions = this.convertChoiceToActions(menu, 2);
                                action1 = (HdmlAction)menuActions.elementAt(0);
                                action1.addHdmlAttribute("type", "accept");
                                action2 = (HdmlAction)menuActions.elementAt(1);
                                action2.addHdmlAttribute("type", "soft1");
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    try {
                        hdmlAmlAddHdmlElementHandletEvent = new HdmlAmlAddHdmlElementHandletEvent(element, action2, 0);
                        this.oHandlerManager.postEventNow(hdmlAmlAddHdmlElementHandletEvent);
                    }
                    catch (HandlerError he) {
                        ex = he.getException();
                        if (ex instanceof HdmlAmlInsufficientMemoryException) break block90;
                        throw he;
                    }
                }
                try {
                    hdmlAmlAddHdmlElementHandletEvent2 = new HdmlAmlAddHdmlElementHandletEvent(element, action1, 0);
                    this.oHandlerManager.postEventNow(hdmlAmlAddHdmlElementHandletEvent2);
                }
                catch (HandlerError he) {
                    ex = he.getException();
                    if (ex instanceof HdmlAmlInsufficientMemoryException) ** GOTO lbl247
                    throw he;
                }
            } else if (numAvailableSoftKeys == 2 && numSoftKeyActions > 2) {
                elementChoice = new HdmlChoice();
                choiceName = element.getHdmlAttributeValue("name") + "m";
                try {
                    elementChoice.addHdmlAttribute("name", choiceName);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                addMoreToMenu = false;
                action1 = null;
                if (haveForm) {
                    try {
                        linkFormEvent = new HdmlAmlLinkFormHandlerEvent(formPath, false);
                        if (!this.isTerminalChoiceElement) {
                            linkFormEvent.setOverrideSubmitLabel(nextLabel);
                        }
                        this.oHandlerManager.postEventNow(linkFormEvent);
                        action1 = linkFormEvent.getHdmlAction();
                        action1.addHdmlAttribute("type", "accept");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (elementLinkToUrl != null) {
                    try {
                        if (action1 == null) {
                            action1 = new HdmlAction();
                            action1.addHdmlAttribute("dest", elementLinkToUrl);
                            action1.addHdmlAttribute("label", nextLabel);
                            action1.addHdmlAttribute("task", "go");
                            action1.addHdmlAttribute("type", "accept");
                        } else {
                            addMoreToMenu = true;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (haveMenu) {
                    try {
                        if (action1 == null) {
                            menuActions = this.convertChoiceToActions(menu, 1);
                            action1 = (HdmlAction)menuActions.elementAt(0);
                            action1.addHdmlAttribute("type", "accept");
                            this.addControlMenus(elementChoice, menu, 1);
                        } else {
                            this.addControlMenus(elementChoice, menu, 0);
                            if (addMoreToMenu) {
                                moreCe = new HdmlCe();
                                moreCe.addHdmlAttribute("dest", elementLinkToUrl);
                                moreCe.addHdmlAttribute("task", "go");
                                cetext = new HdmlPCData();
                                cetext.addHdmlAttribute("text", nextLabel);
                                moreCe.addHdmlElement(cetext);
                                elementChoice.addHdmlElement(moreCe);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    hdmlAmlAddHdmlElementHandletEvent = new HdmlAmlAddHdmlElementHandletEvent(element, action1, 0);
                    this.oHandlerManager.postEventNow(hdmlAmlAddHdmlElementHandletEvent);
                }
                catch (HandlerError he) {
                    ex = he.getException();
                    if (!(ex instanceof HdmlAmlInsufficientMemoryException)) {
                        throw he;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    this.createMenuForElement(null, element, elementChoice, true, formPath);
                }
                catch (HandlerError he) {
                    ex = he.getException();
                    if (!(ex instanceof HdmlAmlInsufficientMemoryException)) {
                        throw he;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
lbl247:
            // 13 sources

            if (elementLinkFromUrl != null) {
                action = new HdmlAction();
                try {
                    action.addHdmlAttribute("dest", elementLinkFromUrl);
                    action.addHdmlAttribute("task", "go");
                    action.addHdmlAttribute("type", "prev");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    hdmlAmlAddHdmlElementHandletEvent = new HdmlAmlAddHdmlElementHandletEvent(element, action, 0);
                    this.oHandlerManager.postEventNow(hdmlAmlAddHdmlElementHandletEvent);
                }
                catch (HandlerError he) {
                    ex = he.getException();
                    if (ex instanceof HdmlAmlInsufficientMemoryException) break block91;
                    throw he;
                }
            }
        }
    }

    private void addControlMenus(HdmlChoice choice, HdmlElement menu, int numberToSkip) {
        int numControlMenus = menu.getNumberElements();
        if (numberToSkip > numControlMenus) {
            return;
        }
        int m = numberToSkip;
        while (m < numControlMenus) {
            try {
                HdmlElement ce = menu.hdmlElementAt(m);
                choice.addHdmlElement(ce);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++m;
        }
    }

    private Vector convertChoiceToActions(HdmlElement choice, int numberToConvert) {
        Vector<HdmlAction> results = new Vector<HdmlAction>();
        int stop = numberToConvert;
        if (numberToConvert > choice.getNumberElements()) {
            stop = choice.getNumberElements();
        }
        int i = 0;
        while (i < stop) {
            try {
                HdmlCe ce = (HdmlCe)choice.hdmlElementAt(i);
                HdmlAction action = new HdmlAction();
                action.addHdmlAttribute("task", ce.getHdmlAttributeValue("task"));
                String dest = ce.getHdmlAttributeValue("dest");
                if (dest != null) {
                    action.addHdmlAttribute("dest", dest);
                } else {
                    String number = ce.getHdmlAttributeValue("number");
                    if (number != null) {
                        action.addHdmlAttribute("number", number);
                    }
                }
                String vars = ce.getHdmlAttributeValue("vars");
                if (vars != null) {
                    action.addHdmlAttribute("vars", vars);
                }
                HdmlElement text = null;
                if (ce.getNumberElements() > 0) {
                    text = ce.hdmlElementAt(0);
                    if (text instanceof HdmlPCData) {
                        action.addHdmlAttribute("label", text.getContents());
                    } else if (text instanceof HdmlImg) {
                        String labelStr = ((HdmlImg)text).getHdmlAttributeValue("alt");
                        if (labelStr != null && !labelStr.equals("")) {
                            action.addHdmlAttribute("label", labelStr);
                        } else {
                            action.addHdmlAttribute("label", "control" + i);
                        }
                    } else {
                        action.addHdmlAttribute("label", "control" + i);
                    }
                } else {
                    action.addHdmlAttribute("label", "control" + i);
                }
                results.add(action);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        return results;
    }

    private void assignAccept(HdmlElement element, HdmlAction action) throws HdmlAttributeCannotBeAddedException {
        if (element instanceof HdmlChoice) {
            HdmlElement childElement = this.getFirstHdmlCeElement(element);
            if (childElement != null && childElement instanceof HdmlCe) {
                String dest = childElement.getHdmlAttributeValue("dest");
                if (dest != null) {
                    action.addHdmlAttribute("type", "soft1");
                } else {
                    action.addHdmlAttribute("type", "accept");
                }
            } else {
                action.addHdmlAttribute("type", "accept");
            }
        } else if (this.hasLinks(element)) {
            action.addHdmlAttribute("type", "soft1");
        } else {
            action.addHdmlAttribute("type", "accept");
        }
    }

    private HdmlElement getFirstHdmlCeElement(HdmlElement parent) {
        HdmlElement element = null;
        int numberElements = parent.getNumberElements();
        try {
            int i = 0;
            while (i < numberElements) {
                element = parent.hdmlElementAt(i);
                if (element instanceof HdmlContainer) {
                    element = this.getFirstHdmlCeElement(element);
                } else if (element instanceof HdmlCe) {
                    return element;
                }
                ++i;
            }
        }
        catch (HdmlElementIndexOutOfBoundsException ex) {
            // empty catch block
        }
        return element;
    }

    private void createMenuForElement(HdmlElement parent, HdmlElement element, HdmlChoice menu, boolean useSoft1, AmlPathInterface currentAmlPath) throws HdmlAttributeCannotBeAddedException, HandlerError {
        String menuUrl = null;
        if (parent == null) {
            HdmlAmlAddMenuHandlerEvent addMenuEvent = new HdmlAmlAddMenuHandlerEvent();
            addMenuEvent.setMenu(menu);
            this.oHandlerManager.postEventNow(addMenuEvent);
            menuUrl = addMenuEvent.getMenuUrl();
        } else {
            try {
                HdmlAmlAddHdmlElementHandletEvent hdmlAmlAddHdmlElementHandletEvent = new HdmlAmlAddHdmlElementHandletEvent(parent, menu);
                this.oHandlerManager.postEventNow(hdmlAmlAddHdmlElementHandletEvent);
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (!(ex instanceof HdmlAmlInsufficientMemoryException)) {
                    throw he;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String choiceName = menu.getHdmlAttributeValue("name");
            menuUrl = HASH + choiceName;
        }
        if (menuUrl != null) {
            HdmlAction action = new HdmlAction();
            action.addHdmlAttribute("dest", menuUrl);
            action.addHdmlAttribute("task", "go");
            action.addHdmlAttribute("label", "Menu");
            if (useSoft1) {
                action.addHdmlAttribute("type", "soft1");
            } else {
                this.assignAccept(element, action);
            }
            try {
                HdmlAmlAddHdmlElementHandletEvent hdmlAmlAddHdmlElementHandletEvent = new HdmlAmlAddHdmlElementHandletEvent(element, action, 0);
                this.oHandlerManager.postEventNow(hdmlAmlAddHdmlElementHandletEvent);
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (!(ex instanceof HdmlAmlInsufficientMemoryException)) {
                    throw he;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean hasLinks(HdmlElement element) {
        boolean flag = false;
        try {
            int noOfChilds = element.getNumberElements();
            int i = 0;
            while (i < noOfChilds) {
                HdmlElement child = element.hdmlElementAt(i);
                if (child instanceof HdmlA) {
                    return true;
                }
                flag = this.hasLinks(child);
                if (flag) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
}

