/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.hdml;

import com.aligo.axml.AxmlBr;
import com.aligo.axml.AxmlCheckBox;
import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlContainer;
import com.aligo.axml.AxmlDocument;
import com.aligo.axml.AxmlForm;
import com.aligo.axml.AxmlGroup;
import com.aligo.axml.AxmlImage;
import com.aligo.axml.AxmlInput;
import com.aligo.axml.AxmlLink;
import com.aligo.axml.AxmlList;
import com.aligo.axml.AxmlListItem;
import com.aligo.axml.AxmlOrderedList;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.AxmlTable;
import com.aligo.axml.AxmlTableCol;
import com.aligo.axml.AxmlTableRow;
import com.aligo.axml.AxmlText;
import com.aligo.axml.AxmlTextArea;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.axml.interfaces.AxmlExtensionCollectionInterface;
import com.aligo.axml.interfaces.AxmlExtensionInterface;
import com.aligo.extensions.style.StyleExtension;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.hdml.HdmlAmlPathHandler;
import com.aligo.modules.hdml.events.HdmlAmlGetStyleComponentHandledHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlGetStyleComponentHandlerEvent;
import com.aligo.modules.hdml.events.HdmlAmlSetTopStyleElementStateHandlerEvent;
import com.aligo.modules.hdml.util.HdmlEventDescriptor;
import com.aligo.modules.maps.MapPath;
import com.aligo.modules.maps.MapPathComponent;
import com.aligo.modules.maps.MapSourceComponent;
import com.aligo.modules.maps.interfaces.MapContainerInterface;
import com.aligo.modules.maps.interfaces.MapInterface;
import com.aligo.modules.maps.interfaces.MapPathInterface;
import com.aligo.modules.maps.interfaces.MapSourceComponentInterface;
import com.aligo.modules.paths.exceptions.AmlPathIndexOutOfBoundsException;
import com.aligo.modules.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.StyleComponent;
import com.aligo.modules.styles.XmlStyleID;
import com.aligo.modules.styles.interfaces.StyleComponentInterface;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.parsing.DOMParser;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.profile.interfaces.UAQueryInterface;
import java.util.Enumeration;
import java.util.Vector;

public class HdmlAmlGetStyleComponentHandler
extends HdmlAmlPathHandler {
    private static final String UNKNOWN_STYLE_ID = "UNKNOWN";
    private MapContainerInterface oMapContainer;

    public Vector getEvents() {
        Vector<HdmlEventDescriptor> events = new Vector<HdmlEventDescriptor>();
        HdmlEventDescriptor eventDescriptor = new HdmlEventDescriptor("HdmlAmlGetStyleComponentHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long hdmlAmlPathRelevance() {
        long currentHdmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof HdmlAmlGetStyleComponentHandlerEvent) {
            currentHdmlAmlPathRelevance = 20L;
        }
        return currentHdmlAmlPathRelevance;
    }

    public void setMapContainer(MapContainerInterface mapContainer) {
        this.oMapContainer = mapContainer;
    }

    public MapContainerInterface getMapContainer() {
        return this.oMapContainer;
    }

    private MapPathInterface getMapPath(AxmlElement amlElement, AmlPathInterface amlPath) throws AmlPathIndexOutOfBoundsException {
        AxmlElement currentAmlElement = amlElement;
        int indexComponent = 0;
        int numberComponents = amlPath.getNumberAmlPathComponents();
        MapPath mapPath = new MapPath();
        String name = amlElement.getName();
        MapPathComponent mapPathComponent = new MapPathComponent(name);
        mapPath.addMapPathComponent(mapPathComponent);
        while (indexComponent < numberComponents) {
            AmlPathComponentInterface amlPathComponent = amlPath.getAmlPathComponentAt(indexComponent);
            int pathIndex = amlPathComponent.getPathIndex();
            currentAmlElement = currentAmlElement.axmlElementAt(pathIndex);
            name = currentAmlElement.getName();
            mapPathComponent = new MapPathComponent(name);
            mapPath.addMapPathComponent(mapPathComponent);
            ++indexComponent;
        }
        return mapPath;
    }

    private Vector getStyleExtensions(AxmlExtensionCollectionInterface extensions) {
        Vector<StyleExtension> styleExtensions = new Vector<StyleExtension>();
        if (extensions != null) {
            int numberExtensions = extensions.getNumberExtensions();
            int i = 0;
            while (i < numberExtensions) {
                try {
                    AxmlExtensionInterface extension = extensions.extensionAt(i);
                    if (extension instanceof StyleExtension) {
                        styleExtensions.add((StyleExtension)extension);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    // empty catch block
                }
                ++i;
            }
        }
        return styleExtensions;
    }

    private StyleComponentInterface getStyleFromElement(AxmlElement amlElement, MapSourceComponentInterface mapSourceComponent) {
        StyleComponentInterface styleComponent;
        block11: {
            StyleExtension styleExtension;
            block12: {
                styleComponent = null;
                AxmlExtensionCollectionInterface extensions = amlElement.getExtensions();
                Vector styleExtensions = this.getStyleExtensions(extensions);
                styleExtension = null;
                boolean match = false;
                int i = 0;
                while (i < styleExtensions.size()) {
                    styleExtension = (StyleExtension)styleExtensions.elementAt(i);
                    UAQueryInterface uaQuery = styleExtension.getUAQuery();
                    UAProfile uaProfile = this.getUAProfile();
                    if (uaQuery != null) {
                        if (uaQuery.match(uaProfile)) {
                            match = true;
                            break;
                        }
                    } else {
                        String device = styleExtension.getDevice();
                        if (device != null) {
                            String amlID = uaProfile.getAmlID();
                            if (amlID.equals(device)) {
                                match = true;
                                break;
                            }
                        } else {
                            String xmlID;
                            String protocol = styleExtension.getProtocol();
                            if (protocol != null && (xmlID = uaProfile.getXmlID()).equals(protocol)) {
                                match = true;
                                break;
                            }
                        }
                    }
                    ++i;
                }
                if (!match) break block11;
                String styleId = styleExtension.getStyleId();
                if (styleId == null) break block12;
                boolean foundMap = false;
                Enumeration maps = this.oMapContainer.getMaps();
                while (maps.hasMoreElements() && !foundMap) {
                    XmlStyleID itXmlStyleID;
                    String itId;
                    StyleComponentInterface itStyleComponent;
                    StyleIDInterface itStyleID;
                    MapInterface map = (MapInterface)maps.nextElement();
                    MapSourceComponentInterface itMapSourceComponent = map.getMapSourceComponent();
                    if (!itMapSourceComponent.isEqual(mapSourceComponent) || !((itStyleID = (itStyleComponent = map.getStyleComponentInterface()).getStyleID()) instanceof XmlStyleID) || !(itId = (itXmlStyleID = (XmlStyleID)itStyleID).getName()).equals(styleId)) continue;
                    styleComponent = itStyleComponent;
                    foundMap = true;
                }
                break block11;
            }
            String inlineStyle = styleExtension.getInlineStyle();
            if (inlineStyle == null) break block11;
            String completeStyle = "<Style><StyleID>UNKNOWN</StyleID><Representation>" + inlineStyle + "</Representation></Style>";
            try {
                DOMParser parser = new DOMParser();
                StyleComponent itStyleComponent = new StyleComponent();
                itStyleComponent.fromXml(parser.parse(completeStyle.toCharArray()).getDocumentElement());
                styleComponent = itStyleComponent;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return styleComponent;
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof HdmlAmlGetStyleComponentHandlerEvent) {
            try {
                String style;
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                String name = currentAmlElement.getName();
                MapSourceComponent mapSourceComponent = new MapSourceComponent(name);
                AxmlElement rootAmlElement = AmlPathUtils.getRootAmlElement(this.oHandlerManager);
                MapPathInterface mapPath = this.getMapPath(rootAmlElement, this.oCurrentAmlPath);
                StyleComponentInterface styleComponent = null;
                AxmlElement parentElement = null;
                if (!(currentAmlElement instanceof AxmlDocument) && !(currentAmlElement instanceof AxmlPage)) {
                    AmlPathInterface parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                    parentElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath);
                    if (parentElement instanceof AxmlGroup) {
                        parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, parentPath);
                        parentElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath);
                    } else if (parentElement instanceof AxmlListItem && ((parentElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, parentPath))) instanceof AxmlList || parentElement instanceof AxmlOrderedList)) {
                        parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, parentPath);
                        parentElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath);
                    }
                }
                if (currentAmlElement instanceof AxmlForm && currentAmlElement.getAxmlAttributeValue("view").equals("summary")) {
                    style = "<Container><Display child-container=\"aml:child\"/></Container>";
                    styleComponent = this.getStyleComponentInterface(style);
                } else if (!(parentElement == null || !this.isSummaryFormChild(parentElement) || currentAmlElement instanceof AxmlTable || currentAmlElement instanceof AxmlTableRow || currentAmlElement instanceof AxmlTableCol || currentAmlElement instanceof AxmlGroup || currentAmlElement instanceof AxmlList || currentAmlElement instanceof AxmlOrderedList || currentAmlElement instanceof AxmlListItem || currentAmlElement instanceof AxmlContainer)) {
                    if (currentAmlElement instanceof AxmlInput || currentAmlElement instanceof AxmlTextArea || currentAmlElement instanceof AxmlCheckBox || currentAmlElement instanceof AxmlCheckBox) {
                        String text = "";
                        text = currentAmlElement.getAxmlAttributeValue("type") != null && currentAmlElement.getAxmlAttributeValue("type").equals("password") ? "***" : "$" + currentAmlElement.getAxmlAttributeValue("name");
                        String style2 = "<A task=\"go\" dest=\"#" + currentAmlElement.getAxmlAttributeValue("name") + "\" label=\"input\"><PCData text=\"" + text + "\"/></A>";
                        styleComponent = this.getStyleComponentInterface(style2);
                    } else if (currentAmlElement instanceof AxmlText) {
                        style = "<PCData text=\"" + currentAmlElement.getAxmlAttributeValue("text") + "\" halign=\"aml:handler\" marquee=\"aml:handler\" />";
                        styleComponent = this.getStyleComponentInterface(style);
                    } else if (currentAmlElement instanceof AxmlBr) {
                        style = "<Br/>";
                        styleComponent = this.getStyleComponentInterface(style);
                    } else if (currentAmlElement instanceof AxmlImage) {
                        style = "<Img alt=\".:alt\" src=\"aml:handler\"/>";
                        styleComponent = this.getStyleComponentInterface(style);
                    } else if (currentAmlElement instanceof AxmlLink) {
                        style = "<A dest=\"aml:handler\" child-container=\"aml:child\" />";
                        styleComponent = this.getStyleComponentInterface(style);
                    } else if (currentAmlElement instanceof AxmlChoice) {
                        style = "<Choice name=\".:name\" key=\".:name\" view=\"aml:handler\" default=\"aml:handler\" child-container=\"aml:child\" />";
                        styleComponent = this.getStyleComponentInterface(style);
                    }
                } else {
                    styleComponent = this.getStyleFromElement(currentAmlElement, mapSourceComponent);
                    if (styleComponent == null) {
                        styleComponent = this.oMapContainer.getStyleComponent(mapPath, mapSourceComponent, this.oUAProfile);
                    }
                }
                XmlElementInterface styleXmlElement = styleComponent.getXmlElement();
                HdmlAmlSetTopStyleElementStateHandlerEvent setTopStyleElementStateEvent = new HdmlAmlSetTopStyleElementStateHandlerEvent(this.oCurrentAmlPath, styleXmlElement);
                this.oHandlerManager.postEventNow(setTopStyleElementStateEvent);
                HdmlAmlGetStyleComponentHandledHandlerEvent getStyleComponentHandledHandlerEvent = new HdmlAmlGetStyleComponentHandledHandlerEvent(this.oCurrentAmlPath, styleXmlElement);
                this.oHandlerManager.postEvent(getStyleComponentHandledHandlerEvent);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public StyleComponentInterface getStyleComponentInterface(String style) {
        String completeStyle = "<Style><StyleID>UNKNOWN</StyleID><Representation>" + style + "</Representation></Style>";
        try {
            DOMParser parser = new DOMParser();
            StyleComponent itStyleComponent = new StyleComponent();
            itStyleComponent.fromXml(parser.parse(completeStyle.toCharArray()).getDocumentElement());
            return itStyleComponent;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean isSummaryFormChild(AxmlElement element) {
        boolean flag = false;
        if (element instanceof AxmlDocument || element instanceof AxmlChoice) {
            flag = false;
        } else if (element instanceof AxmlForm) {
            if (element.getAxmlAttributeValue("view").equals("summary")) {
                flag = true;
            }
        } else {
            element = element.getAxmlParentElement();
            flag = this.isSummaryFormChild(element);
        }
        return flag;
    }
}

