/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml.util;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.modules.chtml.events.CHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetCHtmlChildContainerStateHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetRootElementHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetTopCHtmlElementStateHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetTopStyleElementStateHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlSetRootElementHandlerEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddXmlCHtmlAttributeHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddXmlCHtmlElementHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlCreateXmlCHtmlElementHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlRemoveXmlCHtmlAttributeHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlRemoveXmlCHtmlElementHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlResetXmlCHtmlTextHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlSetXmlCHtmlTextHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlXmlCHtmlElementHandletEvent;
import com.aligo.modules.chtml.util.exceptions.CHtmlAmlGetRootElementFailedException;
import com.aligo.modules.chtml.util.exceptions.CHtmlAmlSetRootElementFailedException;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.HandlerManagerInterface;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.exceptions.XmlElementIndexOutOfBoundsException;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import java.util.Hashtable;

public class CHtmlAmlElementUtils {
    public static PageAllocatorInterface getPageAllocator(HandlerManagerInterface handlerManager) {
        PageAllocatorInterface pageAllocator = null;
        try {
            CHtmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = new CHtmlAmlGetPageAllocatorMemoryHandlerEvent();
            handlerManager.postEventNow(getPageAllocatorEvent);
            pageAllocator = getPageAllocatorEvent.getPageAllocator();
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
        return pageAllocator;
    }

    public static AxmlElement getRootAmlElement(HandlerManagerInterface handlerManager) throws CHtmlAmlGetRootElementFailedException {
        try {
            CHtmlAmlGetRootElementHandlerEvent getRootElementHandlerEvent = new CHtmlAmlGetRootElementHandlerEvent();
            handlerManager.postEventNow(getRootElementHandlerEvent);
            return getRootElementHandlerEvent.getAmlElement();
        }
        catch (HandlerError handlerError) {
            throw new CHtmlAmlGetRootElementFailedException(handlerError.toString());
        }
    }

    public static void setRootAmlElement(HandlerManagerInterface handlerManager, AxmlElement rootAmlElement) throws CHtmlAmlSetRootElementFailedException {
        try {
            CHtmlAmlSetRootElementHandlerEvent setRootElementHandlerEvent = new CHtmlAmlSetRootElementHandlerEvent(rootAmlElement);
            handlerManager.postEventNow(setRootElementHandlerEvent);
        }
        catch (HandlerError handlerError) {
            throw new CHtmlAmlSetRootElementFailedException(handlerError.toString());
        }
    }

    public static boolean isSufficientMemory(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        CHtmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = new CHtmlAmlIsSufficientMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isSufficientMemoryEvent);
        return isSufficientMemoryEvent.isSufficient();
    }

    public static CHtmlElement getTopCHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        CHtmlAmlGetTopCHtmlElementStateHandlerEvent getTopCHtmlElementStateEvent = new CHtmlAmlGetTopCHtmlElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopCHtmlElementStateEvent);
        return getTopCHtmlElementStateEvent.getCHtmlElement();
    }

    public static void detachFromTree(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        CHtmlAmlDetachFromTreeMemoryHandlerEvent detachFromTreeEvent = new CHtmlAmlDetachFromTreeMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(detachFromTreeEvent);
    }

    public static boolean isDeckSane(HandlerManagerInterface handlerManager) throws HandlerError {
        CHtmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = new CHtmlAmlIsDeckSaneMemoryHandlerEvent();
        handlerManager.postEventNow(isDeckSaneEvent);
        return isDeckSaneEvent.isSane();
    }

    public static CHtmlElement getChildContainerCHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        CHtmlAmlGetCHtmlChildContainerStateHandlerEvent getCHtmlChildContainerStateEvent = new CHtmlAmlGetCHtmlChildContainerStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getCHtmlChildContainerStateEvent);
        return getCHtmlChildContainerStateEvent.getCHtmlElement();
    }

    public static XmlElementInterface getTopStyleElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        CHtmlAmlGetTopStyleElementStateHandlerEvent getTopStyleElementStateEvent = new CHtmlAmlGetTopStyleElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopStyleElementStateEvent);
        return getTopStyleElementStateEvent.getXmlElement();
    }

    public static XmlElementInterface getFirstMatchingChild(HandlerManagerInterface handlerManager, XmlElementInterface topElement, String name) {
        XmlElementInterface matchedElement = null;
        String itName = topElement.getXmlElementName();
        if (name.equals(itName)) {
            matchedElement = topElement;
        } else {
            int numberElements = topElement.getNumberXmlElements();
            boolean done = false;
            int i = 0;
            while (i < numberElements && !done) {
                try {
                    XmlElementInterface xmlElement = topElement.getXmlElement(i);
                    XmlElementInterface childMatchElement = CHtmlAmlElementUtils.getFirstMatchingChild(handlerManager, xmlElement, name);
                    if (childMatchElement != null) {
                        matchedElement = childMatchElement;
                        done = true;
                    }
                }
                catch (XmlElementIndexOutOfBoundsException xe) {
                    // empty catch block
                }
                ++i;
            }
        }
        return matchedElement;
    }

    public static CHtmlElement getCHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XmlElementInterface xmlElement) throws HandlerError {
        CHtmlAmlXmlCHtmlElementHandletEvent xmlCHtmlElementEvent = new CHtmlAmlXmlCHtmlElementHandletEvent("Get", currentAmlPath, xmlElement);
        handlerManager.postEventNow(xmlCHtmlElementEvent);
        return xmlCHtmlElementEvent.getCHtmlElement();
    }

    public static CHtmlElement createCHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, String name) throws HandlerError {
        CHtmlAmlCreateXmlCHtmlElementHandletEvent createXmlCHtmlEvent = new CHtmlAmlCreateXmlCHtmlElementHandletEvent(currentAmlPath, name);
        handlerManager.postEventNow(createXmlCHtmlEvent);
        return createXmlCHtmlEvent.getCHtmlElement();
    }

    public static void addCHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, CHtmlElement chtmlElement, CHtmlElement childCHtmlElement) throws HandlerError {
        CHtmlAmlElementUtils.addCHtmlElement(handlerManager, currentAmlPath, chtmlElement, childCHtmlElement, -1);
    }

    public static void addCHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, CHtmlElement chtmlElement, CHtmlElement childCHtmlElement, int childIndex) throws HandlerError {
        CHtmlAmlAddXmlCHtmlElementHandletEvent addXmlCHtmlElementEvent = new CHtmlAmlAddXmlCHtmlElementHandletEvent(currentAmlPath, chtmlElement, childCHtmlElement, childIndex);
        handlerManager.postEventNow(addXmlCHtmlElementEvent);
    }

    public static void addCHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, CHtmlElement chtmlElement, String name, String value) throws HandlerError {
        CHtmlAmlAddXmlCHtmlAttributeHandletEvent addXmlCHtmlAttributeEvent = new CHtmlAmlAddXmlCHtmlAttributeHandletEvent(currentAmlPath, chtmlElement, name, value);
        handlerManager.postEventNow(addXmlCHtmlAttributeEvent);
    }

    public static void setCHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, CHtmlElement chtmlElement, String text) throws HandlerError {
        CHtmlAmlSetXmlCHtmlTextHandletEvent setXmlCHtmlTextEvent = new CHtmlAmlSetXmlCHtmlTextHandletEvent(currentAmlPath, chtmlElement, text);
        handlerManager.postEventNow(setXmlCHtmlTextEvent);
    }

    public static void removeCHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, CHtmlElement chtmlElement, CHtmlElement childCHtmlElement) throws HandlerError {
        CHtmlAmlRemoveXmlCHtmlElementHandletEvent removeXmlCHtmlElementEvent = new CHtmlAmlRemoveXmlCHtmlElementHandletEvent(currentAmlPath, chtmlElement, childCHtmlElement);
        handlerManager.postEventNow(removeXmlCHtmlElementEvent);
    }

    public static void removeCHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, CHtmlElement chtmlElement, String name) throws HandlerError {
        CHtmlAmlRemoveXmlCHtmlAttributeHandletEvent removeXmlCHtmlAttributeEvent = new CHtmlAmlRemoveXmlCHtmlAttributeHandletEvent(currentAmlPath, chtmlElement, name);
        handlerManager.postEventNow(removeXmlCHtmlAttributeEvent);
    }

    public static void resetCHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, CHtmlElement chtmlElement) throws HandlerError {
        CHtmlAmlResetXmlCHtmlTextHandletEvent resetXmlCHtmlTextEvent = new CHtmlAmlResetXmlCHtmlTextHandletEvent(currentAmlPath, chtmlElement);
        handlerManager.postEventNow(resetXmlCHtmlTextEvent);
    }

    public static Hashtable getPresentationElements(HandlerManagerInterface handlerManager) throws HandlerError {
        CHtmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = new CHtmlAmlGetPresentationElementsHandlerEvent();
        handlerManager.postEventNow(getPresentationElementsEvent);
        return getPresentationElementsEvent.getCHtmlElements();
    }

    public static boolean isPresentationElement(HandlerManagerInterface handlerManager, CHtmlElement chtmlElement) throws HandlerError {
        boolean present = false;
        Hashtable chtmlElements = CHtmlAmlElementUtils.getPresentationElements(handlerManager);
        if (chtmlElements.get(chtmlElement) != null) {
            present = true;
        }
        return present;
    }

    public static void addPresentationElement(HandlerManagerInterface handlerManager, CHtmlElement chtmlElement) throws HandlerError {
        Hashtable chtmlElements = CHtmlAmlElementUtils.getPresentationElements(handlerManager);
        CHtmlAmlElementUtils.addPresentationElement(chtmlElements, chtmlElement);
    }

    public static void removePresentationElement(HandlerManagerInterface handlerManager, CHtmlElement chtmlElement) throws HandlerError {
        Hashtable chtmlElements = CHtmlAmlElementUtils.getPresentationElements(handlerManager);
        CHtmlAmlElementUtils.removePresentationElement(chtmlElements, chtmlElement);
    }

    public static void addPresentationElement(Hashtable chtmlElements, CHtmlElement chtmlElement) {
        chtmlElements.put(chtmlElement, chtmlElement);
    }

    public static void removePresentationElement(Hashtable chtmlElements, CHtmlElement chtmlElement) {
        chtmlElements.remove(chtmlElement);
    }

    public static boolean isPersistent(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        CHtmlAmlIsPersistentHandlerEvent isPersistentEvent = new CHtmlAmlIsPersistentHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isPersistentEvent);
        return isPersistentEvent.isPersistent();
    }
}

