/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml.amlhandlets;

import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.CHtmlPCData;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.chtml.errors.CHtmlAmlHandlerError;
import com.aligo.modules.chtml.events.CHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlGetRemainingMemoryHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.chtml.events.CHtmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.chtml.exceptions.CHtmlAmlInsufficientMemoryException;
import com.aligo.modules.chtml.handlets.CHtmlAmlStylePathHandlet;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddXmlCHtmlAttributeHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlXmlCHtmlElementHandletEvent;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.util.chtml.TextUtils;
import java.util.Hashtable;
import java.util.Vector;

public class CHtmlAmlTextAttributeHandlet
extends CHtmlAmlStylePathHandlet {
    public static final String ENCODE = "encode";
    public static final String ENCODE_FALSE = "false";
    private Hashtable oTextIndices = new Hashtable();
    private Hashtable oOutputContainers = new Hashtable();
    private Hashtable oDetachFlags = new Hashtable();

    public Vector getEvents() {
        Vector<CHtmlEventDescriptor> events = new Vector<CHtmlEventDescriptor>();
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlShouldDetachTextMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlResetTextStateHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlStylePathRelevance() {
        long currentCHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            CHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (CHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            try {
                AmlPathInterface currentAmlPath = addAttributeEvent.getAmlPath();
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentAmlPath);
                XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
                CHtmlElement chtmlElement = CHtmlAmlElementUtils.getCHtmlElement(this.oHandlerManager, currentAmlPath, styleXmlElement);
                String chtmlName = addAttributeEvent.getCHtmlName();
                if (currentAmlElement instanceof AxmlText && chtmlElement instanceof CHtmlPCData && chtmlName.equals("text")) {
                    currentCHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentCHtmlAmlStylePathRelevance;
    }

    public long chtmlAmlRelevance() {
        long currentCHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            if (this.doesTextPathExist(this.oCurrentAmlPath) && !this.shouldDetach(this.oCurrentAmlPath)) {
                currentCHtmlAmlRelevance = 30L;
            }
        } else {
            currentCHtmlAmlRelevance = this.oCurrentEvent instanceof CHtmlAmlShouldDetachTextMemoryHandlerEvent ? 30L : (this.oCurrentEvent instanceof CHtmlAmlResetTextStateHandlerEvent ? 20L : super.chtmlAmlRelevance());
        }
        return currentCHtmlAmlRelevance;
    }

    private boolean doesTextPathExist(AmlPathInterface amlPath) {
        boolean textPathExist = false;
        Integer iLastIndex = (Integer)this.oTextIndices.get(amlPath.getCanonicalPath());
        if (iLastIndex != null) {
            textPathExist = true;
        }
        return textPathExist;
    }

    private boolean shouldDetach(AmlPathInterface amlPath) {
        boolean detach = true;
        Boolean bDetach = (Boolean)this.oDetachFlags.get(amlPath.getCanonicalPath());
        if (bDetach != null) {
            detach = bDetach;
        }
        return detach;
    }

    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof CHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            CHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (CHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            boolean memoryError = false;
            try {
                CHtmlAmlXmlCHtmlElementHandletEvent getCHtmlElementEvent = new CHtmlAmlXmlCHtmlElementHandletEvent("Get", this.oCurrentAmlPath, this.oStyleXmlElement);
                this.oHandlerManager.postEventNow(getCHtmlElementEvent);
                CHtmlElement chtmlElement = getCHtmlElementEvent.getCHtmlElement();
                String chtmlName = addAttributeEvent.getCHtmlName();
                String chtmlValue = addAttributeEvent.getCHtmlValue();
                if (chtmlValue != null) {
                    String value = "";
                    AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                    if (currentAmlElement instanceof AxmlText && chtmlElement instanceof CHtmlPCData && chtmlName.equals("text")) {
                        int lastIndex;
                        Integer iLastIndex;
                        String pathString = this.oCurrentAmlPath.getCanonicalPath();
                        Vector strContainer = (Vector)this.oOutputContainers.get(pathString);
                        if (strContainer == null) {
                            strContainer = new Vector();
                            String encodeValue = currentAmlElement.getAxmlAttributeValue(ENCODE);
                            boolean encode = true;
                            if (encodeValue != null && encodeValue.equals(ENCODE_FALSE)) {
                                encode = false;
                            }
                            TextUtils.prepareOutput(chtmlValue, this.oUAProfile.getScreenWidthChar(), strContainer, encode);
                            this.oOutputContainers.put(pathString, strContainer);
                        }
                        if ((iLastIndex = (Integer)this.oTextIndices.get(pathString)) == null) {
                            lastIndex = 0;
                            iLastIndex = new Integer(lastIndex);
                            this.oTextIndices.put(pathString, iLastIndex);
                        } else {
                            lastIndex = iLastIndex;
                        }
                        CHtmlAmlGetRemainingMemoryHandlerEvent getRemainingMemoryEvent = new CHtmlAmlGetRemainingMemoryHandlerEvent(this.oCurrentAmlPath);
                        this.oHandlerManager.postEventNow(getRemainingMemoryEvent);
                        long remainingMemory = getRemainingMemoryEvent.getNumberBytes();
                        int numberElements = strContainer.size();
                        long memory = 0L;
                        boolean done = false;
                        boolean detach = false;
                        int i = lastIndex;
                        while (i < numberElements && !done) {
                            String element = (String)strContainer.elementAt(i);
                            long elementMemory = element.getBytes().length;
                            if ((memory += elementMemory) > remainingMemory) {
                                done = true;
                                if (i == lastIndex) {
                                    detach = true;
                                }
                                lastIndex = i;
                            } else {
                                value = value + element;
                            }
                            ++i;
                        }
                        this.oDetachFlags.put(pathString, new Boolean(detach));
                        if (done) {
                            this.oTextIndices.put(pathString, new Integer(lastIndex));
                            memoryError = true;
                        } else {
                            this.clearState(this.oCurrentAmlPath);
                        }
                        CHtmlAmlAddXmlCHtmlAttributeHandletEvent addXmlCHtmlAttributeEvent = new CHtmlAmlAddXmlCHtmlAttributeHandletEvent(this.oCurrentAmlPath, chtmlElement, chtmlName, value);
                        this.oHandlerManager.postEventNow(addXmlCHtmlAttributeEvent);
                    }
                }
                if (memoryError) {
                    throw new HandlerError(new CHtmlAmlInsufficientMemoryException());
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void handleException(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            HandlerError he = (HandlerError)ex;
            Exception eex = he.getException();
            if (eex instanceof CHtmlAmlInsufficientMemoryException) {
                throw he;
            }
        } else {
            this.oHandlerLogger.logError(ex);
        }
    }

    public void clearState(AmlPathInterface amlPath) {
        String pathString = amlPath.getCanonicalPath();
        this.oTextIndices.remove(pathString);
        this.oOutputContainers.remove(pathString);
        this.oDetachFlags.remove(pathString);
    }

    public void handleEventNow() throws HandlerError {
        if (!(this.oCurrentEvent instanceof CHtmlAmlDetachFromTreeMemoryHandlerEvent)) {
            if (this.oCurrentEvent instanceof CHtmlAmlShouldDetachTextMemoryHandlerEvent) {
                CHtmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = (CHtmlAmlShouldDetachTextMemoryHandlerEvent)this.oCurrentEvent;
                AmlPathInterface currentAmlPath = shouldDetachTextMemoryEvent.getAmlPath();
                boolean detach = true;
                if (currentAmlPath != null) {
                    detach = this.shouldDetach(currentAmlPath);
                }
                shouldDetachTextMemoryEvent.setDetach(detach);
            } else if (this.oCurrentEvent instanceof CHtmlAmlResetTextStateHandlerEvent) {
                try {
                    AmlPathInterface currentAmlPath = ((CHtmlAmlResetTextStateHandlerEvent)this.oCurrentEvent).getAmlPath();
                    this.clearState(currentAmlPath);
                }
                catch (Exception ex) {
                    throw new CHtmlAmlHandlerError(ex);
                }
            } else {
                super.handleEventNow();
            }
        }
    }
}

