/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.chtml.amlhandlets;

import com.aligo.axml.AxmlForm;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.chtml.CHtmlOl;
import com.aligo.chtml.interfaces.CHtmlElement;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.chtml.events.CHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.chtml.exceptions.CHtmlAmlInsufficientMemoryException;
import com.aligo.modules.chtml.handlets.CHtmlAmlStylePathHandlet;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddAttributeHandledHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlAddAttributeHandletEvent;
import com.aligo.modules.chtml.handlets.events.CHtmlAmlXmlCHtmlElementHandletEvent;
import com.aligo.modules.chtml.util.CHtmlAmlElementUtils;
import com.aligo.modules.chtml.util.CHtmlEventDescriptor;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import java.util.Vector;

public class CHtmlAmlOrderedListHandlet
extends CHtmlAmlStylePathHandlet {
    protected XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    XmlAttributeInterface xmlAttribute;
    CHtmlElement chtmlElement;
    private static final String TYPE = "type";
    private static final String NUMERIC = "numeric";
    private static final String UPPERCASE_ROMAN = "uppercase_roman";
    private static final String LOWERCASE_ROMAN = "lowercase_roman";
    private static final String UPPERCASE_ALPHA = "uppercase_alpha";
    private static final String LOWERCASE_ALPHA = "lowercase_alpha";
    private static final String NUMERIC_VALUE = "1";
    private static final String UPPERCASE_ROMAN_VALUE = "I";
    private static final String LOWERCASE_ROMAN_VALUE = "i";
    private static final String UPPERCASE_ALPHA_VALUE = "A";
    private static final String LOWERCASE_ALPHA_VALUE = "a";

    public Vector getEvents() {
        Vector<CHtmlEventDescriptor> events = new Vector<CHtmlEventDescriptor>();
        CHtmlEventDescriptor eventDescriptor = new CHtmlEventDescriptor("CHtmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long chtmlAmlStylePathRelevance() {
        long currentCHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof CHtmlAmlAddAttributeHandletEvent) {
            CHtmlAmlAddAttributeHandletEvent addAttributeEvent = (CHtmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            this.xmlAttribute = addAttributeEvent.getXmlAttribute();
            try {
                AligoEventInterface event = this.oCurrentEvent;
                CHtmlAmlXmlCHtmlElementHandletEvent getCHtmlElementEvent = new CHtmlAmlXmlCHtmlElementHandletEvent("Get", addAttributeEvent.getAmlPath(), addAttributeEvent.getXmlElement());
                this.oHandlerManager.postEventNow(getCHtmlElementEvent);
                this.oCurrentEvent = event;
                this.chtmlElement = getCHtmlElementEvent.getCHtmlElement();
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.chtmlElement instanceof CHtmlOl) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    if (this.oXmlAmlHandlerAttribute.getAmlAttributeName().toLowerCase().equals(TYPE)) {
                        currentCHtmlAmlStylePathRelevance = 20L;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        }
        return currentCHtmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof CHtmlAmlAddAttributeHandletEvent) {
            boolean memoryError = false;
            try {
                if (this.xmlAttribute instanceof XmlAmlHandlerAttributeInterface && this.chtmlElement instanceof CHtmlOl) {
                    this.oXmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)this.xmlAttribute;
                    String amlAttributeName = this.oXmlAmlHandlerAttribute.getAmlAttributeName();
                    CHtmlElement chtmlParentElement = this.chtmlElement.getCHtmlParentElement();
                    int position = -1;
                    if (amlAttributeName.toLowerCase().equals(TYPE)) {
                        AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                        String amlAttributeValue = axmlElement.getAxmlAttributeValue(amlAttributeName);
                        if (amlAttributeValue.toLowerCase().indexOf(NUMERIC) != -1) {
                            CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.chtmlElement, amlAttributeName, NUMERIC_VALUE);
                        }
                        if (amlAttributeValue.toLowerCase().indexOf(UPPERCASE_ROMAN) != -1) {
                            CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.chtmlElement, amlAttributeName, UPPERCASE_ROMAN_VALUE);
                        }
                        if (amlAttributeValue.toLowerCase().indexOf(LOWERCASE_ROMAN) != -1) {
                            CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.chtmlElement, amlAttributeName, LOWERCASE_ROMAN_VALUE);
                        }
                        if (amlAttributeValue.toLowerCase().indexOf(UPPERCASE_ALPHA) != -1) {
                            CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.chtmlElement, amlAttributeName, UPPERCASE_ALPHA_VALUE);
                        }
                        if (amlAttributeValue.toLowerCase().indexOf(LOWERCASE_ALPHA) != -1) {
                            CHtmlAmlElementUtils.addCHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, this.chtmlElement, amlAttributeName, LOWERCASE_ALPHA_VALUE);
                        }
                    }
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof CHtmlAmlInsufficientMemoryException) {
                    AxmlElement amlElement;
                    memoryError = true;
                    AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                    if (parentAmlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath)) instanceof AxmlForm) {
                        memoryError = false;
                    }
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                try {
                    CHtmlAmlElementUtils.removeCHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.chtmlElement.getCHtmlParentElement(), this.chtmlElement);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                CHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new CHtmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else {
                CHtmlAmlAddAttributeHandledHandletEvent chtmlAmlAddAttributeHandledHandletEvent = new CHtmlAmlAddAttributeHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
                this.oHandlerManager.postEvent(chtmlAmlAddAttributeHandledHandletEvent);
            }
        }
    }
}

