/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.aml.utils;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.interfaces.HandlerManagerInterface;
import com.aligo.modules.paths.AmlPath;
import com.aligo.modules.paths.AmlPathComponent;
import com.aligo.modules.paths.exceptions.AmlPathIndexOutOfBoundsException;
import com.aligo.modules.paths.interfaces.AmlPathComponentInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import java.util.HashMap;

public class AmlPathUtils {
    public static final String ROOT_ELEMENT = "ROOT_ELEMENT";
    public static final String ELEMENT_KEY = "ELEMENT_KEY";
    public static final String PARENT_PATH_KEY = "PARENT_PATH_KEY";
    public static final String CHILD_PATH_KEY = "CHILD_PATH_KEY";

    public static void setRootAmlElement(HandlerManagerInterface handlerManager, AxmlElement rootAmlElement) {
        handlerManager.storeState(ROOT_ELEMENT, rootAmlElement);
    }

    public static AxmlElement getRootAmlElement(HandlerManagerInterface handlerManager) {
        return (AxmlElement)handlerManager.retrieveState(ROOT_ELEMENT);
    }

    public static AxmlElement getAmlElement(HandlerManagerInterface handlerManager, AmlPathInterface amlPath) {
        return AmlPathUtils.getAmlElement(handlerManager, amlPath, 0);
    }

    public static AxmlElement getAmlElement(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, int numberDiscard) {
        return AmlPathUtils.getAmlElement(handlerManager, amlPath, AmlPathUtils.getRootAmlElement(handlerManager), numberDiscard);
    }

    public static AxmlElement getAmlElement(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, AxmlElement sourceAmlElement, int numberDiscard) {
        AxmlElement requestedAmlElement = null;
        if (numberDiscard == 0) {
            requestedAmlElement = amlPath.getAmlElement();
        }
        if (requestedAmlElement == null) {
            int numberComponents = amlPath.getNumberAmlPathComponents();
            int considerComponents = numberComponents - numberDiscard;
            try {
                if (considerComponents >= 0) {
                    requestedAmlElement = sourceAmlElement;
                }
                int i = 0;
                while (i < considerComponents) {
                    AmlPathComponentInterface component = amlPath.getAmlPathComponentAt(i);
                    int pathIndex = component.getPathIndex();
                    requestedAmlElement = requestedAmlElement.axmlElementAt(pathIndex);
                    ++i;
                }
                amlPath.setAmlElement(requestedAmlElement);
            }
            catch (AmlPathIndexOutOfBoundsException ae) {
                // empty catch block
            }
        }
        return requestedAmlElement;
    }

    public static AmlPathInterface getParentPath(HandlerManagerInterface handlerManager, AmlPathInterface amlPath) {
        return AmlPathUtils.getParentPath(handlerManager, amlPath, 1);
    }

    private static AmlPathInterface getCacheParentPath(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, int parentDepth) {
        HashMap parentPaths;
        AmlPathInterface parentPath = null;
        if (parentDepth == 1 && (parentPaths = (HashMap)handlerManager.retrieveState(PARENT_PATH_KEY)) != null) {
            parentPath = (AmlPathInterface)parentPaths.get(amlPath);
        }
        return parentPath;
    }

    private static void setCacheParentPath(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, int parentDepth, AmlPathInterface parentPath) {
        if (parentDepth == 1) {
            HashMap<AmlPathInterface, AmlPathInterface> parentPaths = (HashMap<AmlPathInterface, AmlPathInterface>)handlerManager.retrieveState(PARENT_PATH_KEY);
            if (parentPaths == null) {
                parentPaths = new HashMap<AmlPathInterface, AmlPathInterface>();
                handlerManager.storeState(PARENT_PATH_KEY, parentPaths);
            }
            parentPaths.put(amlPath, parentPath);
        }
    }

    public static AmlPathInterface getParentPath(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, int parentDepth) {
        AmlPathInterface parentPath = null;
        parentPath = AmlPathUtils.getCacheParentPath(handlerManager, amlPath, parentDepth);
        if (parentPath == null) {
            int numberComponents = amlPath.getNumberAmlPathComponents();
            int considerComponents = numberComponents - parentDepth;
            try {
                if (considerComponents >= 0) {
                    parentPath = new AmlPath();
                }
                int i = 0;
                while (i < considerComponents) {
                    AmlPathComponentInterface component = amlPath.getAmlPathComponentAt(i);
                    parentPath.addAmlPathComponent(component);
                    ++i;
                }
                if (considerComponents >= 0) {
                    int realm = amlPath.getRealm();
                    parentPath.setRealm(realm);
                }
            }
            catch (AmlPathIndexOutOfBoundsException ae) {
                // empty catch block
            }
            if (parentPath != null) {
                AmlPathUtils.setCacheParentPath(handlerManager, amlPath, parentDepth, parentPath);
            }
        }
        return parentPath;
    }

    public static AmlPathInterface getChildPath(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, int childIndex) {
        AmlPathInterface childPath = AmlPathUtils.getParentPath(handlerManager, amlPath, 0);
        AmlPathComponent childComponent = new AmlPathComponent(childIndex);
        childPath.addAmlPathComponent(childComponent);
        return childPath;
    }

    public static int getChildIndex(HandlerManagerInterface handlerManager, AmlPathInterface amlPath) {
        int childIndex = -1;
        int numberComponents = amlPath.getNumberAmlPathComponents();
        if (numberComponents > 0) {
            try {
                int childPosition = numberComponents - 1;
                AmlPathComponentInterface amlPathComponent = amlPath.getAmlPathComponentAt(childPosition);
                childIndex = amlPathComponent.getPathIndex();
            }
            catch (AmlPathIndexOutOfBoundsException ae) {
                // empty catch block
            }
        }
        return childIndex;
    }

    public static int getNumberAmlElements(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, String amlClassName) {
        int numberAmlElements = 0;
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(handlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            int i = 0;
            while (i < numberChildren) {
                AxmlElement childAmlElement = amlElement.axmlElementAt(i);
                String childAmlClassName = childAmlElement.getClass().getName();
                if (childAmlClassName.equals(amlClassName)) {
                    ++numberAmlElements;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            // empty catch block
        }
        return numberAmlElements;
    }

    public static int getLastAmlElementPosition(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, String amlClassName) {
        boolean numberAmlElements = false;
        int position = -1;
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(handlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            boolean found = false;
            while (!found && numberChildren > 0) {
                AxmlElement lookingAxmlElement = AmlPathUtils.getAxmlElement(handlerManager, amlPath, amlClassName, numberChildren - 1);
                if (lookingAxmlElement != null) {
                    found = true;
                    position = numberChildren - 1;
                }
                --numberChildren;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            // empty catch block
        }
        return position;
    }

    public static AxmlElement getAxmlElement(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, String amlClassName) throws ArrayIndexOutOfBoundsException {
        return AmlPathUtils.getAxmlElement(handlerManager, amlPath, amlClassName, 0);
    }

    public static AxmlElement getAxmlElement(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, String amlClassName, int index) throws ArrayIndexOutOfBoundsException {
        AxmlElement childAmlElement = null;
        AxmlElement amlElement = AmlPathUtils.getAmlElement(handlerManager, amlPath);
        int numberChildren = amlElement.getNumberElements();
        if (index < 0 || index >= numberChildren) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        boolean done = false;
        int itIndex = -1;
        try {
            int i = 0;
            while (i < numberChildren && !done) {
                AxmlElement itChildAmlElement = amlElement.axmlElementAt(i);
                String childAmlClassName = itChildAmlElement.getClass().getName();
                if (childAmlClassName.equals(amlClassName)) {
                    ++itIndex;
                }
                if (index == itIndex) {
                    childAmlElement = itChildAmlElement;
                    done = true;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            // empty catch block
        }
        return childAmlElement;
    }

    public static AmlPathInterface getRootPath(HandlerManagerInterface handlerManager, AmlPathInterface amlPath) {
        AmlPathInterface rootPath = null;
        int numberComponents = amlPath.getNumberAmlPathComponents();
        rootPath = numberComponents == 0 ? amlPath : AmlPathUtils.getRootPath(handlerManager, AmlPathUtils.getParentPath(handlerManager, amlPath));
        return rootPath;
    }

    public static AmlPathInterface getAncestorPath(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, String ancestorClassName) {
        AmlPathInterface ancestorPath = null;
        try {
            if (amlPath != null) {
                AxmlElement element = AmlPathUtils.getAmlElement(handlerManager, amlPath);
                String elementClassName = element.getClass().getName();
                if (!ancestorClassName.equals(elementClassName)) {
                    AmlPathInterface parentPath = AmlPathUtils.getParentPath(handlerManager, amlPath);
                    ancestorPath = AmlPathUtils.getAncestorPath(handlerManager, parentPath, ancestorClassName);
                } else {
                    ancestorPath = amlPath;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return ancestorPath;
    }

    public static AmlPathInterface getNextRealmPath(HandlerManagerInterface handlerManager, AmlPathInterface amlPath) {
        AmlPathInterface nextRealmPath = AmlPathUtils.getParentPath(handlerManager, amlPath, 0);
        int realmIndex = amlPath.getRealm();
        int nextRealmIndex = realmIndex + 1;
        nextRealmPath.setRealm(nextRealmIndex);
        return nextRealmPath;
    }

    public static boolean isTerminalElement(HandlerManagerInterface handlerManager, AmlPathInterface amlPath) {
        boolean terminalElement = false;
        try {
            if (amlPath != null) {
                AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(handlerManager, amlPath);
                if (parentAmlPath != null) {
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(handlerManager, parentAmlPath);
                    int numberChildren = amlElement.getNumberElements();
                    int childIndex = AmlPathUtils.getChildIndex(handlerManager, amlPath);
                    if (childIndex == numberChildren - 1) {
                        terminalElement = true;
                    }
                } else {
                    terminalElement = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return terminalElement;
    }

    public static boolean isLastRenderElement(HandlerManagerInterface handlerManager, AmlPathInterface amlPath) {
        boolean lastRenderElement = false;
        if (amlPath != null) {
            AmlPathInterface currentAmlPath = amlPath;
            boolean terminalFail = false;
            while (currentAmlPath != null && !terminalFail) {
                boolean terminalElement = AmlPathUtils.isTerminalElement(handlerManager, currentAmlPath);
                if (!terminalElement) {
                    terminalFail = true;
                    continue;
                }
                currentAmlPath = AmlPathUtils.getParentPath(handlerManager, currentAmlPath);
            }
            if (!terminalFail) {
                lastRenderElement = true;
            }
        }
        return lastRenderElement;
    }

    public static AmlPathInterface getFirstDescendentPath(HandlerManagerInterface handlerManager, AmlPathInterface amlPath, String descendentClassName) {
        AmlPathInterface descendentPath = null;
        AxmlElement axmlElement = AmlPathUtils.getAmlElement(handlerManager, amlPath);
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(handlerManager, amlPath);
            int numberChildren = amlElement.getNumberElements();
            int i = 0;
            while (i < numberChildren) {
                AxmlElement childAmlElement = amlElement.axmlElementAt(i);
                AmlPathInterface childPath = AmlPathUtils.getChildPath(handlerManager, amlPath, i);
                String childAmlClassName = childAmlElement.getClass().getName();
                if (childAmlClassName.equals(descendentClassName)) {
                    descendentPath = childPath;
                    break;
                }
                descendentPath = AmlPathUtils.getFirstDescendentPath(handlerManager, childPath, descendentClassName);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            // empty catch block
        }
        return descendentPath;
    }
}

