/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules;

import com.aligo.engine.logging.interfaces.LoggerInterface;
import com.aligo.interfaces.AligoEventInterface;
import com.aligo.modules.Context;
import com.aligo.modules.ContextHandlers;
import com.aligo.modules.ContextStack;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.events.EndEvent;
import com.aligo.modules.events.ErrorEvent;
import com.aligo.modules.exceptions.EmptyContextStackException;
import com.aligo.modules.exceptions.NoHandlerException;
import com.aligo.modules.interfaces.ContextHandlersInterface;
import com.aligo.modules.interfaces.ContextInterface;
import com.aligo.modules.interfaces.ContextStackInterface;
import com.aligo.modules.interfaces.EndEventInterface;
import com.aligo.modules.interfaces.EventHookPosition;
import com.aligo.modules.interfaces.HandlerInterface;
import com.aligo.modules.interfaces.HandlerLoggerInterface;
import com.aligo.modules.interfaces.HandlerManagerInterface;
import com.aligo.modules.interfaces.StartEventInterface;
import com.aligo.modules.logging.HandlerLogger;
import java.util.ArrayList;
import java.util.HashMap;

public class HandlerManager
implements HandlerManagerInterface {
    private static final String GLOBAL_CONTEXT = "GLOBAL";
    private static final int EVENT = 0;
    private static final int EVENT_NOW = 1;
    AligoEventInterface oEvent = null;
    boolean bEnd = true;
    int iDebug = 0;
    ContextStackInterface oContextStack = new ContextStack();
    ContextInterface oRootContext;
    int iNextDebug;
    HandlerLoggerInterface oHandlerLogger;
    ContextHandlersInterface oContextHandlers;
    HashMap oState;

    public HandlerManager() {
        this.createRootContext();
        this.iNextDebug = 0;
        this.oHandlerLogger = new HandlerLogger();
        this.oContextHandlers = null;
        this.oState = new HashMap();
    }

    private void createRootContext() {
        this.oContextStack.clear();
        this.oRootContext = new Context(GLOBAL_CONTEXT);
        ContextHandlers rootContextHandlers = new ContextHandlers();
        this.oRootContext.setHandlers(rootContextHandlers);
        this.loadContext(this.oRootContext);
    }

    private void generate() {
        while (!this.bEnd) {
            int saveDebug = this.iDebug;
            this.iDebug = this.iNextDebug;
            AligoEventInterface event = this.oEvent;
            try {
                this.oEvent = null;
                this.handleEvent(event, 0);
                this.iDebug = saveDebug;
            }
            catch (HandlerError he) {
                this.iDebug = saveDebug;
                this.errorHandler(event, he);
            }
        }
    }

    public void postEvent(AligoEventInterface event, int debug) {
        this.iNextDebug = debug;
        this.oEvent = event;
        if (this.oEvent instanceof StartEventInterface) {
            this.bEnd = false;
            this.generate();
        } else if (this.oEvent instanceof EndEventInterface) {
            this.bEnd = true;
        }
    }

    public void postEvent(AligoEventInterface event) {
        this.postEvent(event, this.iDebug);
    }

    public void postEventNow(AligoEventInterface event, int debug) throws HandlerError {
        HandlerError handlerError = null;
        int saveDebug = this.iDebug;
        this.iDebug = debug;
        try {
            this.handleEvent(event, 1);
        }
        catch (HandlerError he) {
            handlerError = he;
        }
        this.iDebug = saveDebug;
        if (handlerError != null) {
            throw handlerError;
        }
    }

    public void postEventNow(AligoEventInterface event) throws HandlerError {
        this.postEventNow(event, this.iDebug);
    }

    private HandlerInterface getSelectedHandler(AligoEventInterface event) {
        ArrayList handlers = this.getHandlers(event);
        HandlerInterface selectedHandler = null;
        long relevance = 0L;
        int size = handlers.size();
        int i = 0;
        while (i < size) {
            long handlerRelevance;
            HandlerInterface handler;
            block5: {
                handler = (HandlerInterface)handlers.get(i);
                handlerRelevance = 0L;
                try {
                    handler.setEvent(event);
                    handlerRelevance = handler.relevance();
                }
                catch (Exception ex) {
                    if (this.iDebug <= 0) break block5;
                    ex.printStackTrace();
                }
            }
            if (this.iDebug > 1) {
                System.out.println("handler = " + handler.toString() + " relevance = " + relevance + " handlerRelevance " + handlerRelevance);
            }
            if (handlerRelevance != 0L && handlerRelevance > relevance) {
                selectedHandler = handler;
                relevance = handlerRelevance;
            }
            ++i;
        }
        return selectedHandler;
    }

    private void errorHandler(AligoEventInterface event, HandlerError handlerError) {
        this.oHandlerLogger.logError("Handler Error... " + event);
        this.oHandlerLogger.logError(handlerError);
        if (event != null) {
            if (!(event instanceof ErrorEvent)) {
                this.postErrorEvent(handlerError);
            } else {
                this.postEndEvent();
            }
        } else {
            this.oHandlerLogger.logDebug("No event");
            this.postEndEvent();
        }
    }

    private void handleEvent(AligoEventInterface event, int type) throws HandlerError {
        block6: {
            this.beforeHandlers(event);
            try {
                HandlerInterface selectedHandler = null;
                selectedHandler = this.getSelectedHandler(event);
                if (selectedHandler != null) {
                    selectedHandler.setEvent(event);
                    if (type == 0) {
                        selectedHandler.handleEvent();
                        break block6;
                    }
                    if (type == 1) {
                        selectedHandler.handleEventNow();
                        break block6;
                    }
                    this.oHandlerLogger.logError("Unknown event...");
                    throw new NoHandlerException();
                }
                this.oHandlerLogger.logError("No Handler...");
                throw new NoHandlerException();
            }
            catch (HandlerError he) {
                throw he;
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
                throw new HandlerError(ex);
            }
        }
        this.afterHandlers(event);
    }

    public void postErrorEvent(HandlerError handlerError) {
        ErrorEvent errorEvent = new ErrorEvent(handlerError);
        this.postEvent(errorEvent);
    }

    public void postEndEvent() {
        EndEvent endEvent = new EndEvent();
        this.postEvent(endEvent);
    }

    private ContextHandlersInterface getCurrentContextHandlers() {
        ContextInterface context;
        if (this.oContextHandlers == null && (context = this.getCurrentContext()) != null) {
            this.oContextHandlers = context.getHandlers();
        }
        return this.oContextHandlers;
    }

    public void addHandler(HandlerInterface handler) {
        ContextHandlersInterface contextHandlers = this.getCurrentContextHandlers();
        if (contextHandlers == null) {
            this.createRootContext();
            contextHandlers = this.getCurrentContextHandlers();
        }
        contextHandlers.addHandler(handler);
        handler.setHandlerLogger(this.oHandlerLogger);
    }

    public void loadContext(ContextInterface context) {
        this.oContextStack.push(context);
        this.oContextHandlers = null;
    }

    public ContextInterface unloadContext() throws EmptyContextStackException {
        ContextInterface context = this.oContextStack.pop();
        this.oContextHandlers = null;
        return context;
    }

    public ContextInterface getCurrentContext() {
        return this.oContextStack.peek();
    }

    public ContextStackInterface getContextStack() {
        return this.oContextStack;
    }

    public ArrayList getHandlers(AligoEventInterface event) {
        ContextHandlersInterface contextHandlers = this.getCurrentContextHandlers();
        ArrayList currentHandlers = null;
        if (contextHandlers != null) {
            currentHandlers = contextHandlers.getHandlers(event);
        }
        if (currentHandlers == null) {
            currentHandlers = new ArrayList();
        }
        return currentHandlers;
    }

    public void setDebug(int debug) {
        this.iDebug = debug;
    }

    public int getDebug() {
        return this.iDebug;
    }

    private ArrayList getHandlers(AligoEventInterface event, EventHookPosition position) {
        ContextHandlersInterface contextHandlers = this.getCurrentContextHandlers();
        return contextHandlers.getHandlers(event, position);
    }

    private void beforeHandlers(AligoEventInterface event) throws HandlerError {
        ArrayList hooks = this.getHandlers(event, EventHookPosition.POSITION_BEFORE);
        this.handleHandlers(event, hooks);
    }

    private void afterHandlers(AligoEventInterface event) throws HandlerError {
        ArrayList hooks = this.getHandlers(event, EventHookPosition.POSITION_AFTER);
        this.handleHandlers(event, hooks);
    }

    private void handleHandlers(AligoEventInterface event, ArrayList hooks) throws HandlerError {
        if (hooks != null) {
            int size = hooks.size();
            int i = 0;
            while (i < size) {
                HandlerInterface handler = (HandlerInterface)hooks.get(i);
                handler.setEvent(event);
                if (handler.relevance() != 0L) {
                    handler.setEvent(event);
                    handler.handleEventNow();
                }
                ++i;
            }
        }
    }

    public void setLogger(LoggerInterface logger) {
        this.oHandlerLogger.setLogger(logger);
    }

    public LoggerInterface getLogger() {
        return this.oHandlerLogger.getLogger();
    }

    public void storeState(String key, Object value) {
        this.oState.put(key, value);
    }

    public Object retrieveState(String key) {
        return this.oState.get(key);
    }
}

