/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.jhtml;

import com.aligo.jhtml.exceptions.JHtmlAttributeCannotBeAddedException;
import com.aligo.jhtml.exceptions.JHtmlElementCannotBeAddedException;
import com.aligo.jhtml.exceptions.JHtmlElementCloneFailedException;
import com.aligo.jhtml.exceptions.JHtmlElementIndexOutOfBoundsException;
import com.aligo.jhtml.exceptions.JHtmlElementNotFoundException;
import com.aligo.jhtml.exceptions.JHtmlTextCannotBeResetException;
import com.aligo.jhtml.exceptions.JHtmlTextCannotBeSetException;
import com.aligo.jhtml.exceptions.JHtmlTextNotSetException;
import com.aligo.jhtml.interfaces.JHtmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class JHtmlElementCollection
implements JHtmlElement {
    Vector elements = new Vector();

    public String getName() {
        return "JHtmlElementCollection";
    }

    public String getXmlID() {
        return "";
    }

    public void addJHtmlElementAt(JHtmlElement element, int index) throws JHtmlElementCannotBeAddedException {
        this.elements.insertElementAt(element, index);
    }

    public void addJHtmlElement(JHtmlElement element) throws JHtmlElementCannotBeAddedException {
        this.elements.addElement(element);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.size();
    }

    public JHtmlElement jhtmlElementAt(int loc) throws JHtmlElementIndexOutOfBoundsException {
        try {
            return (JHtmlElement)this.elements.elementAt(loc);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new JHtmlElementIndexOutOfBoundsException(loc);
        }
    }

    public int jhtmlElementIndex(JHtmlElement jhtmlElement) throws JHtmlElementNotFoundException {
        int index = this.elements.indexOf(jhtmlElement);
        if (index == -1) {
            throw new JHtmlElementNotFoundException();
        }
        return this.elements.indexOf(jhtmlElement);
    }

    public void removeJHtmlElement(int index) throws JHtmlElementIndexOutOfBoundsException {
        try {
            this.elements.remove(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new JHtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeJHtmlElement(JHtmlElement jhtmlElement) throws JHtmlElementNotFoundException {
        boolean present = this.elements.remove(jhtmlElement);
        if (!present) {
            throw new JHtmlElementNotFoundException();
        }
    }

    public void removeAll() {
        this.elements.removeAllElements();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areJHtmlChildrenSane() {
        return true;
    }

    public void addJHtmlAttribute(String name, String value) throws JHtmlAttributeCannotBeAddedException {
        throw new JHtmlAttributeCannotBeAddedException();
    }

    public String getJHtmlAttributeValue(String name) {
        return null;
    }

    public String changeJHtmlAttribute(String name, String value) {
        return null;
    }

    public void removeJHtmlAttribute(String name) {
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areJHtmlAttributesSane() {
        return true;
    }

    public int getNumberOfLines() {
        int count = 0;
        JHtmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.jhtmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            count += element.getNumberOfLines();
            ++i;
        }
        return count;
    }

    public String getStartTag() {
        return "";
    }

    public String getEndTag() {
        return "";
    }

    public String getHead() {
        return "";
    }

    public String getTail() {
        return "";
    }

    public String getBody() {
        return "";
    }

    public String getContents() {
        String contents = "";
        JHtmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.jhtmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            contents = contents + element.getContents();
            ++i;
        }
        return contents;
    }

    public void setContents(String contents) {
    }

    public void setContentsWithTag(String contents) {
    }

    public void setText(String text) throws JHtmlTextCannotBeSetException {
        throw new JHtmlTextCannotBeSetException();
    }

    public String getText() throws JHtmlTextNotSetException {
        throw new JHtmlTextNotSetException();
    }

    public void resetText() throws JHtmlTextCannotBeResetException {
        throw new JHtmlTextCannotBeResetException();
    }

    public void setJHtmlParentElement(JHtmlElement jhtmlParentElement) {
    }

    public JHtmlElement getJHtmlParentElement() {
        return null;
    }

    public JHtmlElement cloneJHtmlElement() throws JHtmlElementCloneFailedException {
        JHtmlElement cJHtmlElement = null;
        try {
            cJHtmlElement = (JHtmlElement)this.getClass().newInstance();
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                JHtmlElement childJHtmlElement = this.jhtmlElementAt(i);
                JHtmlElement cChildJHtmlElement = childJHtmlElement.cloneJHtmlElement();
                cJHtmlElement.addJHtmlElement(cChildJHtmlElement);
                ++i;
            }
        }
        catch (JHtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new JHtmlElementCloneFailedException(ex.getMessage());
        }
        return cJHtmlElement;
    }
}

