/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.ihtml;

import com.aligo.ihtml.exceptions.IHtmlAttributeCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementCloneFailedException;
import com.aligo.ihtml.exceptions.IHtmlElementIndexOutOfBoundsException;
import com.aligo.ihtml.exceptions.IHtmlElementNotFoundException;
import com.aligo.ihtml.exceptions.IHtmlTextCannotBeResetException;
import com.aligo.ihtml.exceptions.IHtmlTextCannotBeSetException;
import com.aligo.ihtml.exceptions.IHtmlTextNotSetException;
import com.aligo.ihtml.interfaces.IHtmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class IHtmlElementCollection
implements IHtmlElement {
    Vector elements = new Vector();

    public String getName() {
        return "IHtmlElementCollection";
    }

    public String getXmlID() {
        return "";
    }

    public void addIHtmlElementAt(IHtmlElement element, int index) throws IHtmlElementCannotBeAddedException {
        this.elements.insertElementAt(element, index);
    }

    public void addIHtmlElement(IHtmlElement element) throws IHtmlElementCannotBeAddedException {
        this.elements.addElement(element);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.size();
    }

    public IHtmlElement ihtmlElementAt(int loc) throws IHtmlElementIndexOutOfBoundsException {
        try {
            return (IHtmlElement)this.elements.elementAt(loc);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new IHtmlElementIndexOutOfBoundsException(loc);
        }
    }

    public int ihtmlElementIndex(IHtmlElement ihtmlElement) throws IHtmlElementNotFoundException {
        int index = this.elements.indexOf(ihtmlElement);
        if (index == -1) {
            throw new IHtmlElementNotFoundException();
        }
        return this.elements.indexOf(ihtmlElement);
    }

    public void removeIHtmlElement(int index) throws IHtmlElementIndexOutOfBoundsException {
        try {
            this.elements.remove(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new IHtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeIHtmlElement(IHtmlElement ihtmlElement) throws IHtmlElementNotFoundException {
        boolean present = this.elements.remove(ihtmlElement);
        if (!present) {
            throw new IHtmlElementNotFoundException();
        }
    }

    public void removeAll() {
        this.elements.removeAllElements();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areIHtmlChildrenSane() {
        return true;
    }

    public void addIHtmlAttribute(String name, String value) throws IHtmlAttributeCannotBeAddedException {
        throw new IHtmlAttributeCannotBeAddedException();
    }

    public String getIHtmlAttributeValue(String name) {
        return null;
    }

    public String changeIHtmlAttribute(String name, String value) {
        return null;
    }

    public void removeIHtmlAttribute(String name) {
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areIHtmlAttributesSane() {
        return true;
    }

    public int getNumberOfLines() {
        int count = 0;
        IHtmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.ihtmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            count += element.getNumberOfLines();
            ++i;
        }
        return count;
    }

    public String getStartTag() {
        return "";
    }

    public String getEndTag() {
        return "";
    }

    public String getHead() {
        return "";
    }

    public String getTail() {
        return "";
    }

    public String getBody() {
        return "";
    }

    public String getContents() {
        String contents = "";
        IHtmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.ihtmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            contents = contents + element.getContents();
            ++i;
        }
        return contents;
    }

    public void setContents(String contents) {
    }

    public void setContentsWithTag(String contents) {
    }

    public void setText(String text) throws IHtmlTextCannotBeSetException {
        throw new IHtmlTextCannotBeSetException();
    }

    public String getText() throws IHtmlTextNotSetException {
        throw new IHtmlTextNotSetException();
    }

    public void resetText() throws IHtmlTextCannotBeResetException {
        throw new IHtmlTextCannotBeResetException();
    }

    public void setIHtmlParentElement(IHtmlElement ihtmlParentElement) {
    }

    public IHtmlElement getIHtmlParentElement() {
        return null;
    }

    public IHtmlElement cloneIHtmlElement() throws IHtmlElementCloneFailedException {
        IHtmlElement cIHtmlElement = null;
        try {
            cIHtmlElement = (IHtmlElement)this.getClass().newInstance();
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                IHtmlElement childIHtmlElement = this.ihtmlElementAt(i);
                IHtmlElement cChildIHtmlElement = childIHtmlElement.cloneIHtmlElement();
                cIHtmlElement.addIHtmlElement(cChildIHtmlElement);
                ++i;
            }
        }
        catch (IHtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new IHtmlElementCloneFailedException(ex.getMessage());
        }
        return cIHtmlElement;
    }
}

