/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.ihtml;

import com.aligo.ihtml.IHtmlBaseElement;
import com.aligo.ihtml.exceptions.IHtmlAttributeCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementCannotBeAddedException;
import com.aligo.ihtml.exceptions.IHtmlElementIndexOutOfBoundsException;
import com.aligo.ihtml.exceptions.IHtmlElementNotFoundException;
import com.aligo.ihtml.exceptions.IHtmlTextCannotBeSetException;
import com.aligo.ihtml.exceptions.IHtmlTextNotSetException;
import com.aligo.ihtml.interfaces.IHtmlContainerInterface;
import com.aligo.ihtml.interfaces.IHtmlElement;
import java.util.Hashtable;

public class IHtmlContainer
extends IHtmlBaseElement
implements IHtmlContainerInterface {
    public static final String IHTML_TAG = "";
    public static final String HREF = "href";
    public static final String TITLE = "title";
    public static final String XML_LANG = "xml:lang";
    public static final String ID = "id";
    public static final String CLASS = "class";
    public static final String TEXT = "text";
    private static String SName = "IHtmlContainer";
    private static Hashtable OChildrenRules = new Hashtable();
    private static Hashtable OAttributeRules = new Hashtable();
    private static String[] ORequiredAttributes = new String[0];

    public String getName() {
        return SName;
    }

    public Hashtable getChildrenRules() {
        return OChildrenRules;
    }

    public Hashtable getAttributeRules() {
        return OAttributeRules;
    }

    public String[] getRequiredAttributes() {
        return ORequiredAttributes;
    }

    public String getStartTag() {
        return IHTML_TAG;
    }

    public boolean isAddValid() {
        boolean canAdd;
        block14: {
            canAdd = true;
            IHtmlElement ihtmlParentElement = this.getIHtmlParentElement();
            if (ihtmlParentElement != null) {
                try {
                    IHtmlElement cIHtmlElement;
                    int addIndex = ihtmlParentElement.ihtmlElementIndex(this);
                    if (ihtmlParentElement instanceof IHtmlContainerInterface) {
                        canAdd = ((IHtmlContainerInterface)((Object)ihtmlParentElement)).isAddValid();
                        break block14;
                    }
                    int cindex = 0;
                    try {
                        int numberElements = this.elements.getNumberElements();
                        cindex = 0;
                        while (cindex < numberElements) {
                            cIHtmlElement = this.elements.ihtmlElementAt(cindex);
                            if (addIndex != -1) {
                                ihtmlParentElement.addIHtmlElementAt(cIHtmlElement, addIndex + cindex);
                            } else {
                                ihtmlParentElement.addIHtmlElement(cIHtmlElement);
                            }
                            ++cindex;
                        }
                    }
                    catch (IHtmlElementIndexOutOfBoundsException we) {
                    }
                    catch (IHtmlElementCannotBeAddedException we) {
                        canAdd = false;
                    }
                    int i = 0;
                    while (i < cindex) {
                        try {
                            cIHtmlElement = this.elements.ihtmlElementAt(i);
                            ihtmlParentElement.removeIHtmlElement(cIHtmlElement);
                            cIHtmlElement.setIHtmlParentElement(this);
                        }
                        catch (IHtmlElementIndexOutOfBoundsException we) {
                        }
                        catch (IHtmlElementNotFoundException je) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                catch (IHtmlElementNotFoundException je) {
                    je.printStackTrace();
                }
            }
        }
        return canAdd;
    }

    public void addIHtmlAttribute(String name, String value) throws IHtmlAttributeCannotBeAddedException {
        if (!name.equals(TEXT)) {
            throw new IHtmlAttributeCannotBeAddedException();
        }
        this.sText = value;
    }

    public String getText() throws IHtmlTextNotSetException {
        if (this.sText != null) {
            return this.sText;
        }
        return super.getText();
    }

    public void setText(String text) throws IHtmlTextCannotBeSetException {
        try {
            this.addIHtmlAttribute(TEXT, text);
        }
        catch (IHtmlAttributeCannotBeAddedException ex) {
            throw new IHtmlTextCannotBeSetException();
        }
    }
}

