/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.html.interfaces;

import com.aligo.html.exceptions.HtmlAttributeCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementCannotBeAddedException;
import com.aligo.html.exceptions.HtmlElementCloneFailedException;
import com.aligo.html.exceptions.HtmlElementIndexOutOfBoundsException;
import com.aligo.html.exceptions.HtmlElementNotFoundException;
import com.aligo.html.exceptions.HtmlTextCannotBeResetException;
import com.aligo.html.exceptions.HtmlTextCannotBeSetException;
import com.aligo.html.exceptions.HtmlTextNotSetException;
import java.util.Hashtable;

public interface HtmlElement {
    public String getName();

    public String getXmlID();

    public void addHtmlElementAt(HtmlElement var1, int var2) throws HtmlElementCannotBeAddedException;

    public void addHtmlElement(HtmlElement var1) throws HtmlElementCannotBeAddedException;

    public boolean hasElements();

    public int getNumberElements();

    public HtmlElement htmlElementAt(int var1) throws HtmlElementIndexOutOfBoundsException;

    public int htmlElementIndex(HtmlElement var1) throws HtmlElementNotFoundException;

    public void removeHtmlElement(int var1) throws HtmlElementIndexOutOfBoundsException;

    public void removeHtmlElement(HtmlElement var1) throws HtmlElementNotFoundException;

    public void removeAll();

    public Hashtable getChildrenRules();

    public boolean areHtmlChildrenSane();

    public void addHtmlAttribute(String var1, String var2) throws HtmlAttributeCannotBeAddedException;

    public String getHtmlAttributeValue(String var1);

    public String changeHtmlAttribute(String var1, String var2);

    public void removeHtmlAttribute(String var1);

    public Hashtable getAttributeRules();

    public String[] getRequiredAttributes();

    public boolean areHtmlAttributesSane();

    public int getNumberOfLines();

    public String getStartTag();

    public String getEndTag();

    public String getHead();

    public String getTail();

    public String getBody();

    public String getContents();

    public void setContents(String var1);

    public void setContentsWithTag(String var1);

    public void setText(String var1) throws HtmlTextCannotBeSetException;

    public String getText() throws HtmlTextNotSetException;

    public void resetText() throws HtmlTextCannotBeResetException;

    public void setHtmlParentElement(HtmlElement var1);

    public HtmlElement getHtmlParentElement();

    public HtmlElement cloneHtmlElement() throws HtmlElementCloneFailedException;
}

