/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.hdml;

import com.aligo.hdml.HdmlBaseElement;
import com.aligo.hdml.exceptions.HdmlAttributeCannotBeAddedException;
import com.aligo.hdml.exceptions.HdmlElementCannotBeAddedException;
import com.aligo.hdml.exceptions.HdmlElementIndexOutOfBoundsException;
import com.aligo.hdml.exceptions.HdmlElementNotFoundException;
import com.aligo.hdml.exceptions.HdmlTextCannotBeSetException;
import com.aligo.hdml.exceptions.HdmlTextNotSetException;
import com.aligo.hdml.interfaces.HdmlContainerInterface;
import com.aligo.hdml.interfaces.HdmlElement;
import java.util.Hashtable;

public class HdmlContainer
extends HdmlBaseElement
implements HdmlContainerInterface {
    public static final String HDML_TAG = "";
    public static final String HREF = "href";
    public static final String TITLE = "title";
    public static final String XML_LANG = "xml:lang";
    public static final String ID = "id";
    public static final String CLASS = "class";
    public static final String TEXT = "text";
    private static String SName = "HdmlContainer";
    private static Hashtable OChildrenRules = new Hashtable();
    private static Hashtable OAttributeRules = new Hashtable();
    private static String[] ORequiredAttributes = new String[0];

    public String getName() {
        return SName;
    }

    public Hashtable getChildrenRules() {
        return OChildrenRules;
    }

    public Hashtable getAttributeRules() {
        return OAttributeRules;
    }

    public String[] getRequiredAttributes() {
        return ORequiredAttributes;
    }

    public String getStartTag() {
        return HDML_TAG;
    }

    public boolean isAddValid() {
        boolean canAdd;
        block14: {
            canAdd = true;
            HdmlElement hdmlParentElement = this.getHdmlParentElement();
            if (hdmlParentElement != null) {
                try {
                    HdmlElement cHdmlElement;
                    int addIndex = hdmlParentElement.hdmlElementIndex(this);
                    if (hdmlParentElement instanceof HdmlContainerInterface) {
                        canAdd = ((HdmlContainerInterface)((Object)hdmlParentElement)).isAddValid();
                        break block14;
                    }
                    int cindex = 0;
                    try {
                        int numberElements = this.elements.getNumberElements();
                        cindex = 0;
                        while (cindex < numberElements) {
                            cHdmlElement = this.elements.hdmlElementAt(cindex);
                            if (addIndex != -1) {
                                hdmlParentElement.addHdmlElementAt(cHdmlElement, addIndex + cindex);
                            } else {
                                hdmlParentElement.addHdmlElement(cHdmlElement);
                            }
                            ++cindex;
                        }
                    }
                    catch (HdmlElementIndexOutOfBoundsException we) {
                    }
                    catch (HdmlElementCannotBeAddedException we) {
                        canAdd = false;
                    }
                    int i = 0;
                    while (i < cindex) {
                        try {
                            cHdmlElement = this.elements.hdmlElementAt(i);
                            hdmlParentElement.removeHdmlElement(cHdmlElement);
                            cHdmlElement.setHdmlParentElement(this);
                        }
                        catch (HdmlElementIndexOutOfBoundsException we) {
                        }
                        catch (HdmlElementNotFoundException je) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                catch (HdmlElementNotFoundException je) {
                    je.printStackTrace();
                }
            }
        }
        return canAdd;
    }

    public void addHdmlAttribute(String name, String value) throws HdmlAttributeCannotBeAddedException {
        if (!name.equals(TEXT)) {
            throw new HdmlAttributeCannotBeAddedException();
        }
        this.sText = value;
    }

    public String getText() throws HdmlTextNotSetException {
        if (this.sText != null) {
            return this.sText;
        }
        return super.getText();
    }

    public void setText(String text) throws HdmlTextCannotBeSetException {
        try {
            this.addHdmlAttribute(TEXT, text);
        }
        catch (HdmlAttributeCannotBeAddedException ex) {
            throw new HdmlTextCannotBeSetException();
        }
    }
}

