/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.hdml;

import com.aligo.hdml.HdmlAttributes;
import com.aligo.hdml.HdmlContainer;
import com.aligo.hdml.HdmlElementCollection;
import com.aligo.hdml.exceptions.HdmlAttributeCannotBeAddedException;
import com.aligo.hdml.exceptions.HdmlElementCannotBeAddedException;
import com.aligo.hdml.exceptions.HdmlElementIndexOutOfBoundsException;
import com.aligo.hdml.exceptions.HdmlElementNotFoundException;
import com.aligo.hdml.exceptions.HdmlTextCannotBeResetException;
import com.aligo.hdml.exceptions.HdmlTextCannotBeSetException;
import com.aligo.hdml.exceptions.HdmlTextNotSetException;
import com.aligo.hdml.interfaces.HdmlAttributeInterface;
import com.aligo.hdml.interfaces.HdmlContainerInterface;
import com.aligo.hdml.interfaces.HdmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HdmlBaseElement
implements HdmlElement {
    public static final String AMPERSAND = "&";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String HDML_BOOLEAN = "boolean";
    public static final String HDML_CDATA = "cdata";
    public static final String HDML_NUMBER = "number";
    public static final String HDML_PCDATA = "pcdata";
    public static final String HDML_TEXT = "text";
    public static final String[] SHdmlDataTypes = new String[]{"boolean", "cdata", "number", "pcdata", "text"};
    public static final String HDML_HDML = "Hdml";
    public static final int LAST_ELEMENT_ID = -1;
    protected static boolean bContainerClass = false;
    protected boolean bContentsWithTag = false;
    private String SName = this.getName();
    private String sContents = null;
    protected Vector listeners = new Vector();
    protected Hashtable listenerMap = new Hashtable();
    protected HdmlElementCollection elements = new HdmlElementCollection();
    private Hashtable oChildrenRules = this.getChildrenRules();
    protected HdmlAttributeInterface oAttributes = new HdmlAttributes();
    private Hashtable oAttributeRules;
    private String[] requiredAttributes = this.getRequiredAttributes();
    protected String sText;
    private HdmlElement oHdmlParentElement;

    public HdmlBaseElement() {
        this.oAttributeRules = this.getAttributeRules();
    }

    public String getName() {
        return "HdmlBaseElement";
    }

    public String getXmlID() {
        return HDML_HDML;
    }

    protected void addNCHdmlElement(HdmlElement hdmlElement, int index) throws HdmlElementCannotBeAddedException {
        if (index == -1) {
            this.elements.addHdmlElement(hdmlElement);
        } else {
            this.elements.addHdmlElementAt(hdmlElement, index);
        }
        hdmlElement.setHdmlParentElement(this);
    }

    public void addHdmlElementAt(HdmlElement hdmlElement, int index) throws HdmlElementCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = hdmlElement.getName();
        if (this instanceof HdmlContainerInterface || hdmlElement instanceof HdmlContainerInterface) {
            this.addNCHdmlElement(hdmlElement, index);
            HdmlContainerInterface checkValidElement = null;
            if (this instanceof HdmlContainerInterface) {
                checkValidElement = (HdmlContainerInterface)((Object)this);
            } else if (hdmlElement instanceof HdmlContainerInterface) {
                checkValidElement = (HdmlContainerInterface)((Object)hdmlElement);
            }
            done = checkValidElement.isAddValid();
            if (!done) {
                try {
                    this.removeHdmlElement(hdmlElement);
                }
                catch (HdmlElementNotFoundException je) {
                    // empty catch block
                }
                throw new HdmlElementCannotBeAddedException();
            }
        } else {
            try {
                Enumeration keys = this.oChildrenRules.keys();
                while (!done && keys.hasMoreElements()) {
                    String sChild;
                    HdmlElement containedElement;
                    int i;
                    Object child = keys.nextElement();
                    String childValue = (String)this.oChildrenRules.get(child);
                    if (child instanceof Vector) {
                        Vector vChild = (Vector)child;
                        if (!vChild.contains(className)) continue;
                        done = true;
                        if (!childValue.equals(ONCE)) continue;
                        int numberChild = vChild.size();
                        i = 0;
                        while (i < numberElements && !exception) {
                            containedElement = this.elements.hdmlElementAt(i);
                            int j = 0;
                            while (j < numberChild && !exception) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    exception = true;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!(child instanceof String) || !(sChild = (String)child).equals(className)) continue;
                    done = true;
                    if (!childValue.equals(ONCE)) continue;
                    i = 0;
                    while (i < numberElements && !exception) {
                        containedElement = this.elements.hdmlElementAt(i);
                        if (containedElement.getName().equals(sChild)) {
                            exception = true;
                        }
                        ++i;
                    }
                }
            }
            catch (HdmlElementIndexOutOfBoundsException we) {
                // empty catch block
            }
            if (!done || exception) {
                throw new HdmlElementCannotBeAddedException();
            }
            this.addNCHdmlElement(hdmlElement, index);
        }
    }

    public void addHdmlElement(HdmlElement hdmlElement) throws HdmlElementCannotBeAddedException {
        this.addHdmlElementAt(hdmlElement, -1);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public HdmlElement hdmlElementAt(int index) throws HdmlElementIndexOutOfBoundsException {
        return this.elements.hdmlElementAt(index);
    }

    public int hdmlElementIndex(HdmlElement hdmlElement) throws HdmlElementNotFoundException {
        return this.elements.hdmlElementIndex(hdmlElement);
    }

    public void removeHdmlElement(int index) throws HdmlElementIndexOutOfBoundsException {
        this.elements.removeHdmlElement(index);
    }

    public void removeHdmlElement(HdmlElement hdmlElement) throws HdmlElementNotFoundException {
        this.elements.removeHdmlElement(hdmlElement);
        hdmlElement.setHdmlParentElement(null);
    }

    public void removeAll() {
        this.elements.removeAll();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areHdmlChildrenSane() {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        try {
            Enumeration keys = this.oChildrenRules.keys();
            while (sane && keys.hasMoreElements()) {
                int j;
                HdmlElement containedElement;
                HdmlElement childElement;
                int i;
                Object child = keys.nextElement();
                String childValue = (String)this.oChildrenRules.get(child);
                if (child instanceof Vector) {
                    Vector vChild = (Vector)child;
                    if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                    int numberChild = vChild.size();
                    done = false;
                    i = 0;
                    while (i < numberElements && !done) {
                        childElement = this.elements.hdmlElementAt(i);
                        Vector vContainer = this.getNonContainerElements(childElement);
                        int numberContainer = vContainer.size();
                        int k = 0;
                        while (k < numberContainer) {
                            containedElement = (HdmlElement)vContainer.elementAt(k);
                            j = 0;
                            while (j < numberChild && !done) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    done = true;
                                }
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (done) continue;
                    sane = false;
                    continue;
                }
                if (!(child instanceof String)) continue;
                String sChild = (String)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    childElement = this.elements.hdmlElementAt(i);
                    Vector vContainer = this.getNonContainerElements(childElement);
                    int numberContainer = vContainer.size();
                    j = 0;
                    while (j < numberContainer) {
                        containedElement = (HdmlElement)vContainer.elementAt(j);
                        if (containedElement.getName().equals(sChild)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done) continue;
                sane = false;
            }
        }
        catch (HdmlElementIndexOutOfBoundsException we) {
            // empty catch block
        }
        return sane;
    }

    public void addHdmlAttribute(String name, String value) throws HdmlAttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new HdmlAttributeCannotBeAddedException();
        }
        this.oAttributes.addAttribute(name, value);
    }

    public String getHdmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public String changeHdmlAttribute(String name, String value) {
        String oldAttributeValue = this.oAttributes.change(name, value);
        return oldAttributeValue;
    }

    public void removeHdmlAttribute(String name) {
        this.oAttributes.remove(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areHdmlAttributesSane() {
        boolean sane = true;
        String value = null;
        if (this.requiredAttributes != null) {
            int i = 0;
            while (i < this.requiredAttributes.length && sane) {
                value = this.oAttributes.getValue(this.requiredAttributes[i]);
                if (value == null) {
                    sane = false;
                }
                ++i;
            }
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        String head = ONCE;
        if (!startTag.equals(ONCE)) {
            head = LESSERTHAN + startTag + this.oAttributes.getContents();
            head = head + GREATERTHAN;
        }
        return head;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        String tail = ONCE;
        if (!endTag.equals(ONCE)) {
            tail = "</" + endTag + GREATERTHAN + NEWLINE;
        }
        return tail;
    }

    public String getBody() {
        String body = ONCE;
        String text = null;
        try {
            text = this.getText();
            if (text != null) {
                body = text;
            }
        }
        catch (HdmlTextNotSetException we) {
            body = this.elements.getContents();
        }
        return body;
    }

    public String getContents() {
        String contents = ONCE;
        if (this.sContents == null) {
            String body = this.getBody();
            contents = this.getHead() + body + this.getTail();
        } else {
            contents = this.bContentsWithTag ? this.getHead() + this.sContents + this.getTail() : this.sContents;
        }
        return contents;
    }

    public void setContents(String contents) {
        this.sContents = contents;
    }

    public void setContentsWithTag(String contents) {
        this.setContents(contents);
        this.bContentsWithTag = true;
    }

    public void setText(String text) throws HdmlTextCannotBeSetException {
        throw new HdmlTextCannotBeSetException();
    }

    public String getText() throws HdmlTextNotSetException {
        throw new HdmlTextNotSetException();
    }

    public void resetText() throws HdmlTextCannotBeResetException {
        throw new HdmlTextCannotBeResetException();
    }

    public void setHdmlParentElement(HdmlElement hdmlParentElement) {
        this.oHdmlParentElement = hdmlParentElement;
    }

    public HdmlElement getHdmlParentElement() {
        return this.oHdmlParentElement;
    }

    public static String[] getHdmlDataTypes() {
        return SHdmlDataTypes;
    }

    public boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SHdmlDataTypes.length && !found) {
            if (dataType.equals(SHdmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return HDML_PCDATA;
    }

    private Vector getNonContainerElements(HdmlElement hdmlElement) {
        Vector nonContainerElements = new Vector();
        this.getNonContainerElements(hdmlElement, nonContainerElements);
        return nonContainerElements;
    }

    private void getNonContainerElements(HdmlElement hdmlElement, Vector nonContainerElements) {
        if (hdmlElement != null) {
            if (hdmlElement instanceof HdmlContainer) {
                int numberChildren = hdmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren) {
                    try {
                        HdmlElement childHdmlElement = hdmlElement.hdmlElementAt(i);
                        this.getNonContainerElements(childHdmlElement, nonContainerElements);
                    }
                    catch (HdmlElementIndexOutOfBoundsException he) {
                        // empty catch block
                    }
                    ++i;
                }
            } else {
                nonContainerElements.addElement(hdmlElement);
            }
        }
    }
}

