/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.chtml;

import com.aligo.chtml.exceptions.CHtmlAttributeCannotBeAddedException;
import com.aligo.chtml.exceptions.CHtmlElementCannotBeAddedException;
import com.aligo.chtml.exceptions.CHtmlElementCloneFailedException;
import com.aligo.chtml.exceptions.CHtmlElementIndexOutOfBoundsException;
import com.aligo.chtml.exceptions.CHtmlElementNotFoundException;
import com.aligo.chtml.exceptions.CHtmlTextCannotBeResetException;
import com.aligo.chtml.exceptions.CHtmlTextCannotBeSetException;
import com.aligo.chtml.exceptions.CHtmlTextNotSetException;
import com.aligo.chtml.interfaces.CHtmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class CHtmlElementCollection
implements CHtmlElement {
    Vector elements = new Vector();
    CHtmlElement oCHtmlParentElement;

    public String getName() {
        return "CHtmlElementCollection";
    }

    public String getXmlID() {
        return "";
    }

    public void addCHtmlElementAt(CHtmlElement element, int index) throws CHtmlElementCannotBeAddedException {
        this.elements.insertElementAt(element, index);
    }

    public void addCHtmlElement(CHtmlElement element) throws CHtmlElementCannotBeAddedException {
        this.elements.addElement(element);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.size();
    }

    public CHtmlElement chtmlElementAt(int loc) throws CHtmlElementIndexOutOfBoundsException {
        try {
            return (CHtmlElement)this.elements.elementAt(loc);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new CHtmlElementIndexOutOfBoundsException(loc);
        }
    }

    public int chtmlElementIndex(CHtmlElement chtmlElement) throws CHtmlElementNotFoundException {
        int index = this.elements.indexOf(chtmlElement);
        if (index == -1) {
            throw new CHtmlElementNotFoundException();
        }
        return this.elements.indexOf(chtmlElement);
    }

    public void removeCHtmlElement(int index) throws CHtmlElementIndexOutOfBoundsException {
        try {
            this.elements.remove(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new CHtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeCHtmlElement(CHtmlElement chtmlElement) throws CHtmlElementNotFoundException {
        boolean present = this.elements.remove(chtmlElement);
        if (!present) {
            throw new CHtmlElementNotFoundException();
        }
    }

    public void removeAll() {
        this.elements.removeAllElements();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areCHtmlChildrenSane() {
        return true;
    }

    public void addCHtmlAttribute(String name, String value) throws CHtmlAttributeCannotBeAddedException {
        throw new CHtmlAttributeCannotBeAddedException();
    }

    public String getCHtmlAttributeValue(String name) {
        return null;
    }

    public String changeCHtmlAttribute(String name, String value) {
        return null;
    }

    public void removeCHtmlAttribute(String name) {
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areCHtmlAttributesSane() {
        return true;
    }

    public int getNumberOfLines() {
        int count = 0;
        CHtmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.chtmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            count += element.getNumberOfLines();
            ++i;
        }
        return count;
    }

    public String getStartTag() {
        return "";
    }

    public String getEndTag() {
        return "";
    }

    public String getHead() {
        return "";
    }

    public String getTail() {
        return "";
    }

    public String getBody() {
        return "";
    }

    private boolean isParentElementBeginNewLine() {
        return this.oCHtmlParentElement != null && this.oCHtmlParentElement.isElementBeginNewLine();
    }

    private boolean isParentElementEndNewLine() {
        return this.oCHtmlParentElement != null && this.oCHtmlParentElement.isElementEndNewLine();
    }

    private void formatContents(StringBuffer contents, boolean newLine) {
        if (newLine) {
            contents.append("\n");
        }
    }

    public String getContents() {
        StringBuffer contents = new StringBuffer("");
        int size = this.elements.size();
        CHtmlElement element = null;
        boolean newLine = this.isParentElementBeginNewLine();
        int i = 0;
        while (i < size) {
            try {
                element = this.chtmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.formatContents(contents, newLine &= element.isContentsBeginNewLine());
            newLine = element.isContentsEndNewLine();
            contents.append(element.getContents());
            ++i;
        }
        if (size > 0 && this.isParentElementEndNewLine()) {
            this.formatContents(contents, newLine);
        }
        return contents.toString();
    }

    public void setText(String text) throws CHtmlTextCannotBeSetException {
        throw new CHtmlTextCannotBeSetException();
    }

    public String getText() throws CHtmlTextNotSetException {
        throw new CHtmlTextNotSetException();
    }

    public void resetText() throws CHtmlTextCannotBeResetException {
        throw new CHtmlTextCannotBeResetException();
    }

    public void setCHtmlParentElement(CHtmlElement chtmlParentElement) {
        this.oCHtmlParentElement = chtmlParentElement;
    }

    public CHtmlElement getCHtmlParentElement() {
        return this.oCHtmlParentElement;
    }

    public boolean isElementBeginNewLine() {
        return false;
    }

    public boolean isElementEndNewLine() {
        return false;
    }

    public boolean isContentsBeginNewLine() {
        return false;
    }

    public boolean isContentsEndNewLine() {
        return false;
    }

    public CHtmlElement cloneCHtmlElement() throws CHtmlElementCloneFailedException {
        CHtmlElement cCHtmlElement = null;
        try {
            cCHtmlElement = (CHtmlElement)this.getClass().newInstance();
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                CHtmlElement childCHtmlElement = this.chtmlElementAt(i);
                CHtmlElement cChildCHtmlElement = childCHtmlElement.cloneCHtmlElement();
                cCHtmlElement.addCHtmlElement(cChildCHtmlElement);
                ++i;
            }
        }
        catch (CHtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new CHtmlElementCloneFailedException(ex.getMessage());
        }
        return cCHtmlElement;
    }
}

