/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.chtml;

import com.aligo.chtml.CHtmlAttributes;
import com.aligo.chtml.CHtmlContainer;
import com.aligo.chtml.CHtmlElementCollection;
import com.aligo.chtml.exceptions.CHtmlAttributeCannotBeAddedException;
import com.aligo.chtml.exceptions.CHtmlElementCannotBeAddedException;
import com.aligo.chtml.exceptions.CHtmlElementCloneFailedException;
import com.aligo.chtml.exceptions.CHtmlElementIndexOutOfBoundsException;
import com.aligo.chtml.exceptions.CHtmlElementNotFoundException;
import com.aligo.chtml.exceptions.CHtmlTextCannotBeResetException;
import com.aligo.chtml.exceptions.CHtmlTextCannotBeSetException;
import com.aligo.chtml.exceptions.CHtmlTextNotSetException;
import com.aligo.chtml.interfaces.CHtmlAttributeInterface;
import com.aligo.chtml.interfaces.CHtmlContainerInterface;
import com.aligo.chtml.interfaces.CHtmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CHtmlBaseElement
implements CHtmlElement {
    public static final String AMPERSAND = "&";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String UNDERSCORE = "_";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String CHTML_BOOLEAN = "boolean";
    public static final String CHTML_CDATA = "cdata";
    public static final String CHTML_EMPH = "emph";
    public static final String CHTML_FLOW = "flow";
    public static final String CHTML_HREF = "href";
    public static final String CHTML_ID = "id";
    public static final String CHTML_INLINE = "inline";
    public static final String CHTML_LAYOUT = "layout";
    public static final String CHTML_LENGTH = "length";
    public static final String CHTML_NUMBER = "number";
    public static final String CHTML_PASSWORD = "password";
    public static final String CHTML_PCDATA = "pcdata";
    public static final String CHTML_TEXT = "text";
    public static final String CHTML_TOKEN = "nmtoken";
    public static final String CHTML_VDATA = "vdata";
    public static final String[] SCHtmlDataTypes = new String[]{"boolean", "cdata", "emph", "flow", "href", "id", "inline", "layout", "length", "number", "password", "pcdata", "text", "nmtoken", "vdata"};
    public static final String CHTML_CHTML = "CHtml";
    public static final int LAST_ELEMENT_ID = -1;
    protected static boolean bContainerClass = false;
    private String SName = this.getName();
    protected CHtmlElementCollection elements = new CHtmlElementCollection();
    private Hashtable oChildrenRules;
    protected CHtmlAttributeInterface oAttributes;
    private Hashtable oAttributeRules;
    private String[] requiredAttributes;
    protected String sText;
    private CHtmlElement oCHtmlParentElement;

    public CHtmlBaseElement() {
        this.elements.setCHtmlParentElement(this);
        this.oChildrenRules = this.getChildrenRules();
        this.oAttributes = new CHtmlAttributes();
        this.requiredAttributes = this.getRequiredAttributes();
        this.oAttributeRules = this.getAttributeRules();
    }

    public String getName() {
        return "CHtmlBaseElement";
    }

    public String getXmlID() {
        return CHTML_CHTML;
    }

    protected void addNCCHtmlElement(CHtmlElement chtmlElement, int index) throws CHtmlElementCannotBeAddedException {
        if (index == -1) {
            this.elements.addCHtmlElement(chtmlElement);
        } else {
            this.elements.addCHtmlElementAt(chtmlElement, index);
        }
        chtmlElement.setCHtmlParentElement(this);
    }

    public void addCHtmlElementAt(CHtmlElement chtmlElement, int index) throws CHtmlElementCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = chtmlElement.getName();
        if (this instanceof CHtmlContainerInterface || chtmlElement instanceof CHtmlContainerInterface) {
            this.addNCCHtmlElement(chtmlElement, index);
            CHtmlContainerInterface checkValidElement = null;
            if (this instanceof CHtmlContainerInterface) {
                checkValidElement = (CHtmlContainerInterface)((Object)this);
            } else if (chtmlElement instanceof CHtmlContainerInterface) {
                checkValidElement = (CHtmlContainerInterface)((Object)chtmlElement);
            }
            done = checkValidElement.isAddValid();
            if (!done) {
                try {
                    this.removeCHtmlElement(chtmlElement);
                }
                catch (CHtmlElementNotFoundException je) {
                    // empty catch block
                }
                throw new CHtmlElementCannotBeAddedException();
            }
        } else {
            try {
                Enumeration keys = this.oChildrenRules.keys();
                while (!done && keys.hasMoreElements()) {
                    String sChild;
                    CHtmlElement containedElement;
                    int i;
                    Object child = keys.nextElement();
                    String childValue = (String)this.oChildrenRules.get(child);
                    if (child instanceof Vector) {
                        Vector vChild = (Vector)child;
                        if (!vChild.contains(className)) continue;
                        done = true;
                        if (!childValue.equals(ONCE)) continue;
                        int numberChild = vChild.size();
                        i = 0;
                        while (i < numberElements && !exception) {
                            containedElement = this.elements.chtmlElementAt(i);
                            int j = 0;
                            while (j < numberChild && !exception) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    exception = true;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!(child instanceof String) || !(sChild = (String)child).equals(className)) continue;
                    done = true;
                    if (!childValue.equals(ONCE)) continue;
                    i = 0;
                    while (i < numberElements && !exception) {
                        containedElement = this.elements.chtmlElementAt(i);
                        if (containedElement.getName().equals(sChild)) {
                            exception = true;
                        }
                        ++i;
                    }
                }
            }
            catch (CHtmlElementIndexOutOfBoundsException we) {
                // empty catch block
            }
            if (!done || exception) {
                throw new CHtmlElementCannotBeAddedException();
            }
            this.addNCCHtmlElement(chtmlElement, index);
        }
    }

    public void addCHtmlElement(CHtmlElement chtmlElement) throws CHtmlElementCannotBeAddedException {
        this.addCHtmlElementAt(chtmlElement, -1);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public CHtmlElement chtmlElementAt(int index) throws CHtmlElementIndexOutOfBoundsException {
        return this.elements.chtmlElementAt(index);
    }

    public int chtmlElementIndex(CHtmlElement chtmlElement) throws CHtmlElementNotFoundException {
        return this.elements.chtmlElementIndex(chtmlElement);
    }

    public void removeCHtmlElement(int index) throws CHtmlElementIndexOutOfBoundsException {
        CHtmlElement chtmlElement = this.chtmlElementAt(index);
        try {
            this.removeCHtmlElement(chtmlElement);
        }
        catch (CHtmlElementNotFoundException we) {
            throw new CHtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeCHtmlElement(CHtmlElement chtmlElement) throws CHtmlElementNotFoundException {
        this.elements.removeCHtmlElement(chtmlElement);
        chtmlElement.setCHtmlParentElement(null);
    }

    public void removeAll() {
        int numberElements = this.getNumberElements();
        int i = 0;
        while (i < numberElements) {
            try {
                this.removeCHtmlElement(i);
            }
            catch (CHtmlElementIndexOutOfBoundsException cHtmlElementIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areCHtmlChildrenSane() {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        try {
            Enumeration keys = this.oChildrenRules.keys();
            while (sane && keys.hasMoreElements()) {
                int j;
                CHtmlElement containedElement;
                CHtmlElement childElement;
                int i;
                Object child = keys.nextElement();
                String childValue = (String)this.oChildrenRules.get(child);
                if (child instanceof Vector) {
                    Vector vChild = (Vector)child;
                    if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                    int numberChild = vChild.size();
                    done = false;
                    i = 0;
                    while (i < numberElements && !done) {
                        childElement = this.elements.chtmlElementAt(i);
                        Vector vContainer = this.getNonContainerElements(childElement);
                        int numberContainer = vContainer.size();
                        int k = 0;
                        while (k < numberContainer) {
                            containedElement = (CHtmlElement)vContainer.elementAt(k);
                            j = 0;
                            while (j < numberChild && !done) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    done = true;
                                }
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (done) continue;
                    sane = false;
                    continue;
                }
                if (!(child instanceof String)) continue;
                String sChild = (String)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    childElement = this.elements.chtmlElementAt(i);
                    Vector vContainer = this.getNonContainerElements(childElement);
                    int numberContainer = vContainer.size();
                    j = 0;
                    while (j < numberContainer) {
                        containedElement = (CHtmlElement)vContainer.elementAt(j);
                        if (containedElement.getName().equals(sChild)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done) continue;
                sane = false;
            }
        }
        catch (CHtmlElementIndexOutOfBoundsException we) {
            // empty catch block
        }
        return sane;
    }

    public void addCHtmlAttribute(String name, String value) throws CHtmlAttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new CHtmlAttributeCannotBeAddedException();
        }
        this.oAttributes.addAttribute(name, value);
    }

    public String getCHtmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public String changeCHtmlAttribute(String name, String value) {
        String oldAttributeValue = this.oAttributes.change(name, value);
        return oldAttributeValue;
    }

    public void removeCHtmlAttribute(String name) {
        String value = this.getCHtmlAttributeValue(name);
        this.oAttributes.remove(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areCHtmlAttributesSane() {
        boolean sane = true;
        String value = null;
        if (this.requiredAttributes != null) {
            int i = 0;
            while (i < this.requiredAttributes.length && sane) {
                value = this.oAttributes.getValue(this.requiredAttributes[i]);
                if (value == null) {
                    sane = false;
                }
                ++i;
            }
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        String head = ONCE;
        if (!startTag.equals(ONCE)) {
            head = LESSERTHAN + startTag + this.oAttributes.getContents();
            head = head + GREATERTHAN;
        }
        return head;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        String tail = ONCE;
        if (!endTag.equals(ONCE)) {
            tail = "</" + endTag + GREATERTHAN;
        }
        return tail;
    }

    public String getBody() {
        String body = ONCE;
        String text = null;
        try {
            text = this.getText();
            if (text != null) {
                body = text;
            }
        }
        catch (CHtmlTextNotSetException we) {
            body = this.elements.getContents();
        }
        return body;
    }

    public String getContents() {
        StringBuffer contents = new StringBuffer(ONCE);
        contents.append(this.getHead());
        contents.append(this.getBody());
        contents.append(this.getTail());
        return contents.toString();
    }

    public void setText(String text) throws CHtmlTextCannotBeSetException {
        throw new CHtmlTextCannotBeSetException();
    }

    public String getText() throws CHtmlTextNotSetException {
        throw new CHtmlTextNotSetException();
    }

    public void resetText() throws CHtmlTextCannotBeResetException {
        throw new CHtmlTextCannotBeResetException();
    }

    public void setCHtmlParentElement(CHtmlElement chtmlParentElement) {
        this.oCHtmlParentElement = chtmlParentElement;
    }

    public CHtmlElement getCHtmlParentElement() {
        return this.oCHtmlParentElement;
    }

    public boolean isElementBeginNewLine() {
        boolean newLine = true;
        String startTag = this.getStartTag();
        if (startTag.equals(ONCE)) {
            newLine = false;
        }
        return newLine;
    }

    public boolean isElementEndNewLine() {
        boolean newLine = true;
        String endTag = this.getEndTag();
        if (endTag.equals(ONCE)) {
            newLine = false;
        }
        return newLine;
    }

    public boolean isElementNewLine() {
        return this.isElementBeginNewLine() || this.isElementEndNewLine();
    }

    public boolean isContentsBeginNewLine() {
        return this.isElementNewLine();
    }

    public boolean isContentsEndNewLine() {
        return this.isElementNewLine();
    }

    public CHtmlElement cloneCHtmlElement() throws CHtmlElementCloneFailedException {
        CHtmlElement cCHtmlElement = null;
        try {
            cCHtmlElement = (CHtmlElement)this.getClass().newInstance();
            Enumeration keys = this.oAttributes.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String value = this.oAttributes.getValue(name);
                cCHtmlElement.addCHtmlAttribute(name, value);
            }
            try {
                String text = this.getText();
                cCHtmlElement.setText(text);
            }
            catch (CHtmlTextNotSetException je) {
                // empty catch block
            }
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                CHtmlElement childCHtmlElement = this.chtmlElementAt(i);
                CHtmlElement cChildCHtmlElement = childCHtmlElement.cloneCHtmlElement();
                cCHtmlElement.addCHtmlElement(cChildCHtmlElement);
                ++i;
            }
        }
        catch (CHtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new CHtmlElementCloneFailedException(ex.getMessage());
        }
        return cCHtmlElement;
    }

    public static String[] getCHtmlDataTypes() {
        return SCHtmlDataTypes;
    }

    public static boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SCHtmlDataTypes.length && !found) {
            if (dataType.equals(SCHtmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return CHTML_PCDATA;
    }

    private Vector getNonContainerElements(CHtmlElement chtmlElement) {
        Vector nonContainerElements = new Vector();
        this.getNonContainerElements(chtmlElement, nonContainerElements);
        return nonContainerElements;
    }

    private void getNonContainerElements(CHtmlElement chtmlElement, Vector nonContainerElements) {
        if (chtmlElement != null) {
            if (chtmlElement instanceof CHtmlContainer) {
                int numberChildren = chtmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren) {
                    try {
                        CHtmlElement childCHtmlElement = chtmlElement.chtmlElementAt(i);
                        this.getNonContainerElements(childCHtmlElement, nonContainerElements);
                    }
                    catch (CHtmlElementIndexOutOfBoundsException he) {
                        // empty catch block
                    }
                    ++i;
                }
            } else {
                nonContainerElements.addElement(chtmlElement);
            }
        }
    }
}

