/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.axml.debug;

import com.aligo.axml.debug.AxmlErrorCollection;
import com.aligo.axml.interfaces.AxmlDebugInterface;
import com.aligo.axml.interfaces.AxmlErrorCollectionInterface;
import com.aligo.axml.interfaces.AxmlErrorInterface;
import java.util.Enumeration;

public class AxmlDebug
implements AxmlDebugInterface {
    private static final String NEWLINE = "\n";
    private static final String ERROR = "(error)";
    private AxmlErrorCollectionInterface oErrorCollection = new AxmlErrorCollection();
    private String sName;

    public void setError(AxmlErrorCollectionInterface errorCollection) {
        this.oErrorCollection = errorCollection;
    }

    public void addError(AxmlErrorInterface error) {
        this.oErrorCollection.addError(error);
    }

    public AxmlErrorCollectionInterface getError() {
        return this.oErrorCollection;
    }

    public void removeError(AxmlErrorInterface error) {
        this.oErrorCollection.removeError(error);
    }

    public AxmlErrorCollectionInterface getErrorCollection() {
        return this.oErrorCollection;
    }

    public void setName(String name) {
        this.sName = name;
    }

    public String toString() {
        String displayName = this.sName;
        boolean done = false;
        Enumeration keys = this.oErrorCollection.getErrors();
        while (keys.hasMoreElements() && !done) {
            AxmlErrorInterface error = (AxmlErrorInterface)keys.nextElement();
            if (error instanceof AxmlDebugInterface) continue;
            displayName = this.sName + ERROR;
            done = true;
        }
        return displayName;
    }

    public String getString() {
        String sDebugStr = new String("");
        Enumeration keys = this.oErrorCollection.getErrors();
        while (keys.hasMoreElements()) {
            AxmlErrorInterface error = (AxmlErrorInterface)keys.nextElement();
            String errorStr = error.getString();
            if ((errorStr = errorStr.trim()).equals("")) continue;
            sDebugStr = sDebugStr + errorStr;
            if (!keys.hasMoreElements()) continue;
            sDebugStr = sDebugStr + NEWLINE;
        }
        return sDebugStr;
    }
}

