/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.axml;

import com.aligo.axml.AxmlAttributes;
import com.aligo.axml.AxmlElementCollection;
import com.aligo.axml.AxmlError;
import com.aligo.axml.AxmlExtensionCollection;
import com.aligo.axml.debug.AxmlDebug;
import com.aligo.axml.exceptions.AxmlAttributeCannotBeAddedException;
import com.aligo.axml.exceptions.AxmlElementCannotBeAddedException;
import com.aligo.axml.exceptions.AxmlElementNotFoundException;
import com.aligo.axml.interfaces.AxmlAttributeInterface;
import com.aligo.axml.interfaces.AxmlCheckBoxInterface;
import com.aligo.axml.interfaces.AxmlChoiceInterface;
import com.aligo.axml.interfaces.AxmlDebugInterface;
import com.aligo.axml.interfaces.AxmlDocumentInterface;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.axml.interfaces.AxmlExtensionCollectionInterface;
import com.aligo.axml.interfaces.AxmlExtensionInterface;
import com.aligo.axml.interfaces.AxmlFormInterface;
import com.aligo.axml.interfaces.AxmlInputInterface;
import com.aligo.axml.interfaces.AxmlTextAreaInterface;
import com.aligo.util.axml.TextUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AxmlBaseElement
implements AxmlElement {
    public static final String AMPERSAND = "&amp;";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SPACE = " ";
    public static final String ANY = "*";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String AXML_BOOLEAN = "boolean";
    public static final String AXML_CDATA = "cdata";
    public static final String AXML_EMPH = "emph";
    public static final String AXML_FLOW = "flow";
    public static final String AXML_HREF = "href";
    public static final String AXML_ID = "id";
    public static final String AXML_INLINE = "inline";
    public static final String AXML_LAYOUT = "layout";
    public static final String AXML_LENGTH = "length";
    public static final String AXML_NUMBER = "number";
    public static final String AXML_PASSWORD = "password";
    public static final String AXML_PCDATA = "pcdata";
    public static final String AXML_TEXT = "text";
    public static final String AXML_TOKEN = "nmtoken";
    public static final String AXML_VDATA = "vdata";
    public static final String[] SAxmlDataTypes = new String[]{"boolean", "cdata", "emph", "flow", "href", "id", "inline", "layout", "length", "number", "password", "pcdata", "text", "nmtoken", "vdata"};
    public static final String axmlHeader = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE AxmlDocument SYSTEM \"axml.dtd\">\r\n";
    private String sName = this.getName();
    protected AxmlElementCollection elements = new AxmlElementCollection();
    protected AxmlExtensionCollection extensions_;
    private Hashtable oChildrenRules = this.getChildrenRules();
    protected AxmlAttributeInterface oAttributes = new AxmlAttributes();
    private Hashtable oAttributeRules;
    private String[] requiredAttributes = this.getRequiredAttributes();
    protected String sText;
    private AxmlElement oAxmlParentElement;

    public AxmlBaseElement() {
        this.oAttributeRules = this.getAttributeRules();
        this.extensions_ = new AxmlExtensionCollection();
    }

    public String getName() {
        return "AxmlBaseElement";
    }

    public void addAxmlElement(AxmlElement axmlElement) throws AxmlElementCannotBeAddedException {
        this.addAxmlElementAt(axmlElement, this.elements.getNumberElements());
    }

    public void addAxmlElementAt(AxmlElement axmlElement, int index) throws AxmlElementCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = axmlElement.getName();
        Enumeration keys = this.oChildrenRules.keys();
        while (!done && keys.hasMoreElements()) {
            String sChild;
            AxmlElement containedElement;
            int i;
            Object child = keys.nextElement();
            String childValue = (String)this.oChildrenRules.get(child);
            if (child instanceof Vector) {
                Vector vChild = (Vector)child;
                if (!vChild.contains(className)) continue;
                done = true;
                if (!childValue.equals(ONCE)) continue;
                int numberChild = vChild.size();
                i = 0;
                while (i < numberElements && !exception) {
                    containedElement = this.elements.axmlElementAt(i);
                    int j = 0;
                    while (j < numberChild && !exception) {
                        String childName = (String)vChild.elementAt(j);
                        if (containedElement.getName().equals(childName)) {
                            exception = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            if (!(child instanceof String) || !(sChild = (String)child).equals(className) && !sChild.equals("*")) continue;
            done = true;
            if (!childValue.equals(ONCE)) continue;
            i = 0;
            while (i < numberElements && !exception) {
                containedElement = this.elements.axmlElementAt(i);
                if (containedElement.getName().equals(sChild)) {
                    exception = true;
                }
                ++i;
            }
        }
        if (!done || exception) {
            throw new AxmlElementCannotBeAddedException();
        }
        this.elements.addAxmlElementAt(axmlElement, index);
        axmlElement.setAxmlParentElement(this);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public AxmlElement axmlElementAt(int index) throws ArrayIndexOutOfBoundsException {
        return this.elements.axmlElementAt(index);
    }

    public int axmlElementIndex(AxmlElement axmlElement) throws AxmlElementNotFoundException {
        return this.elements.axmlElementIndex(axmlElement);
    }

    public void removeAxmlElement(int index) {
        AxmlElement axmlElement = this.axmlElementAt(index);
        this.removeAxmlElement(axmlElement);
    }

    public void removeAxmlElement(AxmlElement axmlElement) {
        axmlElement.setAxmlParentElement(null);
        this.elements.removeAxmlElement(axmlElement);
    }

    public void removeAll() {
        this.elements.removeAll();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areAxmlChildrenSane(AxmlDebugInterface axmlDebug) {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        AxmlElement containedElement = null;
        Enumeration keys = this.oChildrenRules.keys();
        while (keys.hasMoreElements()) {
            AxmlError axmlError;
            int i;
            Object child = keys.nextElement();
            String childValue = (String)this.oChildrenRules.get(child);
            if (child instanceof Vector) {
                Vector vChild = (Vector)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                int numberChild = vChild.size();
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    containedElement = this.elements.axmlElementAt(i);
                    int j = 0;
                    while (j < numberChild && !done) {
                        String childName = (String)vChild.elementAt(j);
                        if (containedElement.getName().equals(childName)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done) continue;
                axmlError = new AxmlError(this.getName() + COLON + "Child missing " + child);
                axmlDebug.addError(axmlError);
                if (!sane) continue;
                sane = false;
                continue;
            }
            if (!(child instanceof String)) continue;
            String sChild = (String)child;
            if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
            done = false;
            i = 0;
            while (i < numberElements && !done) {
                containedElement = this.elements.axmlElementAt(i);
                if (containedElement.getName().equals(sChild)) {
                    done = true;
                }
                ++i;
            }
            if (done) continue;
            axmlError = new AxmlError(this.getName() + COLON + "Child missing " + child);
            axmlDebug.addError(axmlError);
            sane = false;
        }
        return sane;
    }

    public void addAxmlAttribute(String name, String value) throws AxmlAttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new AxmlAttributeCannotBeAddedException();
        }
        if (value != null) {
            this.oAttributes.addAttribute(name, value);
        }
    }

    public String getAxmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public boolean doesAxmlAttributeExists(String name) {
        String attrValue = null;
        attrValue = this.oAttributes.getValue(name);
        return attrValue != null;
    }

    public AxmlAttributeInterface getAxmlAttributes() {
        return this.oAttributes;
    }

    public void removeAxmlAttribute(String name) {
        this.oAttributes.remove(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areAxmlAttributesSane(AxmlDebugInterface axmlDebug) {
        boolean sane = true;
        String value = null;
        AxmlError axmlError = null;
        if (this.requiredAttributes != null) {
            int i = 0;
            while (i < this.requiredAttributes.length) {
                value = this.oAttributes.getValue(this.requiredAttributes[i]);
                if (value == null) {
                    axmlError = new AxmlError(this.getName() + COLON + "Required attribute " + this.requiredAttributes[i] + " not Added ");
                    axmlDebug.addError(axmlError);
                }
                if (value == null && sane) {
                    sane = false;
                }
                ++i;
            }
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        String head = ONCE;
        if (!startTag.equals(ONCE)) {
            head = LESSERTHAN + startTag + this.oAttributes.getContents();
            head = head + GREATERTHAN;
        }
        return head;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        String tail = ONCE;
        if (!endTag.equals(ONCE)) {
            tail = "</" + endTag + GREATERTHAN + NEWLINE;
        }
        return tail;
    }

    public String getContents() {
        String body = null;
        String contents = ONCE;
        if (this instanceof AxmlDocumentInterface) {
            contents = axmlHeader;
        }
        body = this.sText == null ? this.elements.getContents() : TextUtils.transformText(this.sText) + this.elements.getContents();
        if (this instanceof AxmlFormInterface) {
            body = body + this.formUrlHack();
        }
        return contents + this.getHead() + body + this.getTail();
    }

    public String getXmlContents() {
        String body = null;
        body = this.sText == null ? this.elements.getContents() : TextUtils.transformText(this.sText) + this.elements.getContents();
        return this.getHead() + body + this.getTail();
    }

    public void setContents(String contents) {
    }

    public void setText(String text) throws AxmlAttributeCannotBeAddedException {
        throw new AxmlAttributeCannotBeAddedException();
    }

    public String getText() {
        return this.sText;
    }

    public void setAxmlParentElement(AxmlElement axmlParentElement) {
        this.oAxmlParentElement = axmlParentElement;
    }

    public AxmlElement getAxmlParentElement() {
        return this.oAxmlParentElement;
    }

    public static String[] getAxmlDataTypes() {
        return SAxmlDataTypes;
    }

    public static boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SAxmlDataTypes.length && !found) {
            if (dataType.equals(SAxmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return AXML_PCDATA;
    }

    public AxmlDebugInterface getDebug() {
        AxmlDebug axmlDebug = new AxmlDebug();
        axmlDebug.setName(this.getName());
        this.areAxmlChildrenSane(axmlDebug);
        this.areAxmlAttributesSane(axmlDebug);
        return axmlDebug;
    }

    public void addExtension(AxmlExtensionInterface extension) {
        this.extensions_.addExtension(extension);
    }

    public AxmlExtensionCollectionInterface getExtensions() {
        return this.extensions_;
    }

    private String formUrlHack() {
        StringBuffer retVal = new StringBuffer("<formParams>");
        int elementCount = this.elements.getNumberElements();
        String delim = "?";
        int i = 0;
        while (i < elementCount) {
            AxmlElement nextAxml = this.axmlElementAt(i);
            if (nextAxml instanceof AxmlInputInterface || nextAxml instanceof AxmlTextAreaInterface || nextAxml instanceof AxmlCheckBoxInterface || nextAxml instanceof AxmlChoiceInterface) {
                retVal.append("<formParam>");
                retVal.append(nextAxml.getAxmlAttributeValue("name"));
                retVal.append("=$(");
                retVal.append(nextAxml.getAxmlAttributeValue("name"));
                retVal.append(CLOSEBRACE);
                retVal.append("</formParam>");
            }
            ++i;
        }
        retVal.append("</formParams>");
        return retVal.toString();
    }
}

