/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml.debug;

import com.aligo.aml.base.interfaces.AmlElement;
import com.aligo.aml.debug.AmlDebugDialog;
import com.aligo.axml.debug.AxmlDebug;
import com.aligo.axml.interfaces.AxmlDebugInterface;
import com.aligo.axml.interfaces.AxmlElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class AmlDebugPresenter {
    AmlElement oAmlRoot;
    AxmlElement oAxmlRoot;
    JFrame gFrame;
    JTree gTree;

    public AmlDebugPresenter() {
        this(null);
    }

    public AmlDebugPresenter(AmlElement amlRoot) {
        this.oAmlRoot = amlRoot;
        if (this.oAmlRoot != null) {
            this.oAxmlRoot = amlRoot.getAxmlElement();
        }
    }

    private AxmlDebugInterface createDebugTree(AxmlElement axmlElement) {
        AxmlDebugInterface elementDebug = axmlElement.getDebug();
        AxmlDebug treeDebug = new AxmlDebug();
        treeDebug.setError(elementDebug.getError());
        int numberElements = axmlElement.getNumberElements();
        int i = 0;
        while (i < numberElements) {
            AxmlElement childElement = axmlElement.axmlElementAt(i);
            AxmlDebugInterface childDebug = this.createDebugTree(childElement);
            treeDebug.addError(childDebug);
            ++i;
        }
        return treeDebug;
    }

    private DefaultMutableTreeNode createTree(AxmlElement axmlElement) {
        String name = axmlElement.getName();
        AxmlDebugInterface axmlDebug = axmlElement.getDebug();
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(axmlDebug);
        int numberElements = axmlElement.getNumberElements();
        int i = 0;
        while (i < numberElements) {
            AxmlElement childElement = axmlElement.axmlElementAt(i);
            DefaultMutableTreeNode childNode = this.createTree(childElement);
            treeNode.add(childNode);
            ++i;
        }
        return treeNode;
    }

    public void handleMouse(MouseEvent e) {
        DefaultMutableTreeNode selNode = null;
        TreePath selPath = this.gTree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            selNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            AxmlDebugInterface axmlDebug = (AxmlDebugInterface)selNode.getUserObject();
            AmlDebugDialog axmlDialog = new AmlDebugDialog(this.gFrame, true, axmlDebug);
        }
    }

    private AxmlDebugInterface getFirstError(AxmlElement axmlElement) {
        AxmlDebugInterface returnDebug = null;
        AxmlDebugInterface elementDebug = axmlElement.getDebug();
        String errorStr = elementDebug.getString();
        if (errorStr.equals("")) {
            boolean done = false;
            int numberElements = axmlElement.getNumberElements();
            int i = 0;
            while (i < numberElements && !done) {
                AxmlElement childElement = axmlElement.axmlElementAt(i);
                AxmlDebugInterface childDebug = this.getFirstError(childElement);
                if (childDebug != null) {
                    returnDebug = childDebug;
                    done = true;
                }
                ++i;
            }
        } else {
            returnDebug = elementDebug;
        }
        return returnDebug;
    }

    public String getFirstErrorString() {
        AxmlDebugInterface firstDebug = this.getFirstError(this.oAxmlRoot);
        return firstDebug.getString();
    }

    public String getEntireErrorString() {
        AxmlDebugInterface rootTreeDebug = this.createDebugTree(this.oAxmlRoot);
        return rootTreeDebug.getString();
    }

    public AxmlDebugInterface getRootTreeDebug() {
        AxmlDebugInterface rootTreeDebug = this.createDebugTree(this.oAxmlRoot);
        return rootTreeDebug;
    }

    public AxmlDebugInterface getFirstTreeDebug() {
        AxmlDebugInterface firstTreeDebug = this.getFirstError(this.oAxmlRoot);
        return firstTreeDebug;
    }

    public void showDebug() {
        if (this.oAxmlRoot != null) {
            JFrame gFrame = new JFrame();
            String rootName = this.oAxmlRoot.getName();
            DefaultMutableTreeNode oRootNode = this.createTree(this.oAxmlRoot);
            this.gTree = new JTree(oRootNode);
            this.gTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    AmlDebugPresenter.this.handleMouse(e);
                }
            });
            gFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            gFrame.getContentPane().setLayout(new BorderLayout());
            gFrame.getContentPane().add((Component)new JScrollPane(this.gTree), "Center");
            ((Component)gFrame).setSize(600, 600);
            gFrame.show();
        }
    }
}

