/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml;

import com.aligo.aml.AmlContainer;
import com.aligo.aml.AmlOrderedConstraints;
import com.aligo.aml.AmlOrderedLayout;
import com.aligo.aml.AmlStyle;
import com.aligo.aml.AmlTableCol;
import com.aligo.aml.AmlTableHead;
import com.aligo.aml.base.AmlTableRowElement;
import com.aligo.aml.base.interfaces.AmlElement;
import com.aligo.axml.AxmlTableRow;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.exceptions.ElementCannotBeAddedException;

public class AmlTableRow
extends AmlTableRowElement {
    private AxmlTableRow axmlTableRow_ = new AxmlTableRow();
    private boolean switchedChoice_ = false;

    public AmlTableRow() {
    }

    public AmlTableRow(AmlTableCol amltablecol) throws ElementCannotBeAddedException {
        this.addAmlTableCol(amltablecol);
    }

    public AmlTableRow(AmlTableHead amltablehead) throws ElementCannotBeAddedException {
        this.addAmlTableHead(amltablehead);
    }

    public void addAmlTableCol(AmlTableCol amltablecol) throws ElementCannotBeAddedException {
        if (this.switchedChoice_) {
            amltablecol.switchChoice();
        }
        this.axmlTableRow_.addAxmlElement(amltablecol.getAxmlElement());
    }

    public void addAmlTableHead(AmlTableHead amltablehead) throws ElementCannotBeAddedException {
        this.axmlTableRow_.addAxmlElement(amltablehead.getAxmlElement());
        try {
            this.setHeader(true);
        }
        catch (AttributeCannotBeAddedException ex) {
            throw new ElementCannotBeAddedException("Error designating row as table header: " + ex.getMessage());
        }
    }

    public void setHeader(boolean isHeader) throws AttributeCannotBeAddedException {
        String boolStr = new Boolean(isHeader).toString();
        this.axmlTableRow_.addAxmlAttribute("header", boolStr);
    }

    public void setPersist(boolean flag) throws AttributeCannotBeAddedException {
        this.axmlTableRow_.addAxmlAttribute("persist", new Boolean(flag).toString());
    }

    public AxmlElement getAxmlElement() {
        return this.axmlTableRow_;
    }

    protected void switchChoice() throws ElementCannotBeAddedException {
        if (!this.switchedChoice_) {
            int i = 0;
            while (i < this.elements.getNumberElements()) {
                AmlElement amlElement = this.elements.amlElementAt(i);
                if (amlElement instanceof AmlTableCol) {
                    ((AmlTableCol)amlElement).switchChoice();
                }
                ++i;
            }
        }
        this.switchedChoice_ = true;
    }

    public void addAmlContainer(AmlContainer amlContainer) throws ElementCannotBeAddedException {
        this.axmlTableRow_.addAxmlElement(amlContainer.getAxmlElement());
    }

    public void addAmlStyle(AmlStyle amlStyle) throws ElementCannotBeAddedException {
        this.axmlTableRow_.addExtension(amlStyle.getExtensionObject());
    }

    public void addAmlOrderedLayout(AmlOrderedLayout amlOrderedLayout) throws ElementCannotBeAddedException {
        this.axmlTableRow_.addExtension(amlOrderedLayout.getExtensionObject());
    }

    public void addAmlOrderedConstraints(AmlOrderedConstraints amlOrderedConstraints) throws ElementCannotBeAddedException {
        this.axmlTableRow_.addExtension(amlOrderedConstraints.getExtensionObject());
    }

    public String getName() {
        return "AmlTableRow";
    }
}

