/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml;

import com.aligo.aml.base.AmlStyleElement;
import com.aligo.aml.base.interfaces.AmlExtensionInterface;
import com.aligo.axml.interfaces.AxmlExtensionInterface;
import com.aligo.exceptions.AligoException;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.extensions.style.StyleExtension;
import com.aligo.profile.interfaces.UAQueryInterface;
import com.aligo.profile.interfaces.UAQueryManagerInterface;

public class AmlStyle
extends AmlStyleElement
implements AmlExtensionInterface {
    private StyleExtension style_ = new StyleExtension();
    private boolean queryMethodExists = false;
    private boolean styleSpecExists = false;
    private UAQueryManagerInterface uqm = null;

    public AmlStyle() {
        this.style_.setName("AmlStyle");
    }

    public void setUAQueryManager(UAQueryManagerInterface uqm) {
        this.uqm = uqm;
    }

    public void setUAQuery(String uaQuery) throws AttributeCannotBeAddedException {
        if (!this.queryMethodExists) {
            try {
                if (this.uqm != null) {
                    UAQueryInterface query = this.uqm.getUAQueryByName(uaQuery);
                    if (query != null) {
                        this.style_.setUAQuery(query);
                    } else {
                        throw new AttributeCannotBeAddedException("UA query does not exist by that name, " + uaQuery);
                    }
                }
                this.queryMethodExists = true;
            }
            catch (AligoException e) {
                throw new AttributeCannotBeAddedException(e.getMessage());
            }
        }
    }

    public void setProtocol(String protocol) throws AttributeCannotBeAddedException {
        if (!this.queryMethodExists) {
            this.style_.setProtocol(protocol);
            this.queryMethodExists = true;
        }
    }

    public void setDevice(String device) throws AttributeCannotBeAddedException {
        if (!this.queryMethodExists) {
            this.style_.setDevice(device);
            this.queryMethodExists = true;
        }
    }

    public void setStyleId(String styleId) throws AttributeCannotBeAddedException {
        if (!this.styleSpecExists) {
            this.style_.setStyleId(styleId);
            this.styleSpecExists = true;
        }
    }

    public void setInlineStyle(String inlineStyle) throws AttributeCannotBeAddedException {
        if (!this.styleSpecExists) {
            this.style_.setInlineStyle(inlineStyle);
            this.styleSpecExists = true;
        }
    }

    public AxmlExtensionInterface getExtensionObject() {
        return this.style_;
    }

    public String getName() {
        return "AmlStyle";
    }
}

