/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.aml;

import com.aligo.aml.AmlContainer;
import com.aligo.aml.AmlGridBagConstraints;
import com.aligo.aml.AmlOrderedConstraints;
import com.aligo.aml.AmlStyle;
import com.aligo.aml.base.AmlImageElement;
import com.aligo.axml.AxmlImage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.exceptions.ElementCannotBeAddedException;
import com.aligo.tools.image.DPOImage;

public class AmlImage
extends AmlImageElement {
    private AxmlImage axmlImage_ = new AxmlImage();

    public AmlImage() {
    }

    public AmlImage(DPOImage dpoImage) throws AttributeCannotBeAddedException {
        this();
        this.setSrc(dpoImage.getSource());
        this.setAlt(dpoImage.getAlternate());
        if (dpoImage.getAlignment() != null) {
            this.setAlign(dpoImage.getAlignment().getAttributeValue());
        }
        if (dpoImage.getHeight() > 0) {
            this.setHeight(dpoImage.getHeight());
        }
        if (dpoImage.getWidth() > 0) {
            this.setWidth(dpoImage.getWidth());
        }
        this.setVspace(dpoImage.getVSpace());
        this.setHspace(dpoImage.getHSpace());
        this.setPersist(dpoImage.isPersist());
    }

    public void setSrc(String imageSrc) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("src", imageSrc);
        this.axmlImage_.addAxmlAttribute("src", imageSrc);
    }

    public void setAlt(String altText) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("alt", altText);
        this.axmlImage_.addAxmlAttribute("alt", altText);
    }

    public void setAlign(String align) throws AttributeCannotBeAddedException {
        if (align.equals("top") || align.equals("middle") || align.equals("left") || align.equals("right")) {
            this.addAmlAttribute("align", align);
            this.axmlImage_.addAxmlAttribute("align", align);
        } else {
            this.addAmlAttribute("align", "bottom");
            this.axmlImage_.addAxmlAttribute("align", "bottom");
        }
    }

    public void setHeight(int height) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("height", new Integer(height).toString());
        this.axmlImage_.addAxmlAttribute("height", new Integer(height).toString());
    }

    public void setHeight(String height) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("height", height);
        this.axmlImage_.addAxmlAttribute("height", height);
    }

    public void setWidth(int width) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("width", new Integer(width).toString());
        this.axmlImage_.addAxmlAttribute("width", new Integer(width).toString());
    }

    public void setWidth(String width) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("width", width);
        this.axmlImage_.addAxmlAttribute("width", width);
    }

    public void setVspace(int vspace) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("vspace", new Integer(vspace).toString());
        this.axmlImage_.addAxmlAttribute("vspace", new Integer(vspace).toString());
    }

    public void setVspace(String vspace) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("vspace", vspace);
        this.axmlImage_.addAxmlAttribute("vspace", vspace);
    }

    public void setHspace(int hspace) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("hspace", new Integer(hspace).toString());
        this.axmlImage_.addAxmlAttribute("hspace", new Integer(hspace).toString());
    }

    public void setHspace(String hspace) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("hspace", hspace);
        this.axmlImage_.addAxmlAttribute("hspace", hspace);
    }

    public void setPersist(boolean flag) throws AttributeCannotBeAddedException {
        this.addAmlAttribute("persist", new Boolean(flag).toString());
        this.axmlImage_.addAxmlAttribute("persist", new Boolean(flag).toString());
    }

    public void addAmlContainer(AmlContainer amlContainer) throws ElementCannotBeAddedException {
        this.axmlImage_.addAxmlElement(amlContainer.getAxmlElement());
    }

    public void addAmlStyle(AmlStyle amlStyle) throws ElementCannotBeAddedException {
        this.axmlImage_.addExtension(amlStyle.getExtensionObject());
    }

    public AxmlElement getAxmlElement() {
        return this.axmlImage_;
    }

    public void addAmlOrderedConstraints(AmlOrderedConstraints amlOrderedConstraints) throws ElementCannotBeAddedException {
        this.axmlImage_.addExtension(amlOrderedConstraints.getExtensionObject());
    }

    public void addAmlGridBagConstraints(AmlGridBagConstraints amlGridBagConstraints) throws ElementCannotBeAddedException {
        this.axmlImage_.addExtension(amlGridBagConstraints.getExtensionObject());
    }

    public String getName() {
        return "AmlImage";
    }
}

