/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.profile.config;

import com.aligo.config.SystemConfig;
import com.aligo.exceptions.AligoException;
import com.aligo.parsing.XMLElement;
import com.aligo.profile.QueryObject;
import com.aligo.profile.UAQuery;
import com.aligo.profile.interfaces.UAQueryInterface;
import com.aligo.profile.interfaces.UAQueryManagerFactory;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;

public class QAManagerConfig {
    private static SystemConfig sysconfig = new SystemConfig();
    public static final String UAQUERY_PATH = "/UAQueries";
    public static final String UAQUERY = "UAQuery";
    public static final String PRIORITY = "priority";
    public static final String QUERY_NAME = "queryName";
    public static final String QUERY_OBJECTS = "queryObjects";
    public static final String QUERY_OBJECT = "queryObject";
    public static final String GETTER = "getter";
    public static final String COMPARITOR = "comparitor";
    public static final String VALUE = "compareValue";
    public static final String NEGATE = "negate";

    public static void init(InputStreamReader configFile) throws AligoException {
        try {
            sysconfig.init((Reader)configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AligoException(e.getMessage());
        }
    }

    public static String resolve(String xpath) {
        return sysconfig.resolve(xpath);
    }

    public static int count(String xpath) {
        return sysconfig.getCount(xpath);
    }

    public static void populateQueryManagerUsingXML() {
        Enumeration uaQueries = sysconfig.getElements(UAQUERY_PATH);
        int index = 0;
        while (uaQueries.hasMoreElements()) {
            XMLElement uaQuery = (XMLElement)uaQueries.nextElement();
            if (!uaQuery.getName().equals(UAQUERY)) continue;
            UAQuery uaQ = new UAQuery();
            Enumeration uaQueryData = sysconfig.getElements("/UAQueries/UAQuery[" + index + "]");
            while (uaQueryData.hasMoreElements()) {
                XMLElement theUaQuery = (XMLElement)uaQueryData.nextElement();
                if (theUaQuery.getName().equals(PRIORITY)) {
                    uaQ.setPriority(new Integer(theUaQuery.getData()));
                }
                if (theUaQuery.getName().equals(QUERY_NAME)) {
                    uaQ.setQueryName(theUaQuery.getData());
                }
                if (!theUaQuery.getName().equals(QUERY_OBJECTS)) continue;
                Enumeration queryObjects = sysconfig.getElements("/UAQueries/UAQuery[" + index + "]" + "/" + QUERY_OBJECTS);
                int index2 = 0;
                while (queryObjects.hasMoreElements()) {
                    XMLElement aQueryObject = (XMLElement)queryObjects.nextElement();
                    if (!aQueryObject.getName().equals(QUERY_OBJECT)) continue;
                    Enumeration queryObjectData = sysconfig.getElements("/UAQueries/UAQuery[" + index + "]" + "/" + QUERY_OBJECTS + "/" + QUERY_OBJECT + "[" + index2 + "]");
                    QueryObject qO = new QueryObject();
                    while (queryObjectData.hasMoreElements()) {
                        XMLElement theQueryObjectData = (XMLElement)queryObjectData.nextElement();
                        if (theQueryObjectData.getName().equals(GETTER)) {
                            qO.setGetter(theQueryObjectData.getData());
                        }
                        if (theQueryObjectData.getName().equals(COMPARITOR)) {
                            qO.setComparitor(theQueryObjectData.getData());
                        }
                        if (theQueryObjectData.getName().equals(VALUE)) {
                            qO.setCompareValue(theQueryObjectData.getData());
                        }
                        if (!theQueryObjectData.getName().equals(NEGATE)) continue;
                        qO.setNegate(new Boolean(theQueryObjectData.getData()));
                    }
                    try {
                        uaQ.addQueryOption(qO);
                    }
                    catch (AligoException ae) {
                        ae.printStackTrace();
                    }
                    ++index2;
                }
            }
            try {
                UAQueryManagerFactory.getUAQueryManager().addUAQuery(uaQ.getQueryName(), (UAQueryInterface)uaQ);
            }
            catch (AligoException ae) {
                ae.printStackTrace();
            }
            ++index;
        }
    }
}

