/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.profile;

import com.aligo.exceptions.AligoException;
import com.aligo.profile.QueryObject;
import com.aligo.profile.UAQuery;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.profile.interfaces.UAQueryInterface;
import com.aligo.profile.interfaces.UAQueryManagerFactory;
import com.aligo.profile.interfaces.UAQueryManagerInterface;
import java.util.HashMap;
import java.util.Iterator;

public class UAQueryManager
implements UAQueryManagerInterface {
    HashMap allQuerys = new HashMap();

    public UAQueryInterface getUAQueryByName(String queryName) {
        return (UAQueryInterface)this.allQuerys.get(queryName);
    }

    public void addUAQuery(String queryName, UAQueryInterface uqi) {
        this.allQuerys.put(queryName, uqi);
    }

    public Iterator allQueries() {
        return this.allQuerys.keySet().iterator();
    }

    public boolean doMatch(UAProfile up, String qName) throws AligoException {
        UAQueryInterface uaQuery = this.getUAQueryByName(qName);
        if (uaQuery != null) {
            return uaQuery.match(up);
        }
        throw new AligoException(qName + " does not exist in the UAQuery.xml");
    }

    public int matchPriority(UAProfile up, String qName) {
        UAQueryInterface uaQ = this.getUAQueryByName(qName);
        if (uaQ != null && uaQ.match(up)) {
            return uaQ.getPriority();
        }
        return -1;
    }

    public String bestMatch(UAProfile up) {
        Iterator keys = this.allQuerys.keySet().iterator();
        int maxVal = -1;
        String highestMatchingPriority = null;
        while (keys.hasNext()) {
            String latestKey = keys.next().toString();
            if (this.matchPriority(up, latestKey) <= maxVal) continue;
            maxVal = this.matchPriority(up, latestKey);
            highestMatchingPriority = latestKey;
        }
        return highestMatchingPriority;
    }

    public void populateQueryManager() throws AligoException {
        UAQuery myTest = new UAQuery();
        myTest.setPriority(100);
        myTest.setQueryName("Testing");
        QueryObject qo = new QueryObject();
        qo.setGetter("isVoiceInputCapable");
        qo.setComparitor(0);
        qo.setCompareValue("false");
        try {
            myTest.addQueryOption(qo);
        }
        catch (AligoException ae) {
            ae.printStackTrace();
        }
        UAQueryManagerFactory.getUAQueryManager().addUAQuery(myTest.getQueryName(), (UAQueryInterface)myTest);
    }
}

