/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.image;

import com.aligo.aml.AmlImage;
import com.aligo.exceptions.AligoException;
import com.aligo.exceptions.AttributeCannotBeAddedException;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.profile.interfaces.UAQueryManagerFactory;
import com.aligo.profile.interfaces.UAQueryManagerInterface;
import com.aligo.tools.image.DPOImage;
import com.aligo.tools.image.ImageLibrary;
import java.util.Iterator;

public class ImageFactory {
    static ImageLibrary imageLibrary;
    ImageLibrary localImageLibrary;

    public void setLocalImageLibrary(ImageLibrary imageLibrary) {
        this.localImageLibrary = imageLibrary;
    }

    public static synchronized void setImageLibrary(ImageLibrary newImageLibrary) {
        imageLibrary = newImageLibrary;
    }

    private static UAQueryManagerInterface getUQManager() {
        try {
            return UAQueryManagerFactory.getUAQueryManager();
        }
        catch (AligoException ae) {
            ae.printStackTrace();
            return null;
        }
    }

    private static DPOImage getBestDPO(String mapName, UAProfile uap, ImageLibrary useImageLibrary) {
        DPOImage retVal = null;
        int highestPriority = -1;
        int currentPriority = -1;
        Iterator iterator = useImageLibrary.getImageByName(mapName).getDPOImagesIterator();
        while (iterator.hasNext()) {
            DPOImage nextDPO = (DPOImage)iterator.next();
            currentPriority = ImageFactory.getUQManager().matchPriority(uap, nextDPO.getDPOName());
            if (currentPriority <= highestPriority) continue;
            retVal = nextDPO;
            highestPriority = currentPriority;
        }
        return retVal;
    }

    public static AmlImage getAmlImage(String mapName, UAProfile uap) throws AttributeCannotBeAddedException {
        return ImageFactory.getAmlImage(mapName, uap, imageLibrary);
    }

    public AmlImage getLocalAmlImage(String mapName, UAProfile uap) throws AttributeCannotBeAddedException {
        return ImageFactory.getAmlImage(mapName, uap, this.localImageLibrary);
    }

    private static AmlImage getAmlImage(String mapName, UAProfile uap, ImageLibrary useImageLibrary) throws AttributeCannotBeAddedException {
        DPOImage dpo = ImageFactory.getBestDPO(mapName, uap, useImageLibrary);
        if (dpo != null) {
            return new AmlImage(dpo);
        }
        return null;
    }
}

