/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.mail;

import com.sun.portal.wireless.taglibs.base.CommandTag;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.mail.MailContext;
import com.sun.portal.wireless.taglibs.mail.MsgBean;
import java.util.Date;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Store;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class SendMessageTag
extends CommandTag {
    private String msgName = null;
    private String fwdIdx = null;
    private String replyIdx = null;
    static final String delim = "\n\n   --------------------------------------------------------\n\n";

    public boolean execute() throws JspException {
        MailContext mc = null;
        try {
            mc = MailContext.getContext(((TagSupport)this).pageContext);
            MsgBean msg = (MsgBean)((TagSupport)this).pageContext.getAttribute(this.msgName);
            if (this.fwdIdx != null || this.replyIdx != null) {
                String idx = null;
                idx = this.fwdIdx != null ? this.fwdIdx : this.replyIdx;
                int msgIdx = 0;
                msgIdx = Integer.parseInt(idx);
                MsgBean[] msgs = mc.getMsgsCollection();
                MsgBean tmpMsg = msgs[msgIdx];
                if (this.fwdIdx != null) {
                    String oldText = msg.getText();
                    msg.setText(oldText + delim + tmpMsg.getText());
                    if (tmpMsg.isHasattachments()) {
                        msg.setAttachments(tmpMsg.getAttachments());
                    }
                } else if (this.replyIdx != null && mc.includeMsg()) {
                    String orgText = msg.getText();
                    String replyText = tmpMsg.getReplyText("> ");
                    msg.setText(orgText + "\n" + replyText);
                }
            }
            if (mc.includeSig()) {
                String orgText = msg.getText();
                msg.setText(orgText + "\n\n" + mc.getSignature());
            }
            msg.send();
            if (mc.saveSentMail()) {
                try {
                    Store mailStore = mc.getMailStore();
                    Folder sentMail = mailStore.getFolder("Sent");
                    if (!sentMail.exists()) {
                        sentMail.create(1);
                    }
                    Date date = new Date();
                    Message[] sMsg = new Message[]{msg.getObject()};
                    sMsg[0].setHeader("Date", date.toString());
                    sentMail.appendMessages(sMsg);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.release();
            return true;
        }
        catch (SendFailedException sfe) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".execute(): Error code MAIL_001: Wrong email address."), (Throwable)sfe);
            this.release();
            mc.setErrorCode("MAIL_001");
            return false;
        }
        catch (MessagingException me) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".execute(): Error code MAIL_002: send failed."), (Throwable)me);
            this.release();
            mc.setErrorCode("MAIL_002");
            return false;
        }
        catch (Exception e) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".execute():  failed."), (Throwable)e);
            this.release();
            mc.setErrorCode("");
            return false;
        }
    }

    public void release() {
        super.release();
        this.msgName = null;
        this.fwdIdx = null;
        this.replyIdx = null;
    }

    public void setMsgname(String msgName) {
        this.msgName = this.evalAttribute(msgName);
    }

    public void setFwdindex(String idx) {
        this.fwdIdx = this.evalAttribute(idx);
    }

    public void setReplyindex(String idx) {
        this.replyIdx = this.evalAttribute(idx);
    }
}

