/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.mail;

import com.sun.portal.wireless.taglibs.base.CommandTag;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.mail.MailContext;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.SSOAdapterFactory;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class POPCollectTag
extends CommandTag {
    private String configName = null;

    public boolean execute() throws JspException {
        MailContext mc;
        try {
            mc = MailContext.getContext(((TagSupport)this).pageContext);
        }
        catch (Exception e) {
            throw new JspException(((Object)((Object)this)).getClass().getName() + ".execute():  Couldn't get mail context:  " + e.getMessage());
        }
        mc.setErrorCode("");
        SSOAdapterFactory factory = SSOAdapterFactory.getInstance();
        SSOAdapter popSSOAdapter = null;
        try {
            popSSOAdapter = factory.getSSOAdapter(this.configName, (HttpServletRequest)((TagSupport)this).pageContext.getRequest(), null, null, "mapInstance");
        }
        catch (SSOAdapterException e) {
            Util.logError((String)(((Object)((Object)this)).getClass().getName() + ".execute(): Unable to get SSO Helper"), (Throwable)e);
            this.release();
            return false;
        }
        Folder dfolder = null;
        try {
            Store store = mc.getMailStore();
            dfolder = store.getFolder("INBOX");
            if (!dfolder.exists()) {
                dfolder.create(1);
            }
        }
        catch (MessagingException e) {
            Util.logError((String)(((Object)((Object)this)).getClass().getName() + ".execute(): get folder failed"), (Throwable)e);
            this.release();
            return false;
        }
        try {
            Store popStore = (Store)popSSOAdapter.getConnection();
            Folder popInbox = popStore.getFolder("INBOX");
            if (!popInbox.isOpen()) {
                popInbox.open(2);
            }
            Message[] msgs = popInbox.getMessages();
            popInbox.copyMessages(msgs, dfolder);
            boolean expunge = false;
            String popDelete = popSSOAdapter.getProperties().getProperty("popDelete");
            if (popDelete != null && popDelete.equalsIgnoreCase("true")) {
                popInbox.setFlags(msgs, new Flags(Flags.Flag.DELETED), true);
                expunge = true;
            }
            popInbox.close(expunge);
            popStore.close();
        }
        catch (Exception e) {
            Util.logError((String)(((Object)((Object)this)).getClass().getName() + ".execute(): "), (Throwable)e);
            this.release();
            return false;
        }
        this.release();
        return true;
    }

    public void release() {
        super.release();
        this.configName = null;
    }

    public void setConfig(String name) {
        this.configName = this.evalAttribute(name);
    }
}

